/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.migrators;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.teleport.SettingHandler;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.teleport.points.Warp;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class EssentialsMigrator {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    public static void migrate() {
        EssentialsMigrator.migrate(null, HuskHomes.getSettings().getServerID());
    }

    public static void migrate(String worldFilter, String targetServer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            HuskHomes.backupDatabase();
            File essentialsDataFolder = new File(Bukkit.getWorldContainer() + File.separator + "plugins" + File.separator + "Essentials");
            if (essentialsDataFolder.exists()) {
                File[] warpFiles;
                File essentialsWarpsFolder;
                File[] playerFiles;
                plugin.getLogger().info("Essentials plugin data found!");
                if (worldFilter != null) {
                    plugin.getLogger().info("Started Filtered Migration from EssentialsX:\n\u2022 World to migrate from: " + worldFilter + "\n\u2022 Target server: " + targetServer);
                } else {
                    plugin.getLogger().info("Started Migration from EssentialsX...\n");
                }
                File essentialsPlayerDataFolder = new File(Bukkit.getWorldContainer() + File.separator + "plugins" + File.separator + "Essentials" + File.separator + "userdata");
                if (essentialsPlayerDataFolder.exists() && (playerFiles = essentialsPlayerDataFolder.listFiles()) != null) {
                    for (File playerFile : playerFiles) {
                        try {
                            String fileName = playerFile.getName();
                            UUID playerUUID = UUID.fromString(fileName.substring(0, fileName.lastIndexOf(".")));
                            YamlConfiguration playerFileConfig = YamlConfiguration.loadConfiguration((File)playerFile);
                            String playerName = playerFileConfig.getString("last-account-name", playerFileConfig.getString("lastAccountName"));
                            try {
                                try (Connection connection = HuskHomes.getConnection();){
                                    ConfigurationSection homesSection;
                                    if (!DataManager.playerExists(playerUUID, connection).booleanValue()) {
                                        DataManager.createPlayer(playerUUID, playerName, connection);
                                    }
                                    if ((homesSection = playerFileConfig.getConfigurationSection("homes")) == null) continue;
                                    Set essentialsHomes = homesSection.getKeys(false);
                                    for (String homeName : essentialsHomes) {
                                        try {
                                            String worldID;
                                            block53: {
                                                worldID = playerFileConfig.getString("homes." + homeName + ".world", "world");
                                                try {
                                                    UUID worldUUID = UUID.fromString(worldID);
                                                    World world = Bukkit.getWorld((UUID)worldUUID);
                                                    if (world != null) {
                                                        worldID = world.getName();
                                                        break block53;
                                                    }
                                                    plugin.getLogger().warning("\u2716 Could not migrate " + homeName + " as the world value was a UUID and is not loaded on this server.");
                                                    continue;
                                                }
                                                catch (IllegalArgumentException worldUUID) {
                                                    // empty catch block
                                                }
                                            }
                                            if (worldFilter != null && !worldFilter.equalsIgnoreCase(worldID)) continue;
                                            double x = playerFileConfig.getDouble("homes." + homeName + ".x");
                                            double y = playerFileConfig.getDouble("homes." + homeName + ".y");
                                            double z = playerFileConfig.getDouble("homes." + homeName + ".z");
                                            float pitch = (float)playerFileConfig.getDouble("homes." + homeName + ".pitch");
                                            float yaw = (float)playerFileConfig.getDouble("homes." + homeName + ".yaw");
                                            String homeDescription = MessageManager.getRawMessage("home_default_description", playerName);
                                            if (DataManager.homeExists(playerName, homeName, connection).booleanValue()) {
                                                plugin.getLogger().warning("\u2716 Failed to migrate home " + homeName + " (Already exists!)");
                                                continue;
                                            }
                                            DataManager.addHome(new Home(new TeleportationPoint(worldID, x, y, z, yaw, pitch, targetServer), playerName, playerUUID, homeName, homeDescription, false, Instant.now().getEpochSecond()), playerUUID, connection);
                                            plugin.getLogger().info("\u2192 Migrated home " + homeName);
                                        }
                                        catch (IllegalArgumentException | NullPointerException e) {
                                            plugin.getLogger().warning("\u2716 Failed to migrate home " + homeName + "!");
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                catch (SQLException e) {
                                    plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred migrating Essentials home data.", e);
                                }
                            }
                            catch (NullPointerException e) {}
                        }
                        catch (IllegalArgumentException fileName) {
                            // empty catch block
                        }
                    }
                }
                if ((essentialsWarpsFolder = new File(Bukkit.getWorldContainer() + File.separator + "plugins" + File.separator + "Essentials" + File.separator + "warps")).exists() && (warpFiles = essentialsWarpsFolder.listFiles()) != null) {
                    for (File warpFile : warpFiles) {
                        try (Connection connection = HuskHomes.getConnection();){
                            YamlConfiguration warpFileConfig = YamlConfiguration.loadConfiguration((File)warpFile);
                            String warpName = warpFileConfig.getString("name");
                            String worldID = warpFileConfig.getString("world", "world");
                            try {
                                UUID worldUUID = UUID.fromString(worldID);
                                World world = Bukkit.getWorld((UUID)worldUUID);
                                if (world == null) {
                                    plugin.getLogger().warning("\u2716 Could not migrate " + warpName + " as the world value was a UUID and is not loaded on this server.");
                                    continue;
                                }
                                worldID = world.getName();
                            }
                            catch (IllegalArgumentException worldUUID) {
                                // empty catch block
                            }
                            if (worldFilter != null && !worldFilter.equalsIgnoreCase(worldID)) continue;
                            double x = warpFileConfig.getDouble("x");
                            double y = warpFileConfig.getDouble("y");
                            double z = warpFileConfig.getDouble("z");
                            float yaw = (float)warpFileConfig.getDouble("yaw");
                            float pitch = (float)warpFileConfig.getDouble("pitch");
                            if (DataManager.warpExists(warpName, connection)) {
                                plugin.getLogger().warning("\u2716 Failed to migrate warp " + warpName + " (Already exists!)");
                                continue;
                            }
                            DataManager.addWarp(new Warp(new TeleportationPoint(worldID, x, y, z, yaw, pitch, targetServer), warpName, MessageManager.getRawMessage("warp_default_description"), Instant.now().getEpochSecond()), connection);
                            plugin.getLogger().info("\u2192 Migrated warp " + warpName);
                        }
                        catch (IllegalArgumentException | NullPointerException e) {
                            plugin.getLogger().warning("\u2716 Failed to migrate warp " + warpFile.getName());
                        }
                        catch (SQLException e) {
                            plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred migrating Essentials warp data!", e);
                            return;
                        }
                    }
                }
                if (TeleportManager.getSpawnLocation() == null && HuskHomes.getSettings().doCrossServerSpawn()) {
                    File essentialsSpawnData = new File(Bukkit.getWorldContainer() + File.separator + "plugins" + File.separator + "Essentials" + File.separator + "spawn.yml");
                    if (essentialsSpawnData.exists()) {
                        plugin.getLogger().info("Migrating /spawn position from Essentials...");
                        YamlConfiguration spawnConfig = YamlConfiguration.loadConfiguration((File)essentialsSpawnData);
                        try {
                            String worldID = spawnConfig.getString("spawns.all.world", "world");
                            try {
                                UUID worldUUID = UUID.fromString(worldID);
                                World world = Bukkit.getWorld((UUID)worldUUID);
                                if (world == null) {
                                    plugin.getLogger().warning("\u2716 Could not migrate the spawn position as the world value was a UUID and is not loaded on this server.");
                                    return;
                                }
                                worldID = world.getName();
                            }
                            catch (IllegalArgumentException worldUUID) {
                                // empty catch block
                            }
                            if (worldFilter != null && !worldFilter.equalsIgnoreCase(worldID)) {
                                plugin.getLogger().warning("\u2716 Did not migrate the /spawn position as the world filter did not match.");
                                return;
                            }
                            double x = spawnConfig.getDouble("spawns.all.x");
                            double y = spawnConfig.getDouble("spawns.all.y");
                            double z = spawnConfig.getDouble("spawns.all.z");
                            float yaw = (float)spawnConfig.getDouble("spawns.all.yaw");
                            float pitch = (float)spawnConfig.getDouble("spawns.all.pitch");
                            Location spawnLocation = new Location(Bukkit.getWorld((String)worldID), x, y, z, yaw, pitch);
                            SettingHandler.setSpawnLocation(spawnLocation);
                            plugin.getLogger().info("\u2192 /spawn position has been migrated!\n");
                        }
                        catch (IllegalArgumentException | NullPointerException e) {
                            plugin.getLogger().warning("\u2716 Failed to migrate the /spawn position.\n");
                        }
                    }
                } else {
                    plugin.getLogger().info("\u2716 /spawn position migration from EssentialsX has been skipped as it has already been set or Cross Server Spawn has been enabled. Please re-set it again manually if you want.");
                }
            } else {
                plugin.getLogger().warning("Failed to Migrate from Essentials!");
                Bukkit.getLogger().warning("Could not find Essentials plugin data to migrate!");
            }
        });
    }
}

