/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport;

import java.time.Instant;
import me.william278.huskhomes2.HuskHomes;

public class TeleportRequest {
    private final String senderName;
    private final long requestExpiryTime;
    private final long requestTime;
    private final RequestType requestType;

    public TeleportRequest(String senderName, RequestType requestType) {
        this.senderName = senderName;
        this.requestType = requestType;
        this.requestTime = Instant.now().getEpochSecond();
        this.requestExpiryTime = this.requestTime + (long)HuskHomes.getSettings().getTeleportRequestExpiryTime();
    }

    public String getSenderName() {
        return this.senderName;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public boolean isExpired() {
        long currentUnixTime = Instant.now().getEpochSecond();
        return currentUnixTime > this.requestExpiryTime;
    }

    public static enum RequestType {
        TPA,
        TPA_HERE;

    }
}

