/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.integrations.VaultIntegration;
import me.william278.huskhomes2.libraries.minedown.MineDown;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.points.RandomPoint;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.util.MessageManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TimedTeleport {
    private static final HuskHomes plugin = HuskHomes.getInstance();
    private final TargetType targetType;
    private TeleportationPoint targetPoint;
    private String targetPlayerName;
    private final Player player;
    private final Location initialLocation;
    private final double initialHealth;
    private final int warmupTime = HuskHomes.getSettings().getTeleportWarmupTime();

    public TimedTeleport(Player player, TeleportationPoint targetPoint, TargetType targetType) {
        this.player = player;
        this.initialLocation = player.getLocation();
        this.initialHealth = player.getHealth();
        this.targetType = targetType;
        this.targetPoint = targetPoint;
        MessageManager.sendMessage(player, "teleporting_countdown_start", Integer.toString(this.warmupTime));
        MessageManager.sendMessage(player, "teleporting_please_stand_still");
    }

    public TimedTeleport(Player player) {
        this.player = player;
        this.initialLocation = player.getLocation();
        this.initialHealth = player.getHealth();
        this.targetType = TargetType.RANDOM;
        MessageManager.sendMessage(player, "teleporting_countdown_start", Integer.toString(this.warmupTime));
        MessageManager.sendMessage(player, "teleporting_please_stand_still");
    }

    public TimedTeleport(Player player, String targetPlayerName) {
        this.player = player;
        this.initialLocation = player.getLocation();
        this.initialHealth = player.getHealth();
        this.targetType = TargetType.PLAYER;
        this.targetPlayerName = targetPlayerName;
        MessageManager.sendMessage(player, "teleporting_countdown_start", Integer.toString(this.warmupTime));
        MessageManager.sendMessage(player, "teleporting_please_stand_still");
    }

    public void begin() {
        final int[] i = new int[]{HuskHomes.getSettings().getTeleportWarmupTime() + 1};
        new BukkitRunnable(){

            public void run() {
                Player executablePlayer = Bukkit.getPlayer((UUID)TimedTeleport.this.player.getUniqueId());
                if (executablePlayer == null) {
                    this.cancel();
                    return;
                }
                if (TimedTeleport.this.hasMoved(executablePlayer)) {
                    this.cancel();
                    if (HuskHomes.getSettings().getTeleportCancelledSound() != null) {
                        executablePlayer.playSound(executablePlayer.getLocation(), HuskHomes.getSettings().getTeleportCancelledSound(), 1.0f, 1.0f);
                    }
                    MessageManager.sendMessage(TimedTeleport.this.player, "teleporting_cancelled_movement");
                    TimedTeleport.sendWarmupMessage(TimedTeleport.this.player, "teleporting_action_bar_cancelled", new String[0]);
                    return;
                }
                if (TimedTeleport.this.hasLostHealth(executablePlayer)) {
                    this.cancel();
                    if (HuskHomes.getSettings().getTeleportCancelledSound() != null) {
                        executablePlayer.playSound(executablePlayer.getLocation(), HuskHomes.getSettings().getTeleportCancelledSound(), 1.0f, 1.0f);
                    }
                    MessageManager.sendMessage(TimedTeleport.this.player, "teleporting_cancelled_damage");
                    TimedTeleport.sendWarmupMessage(TimedTeleport.this.player, "teleporting_action_bar_cancelled", new String[0]);
                    return;
                }
                if (HuskHomes.getDeluxeCombatIntegration() != null && HuskHomes.getDeluxeCombatIntegration().hasDamagedPlayers(executablePlayer)) {
                    this.cancel();
                    if (HuskHomes.getSettings().getTeleportCancelledSound() != null) {
                        executablePlayer.playSound(executablePlayer.getLocation(), HuskHomes.getSettings().getTeleportCancelledSound(), 1.0f, 1.0f);
                    }
                    MessageManager.sendMessage(TimedTeleport.this.player, "teleporting_cancelled_pvp");
                    TimedTeleport.sendWarmupMessage(TimedTeleport.this.player, "teleporting_action_bar_cancelled", new String[0]);
                    return;
                }
                i[0] = i[0] - 1;
                if (i[0] == 0) {
                    this.cancel();
                    switch (TimedTeleport.this.getTargetType()) {
                        case POINT: {
                            TeleportManager.teleportPlayer(TimedTeleport.this.player, TimedTeleport.this.targetPoint);
                            break;
                        }
                        case BACK: {
                            double backCost;
                            if (HuskHomes.getSettings().doEconomy() && (backCost = HuskHomes.getSettings().getBackCost()) > 0.0) {
                                if (!VaultIntegration.takeMoney(TimedTeleport.this.player, backCost)) {
                                    MessageManager.sendMessage(TimedTeleport.this.player, "error_insufficient_funds", VaultIntegration.format(backCost));
                                    break;
                                }
                                MessageManager.sendMessage(TimedTeleport.this.player, "back_spent_money", VaultIntegration.format(backCost));
                            }
                            TeleportManager.teleportPlayer(TimedTeleport.this.player, TimedTeleport.this.getTargetPoint());
                            break;
                        }
                        case PLAYER: {
                            TeleportManager.teleportPlayer(TimedTeleport.this.player, TimedTeleport.this.getTargetPlayerName());
                            break;
                        }
                        case RANDOM: {
                            double rtpCost;
                            RandomPoint randomPoint = new RandomPoint(TimedTeleport.this.player);
                            if (randomPoint.hasFailed()) {
                                return;
                            }
                            if (HuskHomes.getSettings().doEconomy() && (rtpCost = HuskHomes.getSettings().getRtpCost()) > 0.0) {
                                if (!VaultIntegration.takeMoney(TimedTeleport.this.player, rtpCost)) {
                                    MessageManager.sendMessage(TimedTeleport.this.player, "error_insufficient_funds", VaultIntegration.format(rtpCost));
                                    break;
                                }
                                MessageManager.sendMessage(TimedTeleport.this.player, "rtp_spent_money", VaultIntegration.format(rtpCost));
                            }
                            TeleportManager.teleportPlayer(TimedTeleport.this.player, randomPoint);
                            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                try (Connection connection = HuskHomes.getConnection();){
                                    DataManager.updateRtpCoolDown(TimedTeleport.this.player, connection);
                                }
                                catch (SQLException e) {
                                    plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred carrying out a timed teleport");
                                }
                            });
                        }
                    }
                    return;
                }
                TimedTeleport.sendWarmupMessage(executablePlayer, "teleporting_action_bar_countdown", Integer.toString(i[0]));
                if (HuskHomes.getSettings().getTeleportWarmupSound() != null) {
                    executablePlayer.playSound(executablePlayer.getLocation(), HuskHomes.getSettings().getTeleportWarmupSound(), 1.0f, 1.0f);
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 20L);
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public TeleportationPoint getTargetPoint() {
        return this.targetPoint;
    }

    public String getTargetPlayerName() {
        return this.targetPlayerName;
    }

    private static void sendWarmupMessage(Player player, String messageID, String ... replacements) {
        switch (HuskHomes.getSettings().getWarmupDisplayStyle()) {
            case ACTION_BAR: {
                MessageManager.sendActionBar(player, messageID, replacements);
                break;
            }
            case TITLE: {
                player.sendTitle(TextComponent.toLegacyText((BaseComponent[])new MineDown(MessageManager.getRawMessage(messageID, replacements)).toComponent()), "", 20, 60, 20);
                break;
            }
            case SUBTITLE: {
                player.sendTitle("", TextComponent.toLegacyText((BaseComponent[])new MineDown(MessageManager.getRawMessage(messageID, replacements)).toComponent()), 20, 60, 20);
                break;
            }
            case CHAT: {
                MessageManager.sendMessage(player, messageID, replacements);
            }
        }
    }

    private static double makePositive(double d) {
        if (d < 0.0) {
            d *= -1.0;
        }
        return d;
    }

    public boolean hasLostHealth(Player p) {
        return p.getHealth() < this.initialHealth;
    }

    public boolean hasMoved(Player p) {
        double zDiff;
        double yDiff;
        Location currentLocation = p.getLocation();
        double movementThreshold = 0.1;
        double xDiff = TimedTeleport.makePositive(this.initialLocation.getX() - currentLocation.getX());
        double totalDiff = xDiff + (yDiff = TimedTeleport.makePositive(this.initialLocation.getY() - currentLocation.getY())) + (zDiff = TimedTeleport.makePositive(this.initialLocation.getZ() - currentLocation.getZ()));
        return totalDiff > 0.1;
    }

    public Player getPlayer() {
        return this.player;
    }

    public static enum TargetType {
        POINT,
        BACK,
        PLAYER,
        RANDOM;

    }
}

