/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport.points;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class RandomPoint
extends TeleportationPoint {
    private static final Set<Material> UNSAFE_BLOCKS = Collections.unmodifiableSet(EnumSet.of(Material.LAVA, new Material[]{Material.FIRE, Material.MAGMA_BLOCK, Material.CACTUS, Material.WATER, Material.OBSIDIAN, Material.JUNGLE_LEAVES, Material.SPRUCE_LEAVES, Material.OAK_LEAVES, Material.BIRCH_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES}));
    private static final int MAX_RANDOM_ATTEMPTS = 8;
    private static boolean hasFailed;

    public RandomPoint(Player player) {
        super(player.getLocation(), HuskHomes.getSettings().getServerID());
        hasFailed = false;
        Location randomLocation = this.getRandomLocation(player.getWorld());
        if (randomLocation != null) {
            this.setLocation(randomLocation, HuskHomes.getSettings().getServerID());
        } else {
            hasFailed = true;
            MessageManager.sendMessage(player, "error_rtp_randomization_timeout");
        }
    }

    private Location randomLocation(World world) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int y = 64;
        double blockCenterX = 0.5;
        double blockCenterZ = 0.5;
        int rtpRange = Math.min(HuskHomes.getSettings().getRtpRange(), (int)world.getWorldBorder().getSize() - 1);
        int x = ((Random)random).nextInt(rtpRange);
        int z = ((Random)random).nextInt(rtpRange);
        if (((Random)random).nextBoolean()) {
            x *= -1;
            blockCenterX *= -1.0;
        }
        if (((Random)random).nextBoolean()) {
            z *= -1;
            blockCenterZ *= -1.0;
        }
        Location randomLocation = new Location(world, (double)x + blockCenterX, (double)y, (double)z + blockCenterZ);
        y = world.getHighestBlockYAt(randomLocation) + 1;
        randomLocation.setY((double)y);
        return randomLocation;
    }

    private boolean isLocationSafe(Location location) {
        int x = location.getBlockX();
        int y = location.getBlockY() - 1;
        int z = location.getBlockZ();
        World world = location.getWorld();
        if (world != null) {
            if (!world.getWorldBorder().isInside(location)) {
                return false;
            }
            Block block = world.getBlockAt(x, y, z);
            Block below = world.getBlockAt(x, y - 1, z);
            Block above = world.getBlockAt(x, y + 1, z);
            if (!UNSAFE_BLOCKS.contains(block.getType()) && block.getType().isSolid() && !UNSAFE_BLOCKS.contains(above.getType())) {
                return !UNSAFE_BLOCKS.contains(below.getType());
            }
        }
        return false;
    }

    private Location getRandomLocation(World world) {
        for (int i = 0; i < 8; ++i) {
            Location randomLocation = this.randomLocation(world);
            if (!this.isLocationSafe(randomLocation)) continue;
            return randomLocation;
        }
        return null;
    }

    public boolean hasFailed() {
        return hasFailed;
    }
}

