/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport.points;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class TeleportationPoint {
    protected String server;
    protected String worldName;
    protected double x;
    protected double y;
    protected double z;
    protected float yaw;
    protected float pitch;

    public void setLocation(Location location, String server) {
        this.worldName = location.getWorld().getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.server = server;
    }

    public TeleportationPoint(Location location, String server) {
        if (location.getWorld() == null) {
            throw new IllegalStateException("The location provided has an invalid world");
        }
        this.setLocation(location, server);
    }

    public TeleportationPoint(String worldName, double x, double y, double z, float yaw, float pitch, String server) {
        this.server = server;
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Location getLocation() {
        World world = Bukkit.getWorld((String)this.worldName);
        if (world != null) {
            return new Location(world, this.x, this.y, this.z, this.yaw, this.pitch);
        }
        throw new IllegalStateException("The world \"" + this.worldName + "\" could not be found on the server; could not return location");
    }

    public String getWorldName() {
        return this.worldName;
    }

    public String getServer() {
        return this.server;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public String toString() {
        return "TeleportationPoint{server='" + this.server + "', worldName='" + this.worldName + "', x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + "}";
    }
}

