/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport.points;

import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.teleport.points.SetPoint;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.util.MessageManager;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class Warp
extends SetPoint {
    public Warp(Location location, String server, String name) {
        super(location, server, name, MessageManager.getRawMessage("warp_default_description"));
    }

    public Warp(TeleportationPoint teleportationPoint, String name, String description, long creationTime) {
        super(teleportationPoint.worldName, teleportationPoint.x, teleportationPoint.y, teleportationPoint.z, teleportationPoint.yaw, teleportationPoint.pitch, teleportationPoint.server, name, description, creationTime);
    }

    public boolean canUse(Player player) {
        return Warp.getWarpCanUse(player, this.getName());
    }

    public static boolean getWarpCanUse(Player p, String warpName) {
        if (!HuskHomes.getSettings().doPermissionRestrictedWarps()) {
            return true;
        }
        p.recalculatePermissions();
        String permissionFormat = HuskHomes.getSettings().getWarpRestrictionPermissionFormat();
        if (p.hasPermission("huskhomes.warp.*") || p.hasPermission(permissionFormat + "*")) {
            return true;
        }
        for (PermissionAttachmentInfo permissionAI : p.getEffectivePermissions()) {
            String permission = permissionAI.getPermission();
            if (!permission.contains(permissionFormat)) continue;
            try {
                if (!permission.split("\\.")[StringUtils.countMatches((String)permissionFormat, (String)".")].equalsIgnoreCase(warpName)) continue;
                return permissionAI.getValue();
            }
            catch (Exception exception) {
            }
        }
        return false;
    }
}

