/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.util;

import java.util.ArrayList;
import me.william278.huskhomes2.libraries.minedown.MineDown;
import me.william278.huskhomes2.util.MessageManager;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

public class ChatList {
    private final ArrayList<String> items;
    private final String pageChangeCommand;
    private final int itemsPerPage;
    private final int maxPage;
    private final String itemSeparator;
    private final boolean spacePageOptions;

    public ChatList(ArrayList<String> items, int itemsPerPage, String pageChangeCommand, String itemSeparator, boolean spacePageOptions) {
        this.pageChangeCommand = pageChangeCommand;
        this.items = new ArrayList();
        this.itemsPerPage = itemsPerPage;
        this.items.addAll(items);
        this.maxPage = (int)Math.ceil((double)items.size() / (double)itemsPerPage);
        this.itemSeparator = itemSeparator;
        this.spacePageOptions = spacePageOptions;
    }

    public boolean doesNotContainPage(int pageNo) {
        return pageNo > this.items.size();
    }

    public BaseComponent[] getPage(int pageNo) {
        String message;
        StringBuilder builder = new StringBuilder();
        int indexStart = (pageNo - 1) * this.itemsPerPage + 1;
        int indexEnd = indexStart - 1 + this.itemsPerPage;
        for (int i = indexStart - 1; i < indexEnd && i <= this.items.size() - 1; ++i) {
            String item = this.items.get(i);
            builder.append(item);
            if (i >= indexEnd - 1 || i >= this.items.size() - 1) continue;
            builder.append(this.itemSeparator);
        }
        if (builder.toString().equals("")) {
            builder.append(MessageManager.getRawMessage("page_no_items"));
        }
        String options = pageNo == 1 ? (pageNo == this.maxPage ? MessageManager.getRawMessage("page_options_min_max", Integer.toString(pageNo), Integer.toString(this.maxPage)) : MessageManager.getRawMessage("page_options_min", Integer.toString(pageNo), Integer.toString(this.maxPage), this.pageChangeCommand + " " + (pageNo + 1))) : (pageNo == this.maxPage ? MessageManager.getRawMessage("page_options_max", this.pageChangeCommand + " " + (pageNo - 1), Integer.toString(pageNo), Integer.toString(this.maxPage)) : MessageManager.getRawMessage("page_options", this.pageChangeCommand + " " + (pageNo - 1), Integer.toString(pageNo), Integer.toString(this.maxPage), this.pageChangeCommand + " " + (pageNo + 1)));
        if (!options.isEmpty()) {
            if (this.spacePageOptions) {
                builder.append("\n");
            }
            builder.append("\n").append(options);
        }
        return StringUtils.isEmpty((String)(message = builder.toString())) ? null : new MineDown(builder.toString()).toComponent();
    }

    public void sendPage(Player player, int number) {
        BaseComponent[] components = this.getPage(number);
        if (components != null) {
            player.spigot().sendMessage(components);
        }
    }
}

