/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.libraries.minedown.MineDown;
import net.md_5.bungee.api.ChatMessageType;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private static final Map<String, String> messages = new HashMap<String, String>();
    private static final HuskHomes plugin = HuskHomes.getInstance();

    private static void createFile(File f) {
        try {
            if (!f.createNewFile()) {
                Bukkit.getLogger().severe("Failed to create messages.yml file!");
            }
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("An error occurred while creating the messages.yml file!");
            e.printStackTrace();
        }
    }

    private static void saveFile(FileConfiguration config, File f) {
        try {
            config.save(f);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("An error occurred while saving the messages.yml file!");
        }
    }

    public static void loadMessages(String language) {
        File f = new File(plugin.getDataFolder() + File.separator + "messages_" + language + ".yml");
        if (!f.exists()) {
            MessageManager.createFile(f);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
        config.options().header(" ------------------------------ \n|      HuskHomes Messages      |\n|    Developed by William278   |\n ------------------------------ \nIf you'd like to use a different language, you can change it in the config.yml \nChange the appearance/text of messages in the plugin using this config. \nThis config makes use of MineDown formatting, with extensive support for custom colors & formats. \nFor formatting help, see: https://github.com/Phoenix616/MineDown or check the HuskHomes Wiki.");
        InputStream defaultMessageFile = plugin.getResource("languages/" + language + ".yml");
        if (defaultMessageFile != null) {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultMessageFile, StandardCharsets.UTF_8));
            config.setDefaults((Configuration)yamlConfiguration);
            config.options().copyHeader(true).copyDefaults(true);
        }
        MessageManager.saveFile((FileConfiguration)config, f);
        messages.clear();
        for (String message : config.getKeys(false)) {
            messages.put(message, StringEscapeUtils.unescapeJava((String)config.getString(message)));
        }
    }

    public static void sendMessage(Player p, String messageID, String ... placeholderReplacements) {
        MessageManager.sendMessage(p, ChatMessageType.CHAT, messageID, placeholderReplacements);
    }

    public static void sendActionBar(Player p, String messageID, String ... placeholderReplacements) {
        MessageManager.sendMessage(p, ChatMessageType.ACTION_BAR, messageID, placeholderReplacements);
    }

    private static void sendMessage(Player p, ChatMessageType chatMessageType, String messageID, String ... placeholderReplacements) {
        String message = MessageManager.getRawMessage(messageID);
        if (StringUtils.isEmpty((String)message)) {
            return;
        }
        int replacementIndexer = 1;
        for (String replacement : placeholderReplacements) {
            String replacementString = "%" + replacementIndexer + "%";
            message = message.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        p.spigot().sendMessage(chatMessageType, new MineDown(message).replace(new String[0]).toComponent());
    }

    public static void sendMessage(Player p, String messageID) {
        String message = MessageManager.getRawMessage(messageID);
        if (StringUtils.isEmpty((String)message)) {
            return;
        }
        p.spigot().sendMessage(new MineDown(message).replace(new String[0]).toComponent());
    }

    public static boolean hasMessage(String messageID) {
        return messages.containsKey(messageID);
    }

    public static String getRawMessage(String messageID) {
        return messages.getOrDefault(messageID, "Language config is missing message " + messageID);
    }

    public static String getRawMessage(String messageID, String ... placeholderReplacements) {
        String message = MessageManager.getRawMessage(messageID);
        int replacementIndexer = 1;
        for (String replacement : placeholderReplacements) {
            String replacementString = "%" + replacementIndexer + "%";
            message = message.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        return message;
    }
}

