/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.entity;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.nms.v1_14_R1.network.EmptyNetHandler;
import net.citizensnpcs.nms.v1_14_R1.network.EmptyNetworkManager;
import net.citizensnpcs.nms.v1_14_R1.network.EmptySocket;
import net.citizensnpcs.nms.v1_14_R1.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_14_R1.util.NMSImpl;
import net.citizensnpcs.nms.v1_14_R1.util.PlayerControllerJump;
import net.citizensnpcs.nms.v1_14_R1.util.PlayerControllerLook;
import net.citizensnpcs.nms.v1_14_R1.util.PlayerControllerMove;
import net.citizensnpcs.nms.v1_14_R1.util.PlayerNavigation;
import net.citizensnpcs.nms.v1_14_R1.util.PlayerlistTracker;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_14_R1.AttributeInstance;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.ChatComponentText;
import net.minecraft.server.v1_14_R1.DamageSource;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.EnumGamemode;
import net.minecraft.server.v1_14_R1.EnumItemSlot;
import net.minecraft.server.v1_14_R1.EnumProtocolDirection;
import net.minecraft.server.v1_14_R1.GenericAttributes;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.ItemStack;
import net.minecraft.server.v1_14_R1.MinecraftServer;
import net.minecraft.server.v1_14_R1.NavigationAbstract;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketListener;
import net.minecraft.server.v1_14_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_14_R1.PathType;
import net.minecraft.server.v1_14_R1.PlayerInteractManager;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity {
    private final Map<PathType, Float> bz = Maps.newEnumMap(PathType.class);
    private PlayerControllerJump controllerJump;
    private PlayerControllerLook controllerLook;
    private PlayerControllerMove controllerMove;
    private final Map<EnumItemSlot, ItemStack> equipmentCache = Maps.newEnumMap(EnumItemSlot.class);
    private int jumpTicks = 0;
    private PlayerNavigation navigation;
    private final CitizensNPC npc;
    private final Location packetLocationCache = new Location(null, 0.0, 0.0, 0.0);
    private PlayerlistTracker playerlistTracker;
    private final SkinPacketTracker skinTracker;
    private int updateCounter = 0;
    private static final float EPSILON = 0.005f;
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, PlayerInteractManager playerInteractManager, NPC npc) {
        super(minecraftServer, world, gameProfile, playerInteractManager);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.skinTracker = new SkinPacketTracker((SkinnableEntity)this);
            playerInteractManager.setGameMode(EnumGamemode.SURVIVAL);
            this.initialise(minecraftServer);
        } else {
            this.skinTracker = null;
        }
    }

    protected void a(double d0, boolean flag, IBlockData block, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, block, blockposition);
        }
    }

    public boolean a(EntityPlayer entityplayer) {
        if (this.npc != null && this.playerlistTracker == null) {
            return false;
        }
        return super.a(entityplayer);
    }

    public float a(PathType pathtype) {
        return this.bz.containsKey(pathtype) ? this.bz.get(pathtype).floatValue() : pathtype.a();
    }

    public void a(PathType pathtype, float f) {
        this.bz.put(pathtype, Float.valueOf(f));
    }

    public void b(float f, float f1) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.b(f, f1);
        }
    }

    public void collide(Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent((NPC)this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
        }
    }

    public boolean damageEntity(DamageSource damagesource, float f) {
        boolean damaged = super.damageEntity(damagesource, f);
        if (damaged && this.velocityChanged) {
            this.velocityChanged = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    EntityHumanNPC.this.velocityChanged = true;
                }
            });
        }
        return damaged;
    }

    public void die() {
        super.die();
        this.getAdvancementData().a();
    }

    public void die(DamageSource damagesource) {
        if (this.dead) {
            return;
        }
        super.die(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                ((WorldServer)EntityHumanNPC.this.world).removeEntity((Entity)EntityHumanNPC.this);
            }
        }, 35L);
    }

    public void e(Vec3D vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.e(vec3d);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
        }
    }

    public void enderTeleportTo(double d0, double d1, double d2) {
        if (this.npc == null) {
            super.enderTeleportTo(d0, d1, d2);
            return;
        }
        NPCEnderTeleportEvent event = new NPCEnderTeleportEvent((NPC)this.npc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            super.enderTeleportTo(d0, d1, d2);
        }
    }

    public void f(double x, double y, double z) {
        Vector vector = Util.callPushEvent((NPC)this.npc, (double)x, (double)y, (double)z);
        if (vector != null) {
            super.f(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
            NMSImpl.setBukkitEntity((Entity)this, (CraftEntity)new PlayerNPC(this));
        }
        return super.getBukkitEntity();
    }

    public PlayerControllerJump getControllerJump() {
        return this.controllerJump;
    }

    public PlayerControllerMove getControllerMove() {
        return this.controllerMove;
    }

    public NavigationAbstract getNavigation() {
        return this.navigation;
    }

    public NPC getNPC() {
        return this.npc;
    }

    public IChatBaseComponent getPlayerListName() {
        if (Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean()) {
            return new ChatComponentText("");
        }
        return super.getPlayerListName();
    }

    public String getSkinName() {
        String skinName = ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public boolean inBlock() {
        if (this.npc == null || this.noclip || this.isSleeping()) {
            return super.inBlock();
        }
        return Util.inBlock((org.bukkit.entity.Entity)this.getBukkitEntity());
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager conn = null;
        try {
            conn = new EmptyNetworkManager(EnumProtocolDirection.CLIENTBOUND);
            this.playerConnection = new EmptyNetHandler(minecraftServer, conn, this);
            conn.setPacketListener((PacketListener)this.playerConnection);
            socket.close();
        }
        catch (IOException iOException) {}
        AttributeInstance range = this.getAttributeInstance(GenericAttributes.FOLLOW_RANGE);
        if (range == null) {
            range = this.getAttributeMap().b(GenericAttributes.FOLLOW_RANGE);
        }
        range.setValue(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
        this.controllerJump = new PlayerControllerJump(this);
        this.controllerLook = new PlayerControllerLook(this);
        this.controllerMove = new PlayerControllerMove((EntityLiving)this);
        this.navigation = new PlayerNavigation(this, this.world);
        this.invulnerableTicks = 0;
        NMS.setStepHeight((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)1.0f);
        this.setSkinFlags((byte)-1);
        EmptyAdvancementDataPlayer.clear(this.getAdvancementData());
        NMSImpl.setAdvancement((Player)this.getBukkitEntity(), new EmptyAdvancementDataPlayer(minecraftServer, CitizensAPI.getDataFolder().getParentFile(), this));
    }

    public boolean isClimbing() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.isClimbing();
        }
        return false;
    }

    public boolean isCollidable() {
        return this.npc == null ? super.isCollidable() : ((Boolean)this.npc.data().get("collidable", (Object)true)).booleanValue();
    }

    public boolean isNavigating() {
        return this.npc.getNavigator().isNavigating();
    }

    private void moveOnCurrentHeading() {
        if (this.jumping) {
            if (this.onGround && this.jumpTicks == 0) {
                this.jump();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bb *= 0.98f;
        this.bd *= 0.98f;
        this.be *= 0.9f;
        this.e(new Vec3D((double)this.bb, (double)this.bc, (double)this.bd));
        NMS.setHeadYaw((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)this.yaw);
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    public Packet<?> N() {
        if (this.playerlistTracker != null) {
            this.playerlistTracker.updateLastPlayer();
        }
        return super.N();
    }

    public void playerTick() {
        Vec3D mot;
        if (this.npc == null) {
            super.playerTick();
            return;
        }
        this.entityBaseTick();
        boolean navigating = this.npc.getNavigator().isNavigating();
        if (!navigating && this.getBukkitEntity() != null && (!this.npc.hasTrait(Gravity.class) || ((Gravity)this.npc.getOrAddTrait(Gravity.class)).hasGravity()) && Util.isLoaded((Location)this.getBukkitEntity().getLocation(LOADED_LOCATION))) {
            this.e(new Vec3D(0.0, 0.0, 0.0));
        }
        if (Math.abs((mot = this.getMot()).getX()) < (double)0.005f && Math.abs(mot.getY()) < (double)0.005f && Math.abs(mot.getZ()) < (double)0.005f) {
            this.setMot(new Vec3D(0.0, 0.0, 0.0));
        }
        if (navigating) {
            if (!NMSImpl.isNavigationFinished(this.navigation)) {
                NMSImpl.updateNavigation(this.navigation);
            }
            this.moveOnCurrentHeading();
        }
        NMSImpl.updateAI((EntityLiving)this);
        this.aB = this.aC;
        if (this.hurtTicks > 0) {
            --this.hurtTicks;
        }
        this.tickPotionEffects();
        this.aW = this.aV;
        this.aL = this.aK;
        this.aN = this.aM;
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
    }

    public void setMoveDestination(double x, double y, double z, double speed) {
        this.controllerMove.a(x, y, z, speed);
    }

    public void setShouldJump() {
        this.controllerJump.jump();
    }

    public void setSkinFlags(byte flags) {
        this.getDataWatcher().set(EntityHuman.bt, (Object)flags);
    }

    public void setSkinName(String name) {
        ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).setSkinName(name);
    }

    public void setSkinName(String name, boolean forceUpdate) {
        ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).setSkinName(name, forceUpdate);
    }

    public void setSkinPersistent(String skinName, String signature, String data) {
        ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).setSkinPersistent(skinName, signature, data);
    }

    public void setTargetLook(Entity target, float yawOffset, float renderOffset) {
        this.controllerLook.a(target, yawOffset, renderOffset);
    }

    public void setTargetLook(Location target) {
        this.controllerLook.a(target.getX(), target.getY(), target.getZ(), 10.0f, 40.0f);
    }

    public void setTracked(PlayerlistTracker tracker) {
        this.playerlistTracker = tracker;
    }

    public void tick() {
        super.tick();
        if (this.npc == null) {
            return;
        }
        this.noclip = this.isSpectator();
        if (this.updateCounter + 1 > Settings.Setting.PACKET_UPDATE_DELAY.asInt()) {
            this.updateEffects = true;
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        boolean navigating = this.npc.getNavigator().isNavigating();
        this.updatePackets(navigating);
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        this.npc.update();
    }

    public void updateAI() {
        this.controllerMove.a();
        this.controllerLook.a();
        this.controllerJump.b();
    }

    private void updatePackets(boolean navigating) {
        ++this.updateCounter;
        boolean itemChanged = false;
        EnumItemSlot[] enumItemSlotArray = EnumItemSlot.values();
        int n = enumItemSlotArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumItemSlot slot = enumItemSlotArray[n2];
            ItemStack equipment = this.getEquipment(slot);
            ItemStack cache = this.equipmentCache.get(slot);
            if (!(cache == null && equipment == null || !(cache == null ^ equipment == null) && ItemStack.equals((ItemStack)cache, (ItemStack)equipment))) {
                itemChanged = true;
            }
            this.equipmentCache.put(slot, equipment);
            ++n2;
        }
        if (this.updateCounter++ <= Settings.Setting.PACKET_UPDATE_DELAY.asInt() && !itemChanged) {
            return;
        }
        this.updateCounter = 0;
        Location current = this.getBukkitEntity().getLocation(this.packetLocationCache);
        Packet[] packets = new Packet[EnumItemSlot.values().length];
        int i = 0;
        EnumItemSlot[] enumItemSlotArray2 = EnumItemSlot.values();
        int n3 = enumItemSlotArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            EnumItemSlot slot = enumItemSlotArray2[n4];
            packets[i++] = new PacketPlayOutEntityEquipment(this.getId(), slot, this.getEquipment(slot));
            ++n4;
        }
        NMSImpl.sendPacketsNearby((Player)this.getBukkitEntity(), current, packets);
    }

    public void updatePathfindingRange(float pathfindingRange) {
        this.navigation.setRange(pathfindingRange);
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CraftServer cserver;
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.cserver = (CraftServer)Bukkit.getServer();
            this.npc.getOrAddTrait(Inventory.class);
        }

        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        public NPC getNPC() {
            return this.npc;
        }

        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            this.cserver.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            this.cserver.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

