/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.entity;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_14_R1.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.entity.Entity;

public abstract class MobEntityController
extends AbstractEntityController {
    private final Class<?> clazz;
    private final Constructor<?> constructor;
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = Maps.newHashMap();
    private static final MethodHandle UUID_FIELD = NMS.getSetter(net.minecraft.server.v1_14_R1.Entity.class, (String)"uniqueID");

    protected MobEntityController(Class<?> clazz) {
        super(clazz);
        this.constructor = MobEntityController.getConstructor(clazz);
        this.clazz = clazz;
    }

    protected Entity createEntity(Location at, NPC npc) {
        EntityTypes type = NMSImpl.getEntityType(this.clazz);
        net.minecraft.server.v1_14_R1.Entity entity = this.createEntityFromClass(type, ((CraftWorld)at.getWorld()).getHandle(), npc);
        entity.setPositionRotation(at.getX(), at.getY(), at.getZ(), at.getYaw(), at.getPitch());
        Material beneath = at.getBlock().getRelative(BlockFace.DOWN).getType();
        if (beneath.isSolid()) {
            entity.onGround = true;
        }
        try {
            UUID_FIELD.invoke(entity, npc.getUniqueId());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return entity.getBukkitEntity();
    }

    private net.minecraft.server.v1_14_R1.Entity createEntityFromClass(Object ... args) {
        try {
            return (net.minecraft.server.v1_14_R1.Entity)this.constructor.newInstance(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        Constructor<?> constructor = CONSTRUCTOR_CACHE.get(clazz);
        if (constructor != null) {
            return constructor;
        }
        try {
            return clazz.getConstructor(EntityTypes.class, World.class, NPC.class);
        }
        catch (Exception exception) {
            throw new IllegalStateException("unable to find an entity constructor");
        }
    }
}

