/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_14_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_14_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.DamageSource;
import net.minecraft.server.v1_14_R1.DataWatcherObject;
import net.minecraft.server.v1_14_R1.EntityBoat;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityMinecartAbstract;
import net.minecraft.server.v1_14_R1.EntityPillager;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.SoundEffect;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPillager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pillager;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class PillagerController
extends MobEntityController {
    public PillagerController() {
        super(EntityPillagerNPC.class);
    }

    public Pillager getBukkitEntity() {
        return (Pillager)super.getBukkitEntity();
    }

    public static class EntityPillagerNPC
    extends EntityPillager
    implements NPCHolder {
        boolean calledNMSHeight = false;
        private final CitizensNPC npc;

        public EntityPillagerNPC(EntityTypes<? extends EntityPillager> types, World world) {
            this(types, world, null);
        }

        public EntityPillagerNPC(EntityTypes<? extends EntityPillager> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMSImpl.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc != null && !this.calledNMSHeight) {
                this.calledNMSHeight = true;
                NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject);
                this.calledNMSHeight = false;
            }
            super.a(datawatcherobject);
        }

        protected void a(double d0, boolean flag, IBlockData block, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, block, blockposition);
            }
        }

        public void b(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.b(f, f1);
            }
        }

        protected void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(net.minecraft.server.v1_14_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void e(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.e(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent((NPC)this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent((NPC)this.npc, (double)x, (double)y, (double)z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_14_R1.Entity)this, (CraftEntity)new PillagerNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.getSoundAmbient(), "ambient-sound");
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.getSoundDeath(), "death-sound");
        }

        protected SoundEffect getSoundHurt(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.getSoundHurt(damagesource), "hurt-sound");
        }

        public boolean isClimbing() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.isClimbing();
            }
            return false;
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = (Boolean)this.npc.data().get("protected", (Object)true);
            if (!protectedDefault || !((Boolean)this.npc.data().get("protected-leash", (Object)protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void mobTick() {
            super.mobTick();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        protected boolean n(net.minecraft.server.v1_14_R1.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return (Boolean)this.npc.data().get("protected", (Object)true) == false;
            }
            return super.n(entity);
        }
    }

    public static class PillagerNPC
    extends CraftPillager
    implements NPCHolder {
        private final CitizensNPC npc;

        public PillagerNPC(EntityPillagerNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPillager)entity);
            this.npc = entity.npc;
        }

        public NPC getNPC() {
            return this.npc;
        }
    }
}

