/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_14_R1.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_14_R1.EntityEgg;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.World;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EggController
extends AbstractEntityController {
    public EggController() {
        super(EntityEggNPC.class);
    }

    protected Entity createEntity(Location at, NPC npc) {
        WorldServer ws = ((CraftWorld)at.getWorld()).getHandle();
        EntityEggNPC handle = new EntityEggNPC((World)ws, npc, at.getX(), at.getY(), at.getZ());
        return handle.getBukkitEntity();
    }

    public Egg getBukkitEntity() {
        return (Egg)super.getBukkitEntity();
    }

    public static class EggNPC
    extends CraftEgg
    implements NPCHolder {
        private final CitizensNPC npc;

        public EggNPC(EntityEggNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEgg)entity);
            this.npc = entity.npc;
        }

        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityEggNPC
    extends EntityEgg
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEggNPC(EntityTypes<? extends EntityEgg> types, World world) {
            this(types, world, null);
        }

        public EntityEggNPC(EntityTypes<? extends EntityEgg> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
        }

        public EntityEggNPC(World world, NPC npc, double d0, double d1, double d2) {
            super(world, d0, d1, d2);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(net.minecraft.server.v1_14_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent((NPC)this.npc, (double)x, (double)y, (double)z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_14_R1.Entity)this, (CraftEntity)new EggNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
                if (!((Boolean)this.npc.data().get("protected", (Object)true)).booleanValue()) {
                    super.tick();
                }
            } else {
                super.tick();
            }
        }
    }
}

