/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.trait;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.trait.versioned.BossBarTrait;
import net.citizensnpcs.trait.versioned.CatTrait;
import net.citizensnpcs.trait.versioned.FoxTrait;
import net.citizensnpcs.trait.versioned.LlamaTrait;
import net.citizensnpcs.trait.versioned.MushroomCowTrait;
import net.citizensnpcs.trait.versioned.PandaTrait;
import net.citizensnpcs.trait.versioned.ParrotTrait;
import net.citizensnpcs.trait.versioned.PhantomTrait;
import net.citizensnpcs.trait.versioned.PolarBearTrait;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.trait.versioned.ShulkerTrait;
import net.citizensnpcs.trait.versioned.SnowmanTrait;
import net.citizensnpcs.trait.versioned.TropicalFishTrait;
import net.citizensnpcs.trait.versioned.VillagerTrait;
import net.citizensnpcs.util.Util;
import org.bukkit.DyeColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;

public class Commands {
    @Command(aliases={"npc"}, usage="bossbar --color [color] --title [title] --visible [visible] --flags [flags]", desc="Edit bossbar properties", modifiers={"bossbar"}, min=1, max=1)
    @Requirements(selected=true, ownership=true, types={EntityType.WITHER, EntityType.ENDER_DRAGON})
    public void bossbar(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        BossBarTrait trait = (BossBarTrait)npc.getOrAddTrait(BossBarTrait.class);
        if (args.hasValueFlag("color")) {
            BarColor color = (BarColor)Util.matchEnum((Enum[])BarColor.values(), (String)args.getFlag("color"));
            trait.setColor(color);
        }
        if (args.hasValueFlag("title")) {
            trait.setTitle(Colorizer.parseColors((String)args.getFlag("title")));
        }
        if (args.hasValueFlag("visible")) {
            trait.setVisible(Boolean.parseBoolean(args.getFlag("visible")));
        }
        if (args.hasValueFlag("flags")) {
            ArrayList flags = Lists.newArrayList();
            for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)args.getFlag("flags"))) {
                BarFlag flag = (BarFlag)Util.matchEnum((Enum[])BarFlag.values(), (String)s);
                if (flag == null) continue;
                flags.add(flag);
            }
            trait.setFlags((List)flags);
        }
    }

    @Command(aliases={"npc"}, usage="cat (-s/-n/-l) --type type --ccolor collar color", desc="Sets cat modifiers", modifiers={"cat"}, min=1, max=1, flags="snl", permission="citizens.npc.cat")
    @Requirements(selected=true, ownership=true, types={EntityType.CAT})
    public void cat(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        CatTrait trait = (CatTrait)npc.getOrAddTrait(CatTrait.class);
        String output = "";
        if (args.hasValueFlag("type")) {
            Cat.Type type = (Cat.Type)Util.matchEnum((Enum[])Cat.Type.values(), (String)args.getFlag("type"));
            if (type == null) {
                throw new CommandUsageException("citizens.commands.npc.cat.invalid-type", Util.listValuesPretty((Enum[])Cat.Type.values()));
            }
            trait.setType(type);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)"citizens.commands.npc.cat.type-set", (Object[])new Object[]{args.getFlag("type")});
        }
        if (args.hasValueFlag("ccolor")) {
            DyeColor color = (DyeColor)Util.matchEnum((Enum[])DyeColor.values(), (String)args.getFlag("ccolor"));
            if (color == null) {
                throw new CommandUsageException("citizens.commands.npc.cat.invalid-collar-color", Util.listValuesPretty((Enum[])DyeColor.values()));
            }
            trait.setCollarColor(color);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)"citizens.commands.npc.cat.collar-color-set", (Object[])new Object[]{args.getFlag("ccolor")});
        }
        if (args.hasFlag('s')) {
            trait.setSitting(true);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)"citizens.commands.npc.cat.sitting-start", (Object[])new Object[]{npc.getName()});
        } else if (args.hasFlag('n')) {
            trait.setSitting(false);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)"citizens.commands.npc.cat.sitting-stop", (Object[])new Object[]{npc.getName()});
        }
        if (args.hasFlag('l')) {
            trait.setLyingDown(!trait.isLyingDown());
            output = String.valueOf(output) + ' ' + Messaging.tr((String)(trait.isLyingDown() ? "citizens.commands.npc.cat.lying-start" : "citizens.commands.npc.cat.lying-stop"), (Object[])new Object[]{npc.getName()});
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{output.trim()});
    }

    @Command(aliases={"npc"}, usage="fox --type type --sleeping [true|false] --sitting [true|false] --crouching [true|false]", desc="Sets fox modifiers", modifiers={"fox"}, min=1, max=1, permission="citizens.npc.fox")
    @Requirements(selected=true, ownership=true, types={EntityType.FOX})
    public void fox(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        FoxTrait trait = (FoxTrait)npc.getOrAddTrait(FoxTrait.class);
        String output = "";
        if (args.hasValueFlag("type")) {
            Fox.Type type = (Fox.Type)Util.matchEnum((Enum[])Fox.Type.values(), (String)args.getFlag("type"));
            if (type == null) {
                throw new CommandUsageException("citizens.commands.npc.fox.invalid-fox-type", Util.listValuesPretty((Enum[])Fox.Type.values()));
            }
            trait.setType(type);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)"citizens.commands.npc.fox.fox-type-set", (Object[])new Object[]{args.getFlag("type")});
        }
        if (args.hasValueFlag("sleeping")) {
            boolean sleeping = Boolean.parseBoolean(args.getFlag("sleeping"));
            trait.setSleeping(sleeping);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)(sleeping ? "citizens.commands.npc.fox.sleeping-set" : "citizens.commands.npc.fox.sleeping-unset"), (Object[])new Object[0]);
        }
        if (args.hasValueFlag("sitting")) {
            boolean sitting = Boolean.parseBoolean(args.getFlag("sitting"));
            trait.setSitting(sitting);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)(sitting ? "citizens.commands.npc.fox.sitting-set" : "citizens.commands.npc.fox.sitting-unset"), (Object[])new Object[0]);
        }
        if (args.hasValueFlag("crouching")) {
            boolean crouching = Boolean.parseBoolean(args.getFlag("crouching"));
            trait.setCrouching(crouching);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)(crouching ? "citizens.commands.npc.fox.crouching-set" : "citizens.commands.npc.fox.crouching-unset"), (Object[])new Object[0]);
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{output.trim()});
    }

    @Command(aliases={"npc"}, usage="llama (--color color) (--strength strength)", desc="Sets llama modifiers", modifiers={"llama"}, min=1, max=1, permission="citizens.npc.llama")
    @Requirements(selected=true, ownership=true, types={EntityType.LLAMA, EntityType.TRADER_LLAMA})
    public void llama(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        LlamaTrait trait = (LlamaTrait)npc.getOrAddTrait(LlamaTrait.class);
        String output = "";
        if (args.hasValueFlag("color") || args.hasValueFlag("colour")) {
            String colorRaw = args.getFlag("color", args.getFlag("colour"));
            Llama.Color color = (Llama.Color)Util.matchEnum((Enum[])Llama.Color.values(), (String)colorRaw);
            if (color == null) {
                String valid = Util.listValuesPretty((Enum[])Llama.Color.values());
                throw new CommandException("citizens.commands.npc.llama.invalid-color", new Object[]{valid});
            }
            trait.setColor(color);
            output = String.valueOf(output) + Messaging.tr((String)"citizens.commands.npc.llama.color-set", (Object[])new Object[]{Util.prettyEnum((Enum)color)});
        }
        if (args.hasValueFlag("strength")) {
            trait.setStrength(Math.max(1, Math.min(5, args.getFlagInteger("strength"))));
            output = String.valueOf(output) + Messaging.tr((String)"citizens.commands.npc.llama.strength-set", (Object[])new Object[]{args.getFlagInteger("strength")});
        }
        if (!output.isEmpty()) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{output});
        }
    }

    @Command(aliases={"npc"}, usage="mcow (--variant [variant])", desc="Sets mushroom cow modifiers.", modifiers={"mcow", "mushroomcow"}, min=1, max=1, permission="citizens.npc.mushroomcow")
    @Requirements(selected=true, ownership=true, types={EntityType.MUSHROOM_COW})
    public void mushroomcow(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        MushroomCowTrait trait = (MushroomCowTrait)npc.getOrAddTrait(MushroomCowTrait.class);
        boolean hasArg = false;
        if (args.hasValueFlag("variant")) {
            MushroomCow.Variant variant = (MushroomCow.Variant)Util.matchEnum((Enum[])MushroomCow.Variant.values(), (String)args.getFlag("variant"));
            if (variant == null) {
                Messaging.sendErrorTr((CommandSender)sender, (String)"citizens.commands.npc.mushroomcow.invalid-variant", (Object[])new Object[]{Util.listValuesPretty((Enum[])MushroomCow.Variant.values())});
                return;
            }
            trait.setVariant(variant);
            Messaging.sendTr((CommandSender)sender, (String)"citizens.commands.npc.mushroomcow.variant-set", (Object[])new Object[]{npc.getName(), variant});
            hasArg = true;
        }
        if (!hasArg) {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="panda --gene (main gene) --hgene (hidden gene)", desc="Sets panda modifiers", modifiers={"panda"}, min=1, max=1, permission="citizens.npc.panda")
    @Requirements(selected=true, ownership=true, types={EntityType.PANDA})
    public void panda(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Panda.Gene gene;
        PandaTrait trait = (PandaTrait)npc.getOrAddTrait(PandaTrait.class);
        String output = "";
        if (args.hasValueFlag("gene")) {
            gene = (Panda.Gene)Util.matchEnum((Enum[])Panda.Gene.values(), (String)args.getFlag("gene"));
            if (gene == null) {
                throw new CommandUsageException("citizens.commands.npc.panda.invalid-gene", Util.listValuesPretty((Enum[])Panda.Gene.values()));
            }
            trait.setMainGene(gene);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)"citizens.commands.npc.panda.main-gene-set", (Object[])new Object[]{args.getFlag("gene")});
        }
        if (args.hasValueFlag("hgene")) {
            gene = (Panda.Gene)Util.matchEnum((Enum[])Panda.Gene.values(), (String)args.getFlag("hgene"));
            if (gene == null) {
                throw new CommandUsageException("citizens.commands.npc.panda.invalid-gene", Util.listValuesPretty((Enum[])Panda.Gene.values()));
            }
            trait.setHiddenGene(gene);
            output = String.valueOf(output) + ' ' + Messaging.tr((String)"citizens.commands.npc.panda.hidden-gene-set", (Object[])new Object[]{args.getFlag("hgene")});
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{output.trim()});
    }

    @Command(aliases={"npc"}, usage="parrot (--variant variant)", desc="Sets parrot modifiers", modifiers={"parrot"}, min=1, max=1, permission="citizens.npc.parrot")
    @Requirements(selected=true, ownership=true, types={EntityType.PARROT})
    public void parrot(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ParrotTrait trait = (ParrotTrait)npc.getOrAddTrait(ParrotTrait.class);
        String output = "";
        if (args.hasValueFlag("variant")) {
            String variantRaw = args.getFlag("variant");
            Parrot.Variant variant = (Parrot.Variant)Util.matchEnum((Enum[])Parrot.Variant.values(), (String)variantRaw);
            if (variant == null) {
                String valid = Util.listValuesPretty((Enum[])Parrot.Variant.values());
                throw new CommandException("citizens.commands.npc.parrot.invalid-variant", new Object[]{valid});
            }
            trait.setVariant(variant);
            output = String.valueOf(output) + Messaging.tr((String)"citizens.commands.npc.parrot.variant-set", (Object[])new Object[]{Util.prettyEnum((Enum)variant)});
        }
        if (!output.isEmpty()) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{output});
        }
    }

    @Command(aliases={"npc"}, usage="phantom (--size size)", desc="Sets phantom modifiers", modifiers={"phantom"}, min=1, max=1, permission="citizens.npc.phantom")
    @Requirements(selected=true, ownership=true, types={EntityType.PHANTOM})
    public void phantom(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        PhantomTrait trait = (PhantomTrait)npc.getOrAddTrait(PhantomTrait.class);
        String output = "";
        if (args.hasValueFlag("size")) {
            if (args.getFlagInteger("size") <= 0) {
                throw new CommandUsageException();
            }
            trait.setSize(args.getFlagInteger("size"));
            output = String.valueOf(output) + Messaging.tr((String)"citizens.commands.npc.phantom.phantom-set", (Object[])new Object[]{args.getFlagInteger("size")});
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{output});
    }

    @Command(aliases={"npc"}, usage="polarbear (-r)", desc="Sets polarbear modifiers.", modifiers={"polarbear"}, min=1, max=1, flags="r", permission="citizens.npc.polarbear")
    @Requirements(selected=true, ownership=true, types={EntityType.POLAR_BEAR})
    public void polarbear(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        PolarBearTrait trait = (PolarBearTrait)npc.getOrAddTrait(PolarBearTrait.class);
        String output = "";
        if (args.hasFlag('r')) {
            trait.setRearing(!trait.isRearing());
            output = String.valueOf(output) + Messaging.tr((String)(trait.isRearing() ? "citizens.commands.npc.polarbear.rearing-set" : "citizens.commands.npc.polarbear.rearing-unset"), (Object[])new Object[]{npc.getName()});
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{output});
    }

    @Command(aliases={"npc"}, usage="pufferfish (--state state)", desc="Sets pufferfish modifiers", modifiers={"pufferfish"}, min=1, max=1, permission="citizens.npc.pufferfish")
    @Requirements(selected=true, ownership=true, types={EntityType.PUFFERFISH})
    public void pufferfish(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        PufferFishTrait trait = (PufferFishTrait)npc.getOrAddTrait(PufferFishTrait.class);
        String output = "";
        if (args.hasValueFlag("state")) {
            int state = Math.min(Math.max(args.getFlagInteger("state"), 0), 3);
            trait.setPuffState(state);
            output = String.valueOf(output) + Messaging.tr((String)"citizens.commands.npc.pufferfish.state-set", (Object[])new Object[]{state});
        }
        if (!output.isEmpty()) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{output});
        }
    }

    @Command(aliases={"npc"}, usage="shulker (--peek [peek] --color [color])", desc="Sets shulker modifiers.", modifiers={"shulker"}, min=1, max=1, permission="citizens.npc.shulker")
    @Requirements(selected=true, ownership=true, types={EntityType.SHULKER})
    public void shulker(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ShulkerTrait trait = (ShulkerTrait)npc.getOrAddTrait(ShulkerTrait.class);
        boolean hasArg = false;
        if (args.hasValueFlag("peek")) {
            byte peek = (byte)args.getFlagInteger("peek");
            trait.setPeek((int)peek);
            Messaging.sendTr((CommandSender)sender, (String)"citizens.commands.npc.shulker.peek-set", (Object[])new Object[]{npc.getName(), (int)peek});
            hasArg = true;
        }
        if (args.hasValueFlag("color")) {
            DyeColor color = (DyeColor)Util.matchEnum((Enum[])DyeColor.values(), (String)args.getFlag("color"));
            if (color == null) {
                Messaging.sendErrorTr((CommandSender)sender, (String)"citizens.commands.npc.shulker.invalid-color", (Object[])new Object[]{Util.listValuesPretty((Enum[])DyeColor.values())});
                return;
            }
            trait.setColor(color);
            Messaging.sendTr((CommandSender)sender, (String)"citizens.commands.npc.shulker.color-set", (Object[])new Object[]{npc.getName(), Util.prettyEnum((Enum)color)});
            hasArg = true;
        }
        if (!hasArg) {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="snowman (-d[erp])", desc="Sets snowman modifiers.", modifiers={"snowman"}, min=1, max=1, flags="d", permission="citizens.npc.snowman")
    @Requirements(selected=true, ownership=true, types={EntityType.SNOWMAN})
    public void snowman(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        SnowmanTrait trait = (SnowmanTrait)npc.getOrAddTrait(SnowmanTrait.class);
        boolean hasArg = false;
        if (args.hasFlag('d')) {
            boolean isDerp = trait.toggleDerp();
            Messaging.sendTr((CommandSender)sender, (String)(isDerp ? "citizens.commands.npc.snowman.derp-set" : "citizens.commands.npc.snowman.derp-stopped"), (Object[])new Object[]{npc.getName()});
            hasArg = true;
        }
        if (!hasArg) {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="tfish (--body color) (--pattern pattern) (--patterncolor color)", desc="Sets tropical fish modifiers", modifiers={"tfish"}, min=1, max=1, permission="citizens.npc.tropicalfish")
    @Requirements(selected=true, ownership=true, types={EntityType.TROPICAL_FISH})
    public void tropicalfish(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        DyeColor color;
        TropicalFishTrait trait = (TropicalFishTrait)npc.getOrAddTrait(TropicalFishTrait.class);
        String output = "";
        if (args.hasValueFlag("body")) {
            color = (DyeColor)Util.matchEnum((Enum[])DyeColor.values(), (String)args.getFlag("body"));
            if (color == null) {
                throw new CommandException("citizens.commands.npc.tropicalfish.invalid-color", new Object[]{Util.listValuesPretty((Enum[])DyeColor.values())});
            }
            trait.setBodyColor(color);
            output = String.valueOf(output) + Messaging.tr((String)"citizens.commands.npc.tropicalfish.body-color-set", (Object[])new Object[]{Util.prettyEnum((Enum)color)});
        }
        if (args.hasValueFlag("patterncolor")) {
            color = (DyeColor)Util.matchEnum((Enum[])DyeColor.values(), (String)args.getFlag("patterncolor"));
            if (color == null) {
                throw new CommandException("citizens.commands.npc.tropicalfish.invalid-color", new Object[]{Util.listValuesPretty((Enum[])DyeColor.values())});
            }
            trait.setPatternColor(color);
            output = String.valueOf(output) + Messaging.tr((String)"citizens.commands.npc.tropicalfish.pattern-color-set", (Object[])new Object[]{Util.prettyEnum((Enum)color)});
        }
        if (args.hasValueFlag("pattern")) {
            TropicalFish.Pattern pattern = (TropicalFish.Pattern)Util.matchEnum((Enum[])TropicalFish.Pattern.values(), (String)args.getFlag("pattern"));
            if (pattern == null) {
                throw new CommandException("citizens.commands.npc.tropicalfish.invalid-pattern", new Object[]{Util.listValuesPretty((Enum[])TropicalFish.Pattern.values())});
            }
            trait.setPattern(pattern);
            output = String.valueOf(output) + Messaging.tr((String)"citizens.commands.npc.tropicalfish.pattern-set", (Object[])new Object[]{Util.prettyEnum((Enum)pattern)});
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{output});
    }

    @Command(aliases={"npc"}, usage="villager (--level level) (--type type) (--profession profession)", desc="Sets villager modifiers", modifiers={"villager"}, min=1, max=1, permission="citizens.npc.villager")
    @Requirements(selected=true, ownership=true, types={EntityType.VILLAGER})
    public void villager(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        VillagerTrait trait = (VillagerTrait)npc.getOrAddTrait(VillagerTrait.class);
        String output = "";
        if (args.hasValueFlag("level")) {
            if (args.getFlagInteger("level") < 0) {
                throw new CommandUsageException();
            }
            trait.setLevel(args.getFlagInteger("level"));
            output = String.valueOf(output) + " " + Messaging.tr((String)"citizens.commands.npc.villager.level-set", (Object[])new Object[]{args.getFlagInteger("level")});
        }
        if (args.hasValueFlag("type")) {
            Villager.Type type = (Villager.Type)Util.matchEnum((Enum[])Villager.Type.values(), (String)args.getFlag("type"));
            if (type == null) {
                throw new CommandException("citizens.commands.npc.villager.invalid-type", new Object[]{Util.listValuesPretty((Enum[])Villager.Type.values())});
            }
            trait.setType(type);
            output = String.valueOf(output) + " " + Messaging.tr((String)"citizens.commands.npc.villager.type-set", (Object[])new Object[]{args.getFlag("type")});
        }
        if (args.hasValueFlag("profession")) {
            Villager.Profession parsed = (Villager.Profession)Util.matchEnum((Enum[])Villager.Profession.values(), (String)args.getFlag("profession"));
            if (parsed == null) {
                throw new CommandException("citizens.commands.npc.profession.invalid-profession", new Object[]{args.getString(1), Joiner.on((char)',').join((Object[])Villager.Profession.values())});
            }
            ((VillagerProfession)npc.getOrAddTrait(VillagerProfession.class)).setProfession(parsed);
            output = String.valueOf(output) + " " + Messaging.tr((String)"citizens.commands.npc.profession.set", (Object[])new Object[]{npc.getName(), args.getFlag("profession")});
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{output.trim()});
    }
}

