/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.util;

import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.Blocks;
import net.minecraft.server.v1_14_R1.EnchantmentManager;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.EnumItemSlot;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.MobEffects;
import net.minecraft.server.v1_14_R1.TagsFluid;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CitizensBlockBreaker
extends BlockBreaker {
    private final BlockBreaker.BlockBreakerConfiguration configuration;
    private int currentDamage;
    private int currentTick;
    private final net.minecraft.server.v1_14_R1.Entity entity;
    private boolean isDigging = true;
    private final Location location;
    private boolean setTarget;
    private int startDigTick;
    private final int x;
    private final int y;
    private final int z;

    public CitizensBlockBreaker(Entity entity, Block target, BlockBreaker.BlockBreakerConfiguration config) {
        this.entity = ((CraftEntity)entity).getHandle();
        this.x = target.getX();
        this.y = target.getY();
        this.z = target.getZ();
        this.location = target.getLocation();
        this.startDigTick = (int)(System.currentTimeMillis() / 50L);
        this.configuration = config;
    }

    private double distanceSquared() {
        return Math.pow(this.entity.locX - (double)this.x, 2.0) + Math.pow(NMS.getHeight((Entity)this.entity.getBukkitEntity()) + this.entity.locY - (double)this.y, 2.0) + Math.pow(this.entity.locZ - (double)this.z, 2.0);
    }

    private net.minecraft.server.v1_14_R1.ItemStack getCurrentItem() {
        return this.configuration.item() != null ? CraftItemStack.asNMSCopy((ItemStack)this.configuration.item()) : (this.entity instanceof EntityLiving ? ((EntityLiving)this.entity).getEquipment(EnumItemSlot.MAINHAND) : null);
    }

    private float getStrength(IBlockData block) {
        float base = block.getBlock().a(block, null, new BlockPosition(0, 0, 0));
        return base < 0.0f ? 0.0f : (!this.isDestroyable(block) ? 1.0f / base / 100.0f : this.strengthMod(block) / base / 30.0f);
    }

    private boolean isDestroyable(IBlockData block) {
        if (block.getMaterial().isAlwaysDestroyable()) {
            return true;
        }
        net.minecraft.server.v1_14_R1.ItemStack current = this.getCurrentItem();
        return current != null ? current.b(block) : false;
    }

    public void reset() {
        NPC npc;
        if (this.setTarget && this.entity instanceof NPCHolder && (npc = ((NPCHolder)this.entity).getNPC()) != null && npc.getNavigator().isNavigating()) {
            npc.getNavigator().cancelNavigation();
        }
        this.setTarget = false;
        if (this.configuration.callback() != null) {
            this.configuration.callback().run();
        }
        this.isDigging = false;
        this.currentDamage = -1;
        this.setBlockDamage(-1);
    }

    public BehaviorStatus run() {
        IBlockData block;
        if (this.entity.dead) {
            return BehaviorStatus.FAILURE;
        }
        if (!this.isDigging) {
            return BehaviorStatus.SUCCESS;
        }
        this.currentTick = (int)(System.currentTimeMillis() / 50L);
        if (this.configuration.radiusSquared() > 0.0 && this.distanceSquared() >= this.configuration.radiusSquared()) {
            NPC npc;
            this.startDigTick = this.currentTick;
            if (this.entity instanceof NPCHolder && (npc = ((NPCHolder)this.entity).getNPC()) != null && !npc.getNavigator().isNavigating()) {
                npc.getNavigator().setTarget(this.entity.world.getWorld().getBlockAt(this.x, this.y, this.z).getLocation().add(0.0, 1.0, 0.0));
                this.setTarget = true;
            }
            return BehaviorStatus.RUNNING;
        }
        Util.faceLocation((Entity)this.entity.getBukkitEntity(), (Location)this.location);
        if (this.entity instanceof EntityPlayer) {
            PlayerAnimation.ARM_SWING.play((Player)this.entity.getBukkitEntity());
        }
        if ((block = this.entity.world.getType(new BlockPosition(this.x, this.y, this.z))) == null || block.getBlock() == Blocks.AIR) {
            return BehaviorStatus.SUCCESS;
        }
        int tickDifference = this.currentTick - this.startDigTick;
        float damage = this.getStrength(block) * (float)(tickDifference + 1) * this.configuration.blockStrengthModifier();
        if (damage >= 1.0f) {
            this.entity.world.getWorld().getBlockAt(this.x, this.y, this.z).breakNaturally((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.server.v1_14_R1.ItemStack)this.getCurrentItem()));
            return BehaviorStatus.SUCCESS;
        }
        int modifiedDamage = (int)(damage * 10.0f);
        if (modifiedDamage != this.currentDamage) {
            this.setBlockDamage(modifiedDamage);
            this.currentDamage = modifiedDamage;
        }
        return BehaviorStatus.RUNNING;
    }

    private void setBlockDamage(int modifiedDamage) {
        ((WorldServer)this.entity.world).a(this.entity.getId(), new BlockPosition(this.x, this.y, this.z), modifiedDamage);
    }

    public boolean shouldExecute() {
        return this.entity.world.getType(new BlockPosition(this.x, this.y, this.z)).getBlock() != Blocks.AIR;
    }

    private float strengthMod(IBlockData block) {
        net.minecraft.server.v1_14_R1.ItemStack itemstack = this.getCurrentItem();
        float f = itemstack.a(block);
        if (this.entity instanceof EntityLiving) {
            int i;
            EntityLiving handle = (EntityLiving)this.entity;
            if (f > 1.0f && (i = EnchantmentManager.getDigSpeedEnchantmentLevel((EntityLiving)handle)) > 0) {
                f += (float)(i * i + 1);
            }
            if (handle.hasEffect(MobEffects.FASTER_DIG)) {
                f *= 1.0f + (float)(handle.getEffect(MobEffects.FASTER_DIG).getAmplifier() + 1) * 0.2f;
            }
            if (handle.hasEffect(MobEffects.SLOWER_DIG)) {
                float f1 = 1.0f;
                switch (handle.getEffect(MobEffects.SLOWER_DIG).getAmplifier()) {
                    case 0: {
                        f1 = 0.3f;
                        break;
                    }
                    case 1: {
                        f1 = 0.09f;
                        break;
                    }
                    case 2: {
                        f1 = 0.0027f;
                        break;
                    }
                    default: {
                        f1 = 8.1E-4f;
                    }
                }
                f *= f1;
            }
            if (handle.a(TagsFluid.WATER) && !EnchantmentManager.h((EntityLiving)handle)) {
                f /= 5.0f;
            }
        }
        if (!this.entity.onGround) {
            f /= 5.0f;
        }
        return f;
    }
}

