/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_14_R1.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.nms.v1_14_R1.entity.BatController;
import net.citizensnpcs.nms.v1_14_R1.entity.BlazeController;
import net.citizensnpcs.nms.v1_14_R1.entity.CatController;
import net.citizensnpcs.nms.v1_14_R1.entity.CaveSpiderController;
import net.citizensnpcs.nms.v1_14_R1.entity.ChickenController;
import net.citizensnpcs.nms.v1_14_R1.entity.CodController;
import net.citizensnpcs.nms.v1_14_R1.entity.CowController;
import net.citizensnpcs.nms.v1_14_R1.entity.CreeperController;
import net.citizensnpcs.nms.v1_14_R1.entity.DolphinController;
import net.citizensnpcs.nms.v1_14_R1.entity.DrownedController;
import net.citizensnpcs.nms.v1_14_R1.entity.EnderDragonController;
import net.citizensnpcs.nms.v1_14_R1.entity.EndermanController;
import net.citizensnpcs.nms.v1_14_R1.entity.EndermiteController;
import net.citizensnpcs.nms.v1_14_R1.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_14_R1.entity.EvokerController;
import net.citizensnpcs.nms.v1_14_R1.entity.FoxController;
import net.citizensnpcs.nms.v1_14_R1.entity.GhastController;
import net.citizensnpcs.nms.v1_14_R1.entity.GiantController;
import net.citizensnpcs.nms.v1_14_R1.entity.GuardianController;
import net.citizensnpcs.nms.v1_14_R1.entity.GuardianElderController;
import net.citizensnpcs.nms.v1_14_R1.entity.HorseController;
import net.citizensnpcs.nms.v1_14_R1.entity.HorseDonkeyController;
import net.citizensnpcs.nms.v1_14_R1.entity.HorseMuleController;
import net.citizensnpcs.nms.v1_14_R1.entity.HorseSkeletonController;
import net.citizensnpcs.nms.v1_14_R1.entity.HorseZombieController;
import net.citizensnpcs.nms.v1_14_R1.entity.HumanController;
import net.citizensnpcs.nms.v1_14_R1.entity.IllusionerController;
import net.citizensnpcs.nms.v1_14_R1.entity.IronGolemController;
import net.citizensnpcs.nms.v1_14_R1.entity.LlamaController;
import net.citizensnpcs.nms.v1_14_R1.entity.MagmaCubeController;
import net.citizensnpcs.nms.v1_14_R1.entity.MushroomCowController;
import net.citizensnpcs.nms.v1_14_R1.entity.OcelotController;
import net.citizensnpcs.nms.v1_14_R1.entity.PandaController;
import net.citizensnpcs.nms.v1_14_R1.entity.ParrotController;
import net.citizensnpcs.nms.v1_14_R1.entity.PhantomController;
import net.citizensnpcs.nms.v1_14_R1.entity.PigController;
import net.citizensnpcs.nms.v1_14_R1.entity.PigZombieController;
import net.citizensnpcs.nms.v1_14_R1.entity.PillagerController;
import net.citizensnpcs.nms.v1_14_R1.entity.PolarBearController;
import net.citizensnpcs.nms.v1_14_R1.entity.PufferFishController;
import net.citizensnpcs.nms.v1_14_R1.entity.RabbitController;
import net.citizensnpcs.nms.v1_14_R1.entity.RavagerController;
import net.citizensnpcs.nms.v1_14_R1.entity.SalmonController;
import net.citizensnpcs.nms.v1_14_R1.entity.SheepController;
import net.citizensnpcs.nms.v1_14_R1.entity.ShulkerController;
import net.citizensnpcs.nms.v1_14_R1.entity.SilverfishController;
import net.citizensnpcs.nms.v1_14_R1.entity.SkeletonController;
import net.citizensnpcs.nms.v1_14_R1.entity.SkeletonStrayController;
import net.citizensnpcs.nms.v1_14_R1.entity.SkeletonWitherController;
import net.citizensnpcs.nms.v1_14_R1.entity.SlimeController;
import net.citizensnpcs.nms.v1_14_R1.entity.SnowmanController;
import net.citizensnpcs.nms.v1_14_R1.entity.SpiderController;
import net.citizensnpcs.nms.v1_14_R1.entity.SquidController;
import net.citizensnpcs.nms.v1_14_R1.entity.TraderLlamaController;
import net.citizensnpcs.nms.v1_14_R1.entity.TropicalFishController;
import net.citizensnpcs.nms.v1_14_R1.entity.TurtleController;
import net.citizensnpcs.nms.v1_14_R1.entity.VexController;
import net.citizensnpcs.nms.v1_14_R1.entity.VillagerController;
import net.citizensnpcs.nms.v1_14_R1.entity.VindicatorController;
import net.citizensnpcs.nms.v1_14_R1.entity.WanderingTraderController;
import net.citizensnpcs.nms.v1_14_R1.entity.WitchController;
import net.citizensnpcs.nms.v1_14_R1.entity.WitherController;
import net.citizensnpcs.nms.v1_14_R1.entity.WolfController;
import net.citizensnpcs.nms.v1_14_R1.entity.ZombieController;
import net.citizensnpcs.nms.v1_14_R1.entity.ZombieHuskController;
import net.citizensnpcs.nms.v1_14_R1.entity.ZombieVillagerController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.AreaEffectCloudController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.ArmorStandController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.BoatController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.DragonFireballController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.EggController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.EnderCrystalController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.EnderPearlController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.EnderSignalController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.EvokerFangsController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.FallingBlockController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.FireworkController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.FishingHookController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.ItemController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.ItemFrameController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.LargeFireballController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.LeashController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.LlamaSpitController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.MinecartChestController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.MinecartCommandController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.MinecartFurnaceController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.MinecartHopperController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.MinecartRideableController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.MinecartTNTController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.PaintingController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.ShulkerBulletController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.SmallFireballController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.SnowballController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.SpectralArrowController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.TNTPrimedController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.ThrownExpBottleController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.ThrownPotionController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.ThrownTridentController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.TippedArrowController;
import net.citizensnpcs.nms.v1_14_R1.entity.nonliving.WitherSkullController;
import net.citizensnpcs.nms.v1_14_R1.network.EmptyChannel;
import net.citizensnpcs.nms.v1_14_R1.trait.Commands;
import net.citizensnpcs.nms.v1_14_R1.util.CitizensBlockBreaker;
import net.citizensnpcs.nms.v1_14_R1.util.CustomEntityRegistry;
import net.citizensnpcs.nms.v1_14_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_14_R1.util.PlayerAnimationImpl;
import net.citizensnpcs.nms.v1_14_R1.util.PlayerlistTracker;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.versioned.BossBarTrait;
import net.citizensnpcs.trait.versioned.CatTrait;
import net.citizensnpcs.trait.versioned.FoxTrait;
import net.citizensnpcs.trait.versioned.LlamaTrait;
import net.citizensnpcs.trait.versioned.MushroomCowTrait;
import net.citizensnpcs.trait.versioned.PandaTrait;
import net.citizensnpcs.trait.versioned.ParrotTrait;
import net.citizensnpcs.trait.versioned.PhantomTrait;
import net.citizensnpcs.trait.versioned.PolarBearTrait;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.trait.versioned.ShulkerTrait;
import net.citizensnpcs.trait.versioned.SnowmanTrait;
import net.citizensnpcs.trait.versioned.TropicalFishTrait;
import net.citizensnpcs.trait.versioned.VillagerTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.NMSBridge;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_14_R1.AdvancementDataPlayer;
import net.minecraft.server.v1_14_R1.AttributeInstance;
import net.minecraft.server.v1_14_R1.AxisAlignedBB;
import net.minecraft.server.v1_14_R1.BehaviorController;
import net.minecraft.server.v1_14_R1.Block;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.BossBattleServer;
import net.minecraft.server.v1_14_R1.ChunkProviderServer;
import net.minecraft.server.v1_14_R1.ControllerJump;
import net.minecraft.server.v1_14_R1.CrashReport;
import net.minecraft.server.v1_14_R1.CrashReportSystemDetails;
import net.minecraft.server.v1_14_R1.DamageSource;
import net.minecraft.server.v1_14_R1.DataWatcherObject;
import net.minecraft.server.v1_14_R1.Enchantment;
import net.minecraft.server.v1_14_R1.EnchantmentManager;
import net.minecraft.server.v1_14_R1.Enchantments;
import net.minecraft.server.v1_14_R1.EnderDragonBattle;
import net.minecraft.server.v1_14_R1.EntityBird;
import net.minecraft.server.v1_14_R1.EntityCat;
import net.minecraft.server.v1_14_R1.EntityEnderDragon;
import net.minecraft.server.v1_14_R1.EntityEnderman;
import net.minecraft.server.v1_14_R1.EntityFish;
import net.minecraft.server.v1_14_R1.EntityFishSchool;
import net.minecraft.server.v1_14_R1.EntityFishingHook;
import net.minecraft.server.v1_14_R1.EntityHorse;
import net.minecraft.server.v1_14_R1.EntityHorseAbstract;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityInsentient;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityMinecartAbstract;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.EntityPolarBear;
import net.minecraft.server.v1_14_R1.EntityPose;
import net.minecraft.server.v1_14_R1.EntityPufferFish;
import net.minecraft.server.v1_14_R1.EntityRabbit;
import net.minecraft.server.v1_14_R1.EntityShulker;
import net.minecraft.server.v1_14_R1.EntitySize;
import net.minecraft.server.v1_14_R1.EntityTameableAnimal;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.EntityWither;
import net.minecraft.server.v1_14_R1.EnumMonsterType;
import net.minecraft.server.v1_14_R1.EnumMoveType;
import net.minecraft.server.v1_14_R1.GenericAttributes;
import net.minecraft.server.v1_14_R1.IBlockAccess;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.IRegistry;
import net.minecraft.server.v1_14_R1.ItemStack;
import net.minecraft.server.v1_14_R1.MathHelper;
import net.minecraft.server.v1_14_R1.MinecraftKey;
import net.minecraft.server.v1_14_R1.MobEffects;
import net.minecraft.server.v1_14_R1.NavigationAbstract;
import net.minecraft.server.v1_14_R1.NetworkManager;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_14_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_14_R1.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_14_R1.PathEntity;
import net.minecraft.server.v1_14_R1.PathPoint;
import net.minecraft.server.v1_14_R1.PathType;
import net.minecraft.server.v1_14_R1.PathfinderGoalSelector;
import net.minecraft.server.v1_14_R1.PlayerChunkMap;
import net.minecraft.server.v1_14_R1.ReportedException;
import net.minecraft.server.v1_14_R1.ScoreboardTeam;
import net.minecraft.server.v1_14_R1.SoundEffect;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.VoxelShape;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.CraftSound;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_14_R1.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftWither;
import org.bukkit.craftbukkit.v1_14_R1.event.CraftEventFactory;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wither;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class NMSImpl
implements NMSBridge {
    private static final MethodHandle ADVANCEMENT_PLAYER_FIELD = NMS.getFinalSetter(EntityPlayer.class, (String)"advancementDataPlayer");
    private static final Set<EntityType> BAD_CONTROLLER_LOOK = EnumSet.of(EntityType.POLAR_BEAR, new EntityType[]{EntityType.SILVERFISH, EntityType.SHULKER, EntityType.ENDERMITE, EntityType.ENDER_DRAGON, EntityType.BAT, EntityType.SLIME, EntityType.DOLPHIN, EntityType.MAGMA_CUBE, EntityType.HORSE, EntityType.GHAST, EntityType.SHULKER, EntityType.PHANTOM});
    private static final MethodHandle BEHAVIOR_MAP = NMS.getGetter(BehaviorController.class, (String)"c");
    private static final MethodHandle BLOCK_POSITION_B_D = NMS.getMethodHandle(BlockPosition.PooledBlockPosition.class, (String)"c", (boolean)false, (Class[])new Class[]{Double.TYPE, Double.TYPE, Double.TYPE});
    private static final MethodHandle BUKKITENTITY_FIELD_SETTER = NMS.getSetter(net.minecraft.server.v1_14_R1.Entity.class, (String)"bukkitEntity");
    private static final Map<Class<?>, EntityTypes<?>> CITIZENS_ENTITY_TYPES = Maps.newHashMap();
    private static final MethodHandle CRAFT_BOSSBAR_HANDLE_FIELD = NMS.getSetter(CraftBossBar.class, (String)"handle");
    private static final float DEFAULT_SPEED = 1.0f;
    private static final MethodHandle ENDERDRAGON_BATTLE_FIELD = NMS.getGetter(EntityEnderDragon.class, (String)"bP");
    private static DataWatcherObject<Boolean> ENDERMAN_ANGRY;
    private static final MethodHandle ENTITY_FISH_NUM_IN_SCHOOL;
    private static final MethodHandle ENTITY_GET_SOUND_FALL;
    private static final MethodHandle ENTITY_R;
    private static CustomEntityRegistry ENTITY_REGISTRY;
    private static final Location FROM_LOCATION;
    private static final MethodHandle GOAL_FIELD;
    private static final MethodHandle HEAD_HEIGHT;
    private static final MethodHandle HEAD_HEIGHT_METHOD;
    private static final MethodHandle ISCLIMBING_METHOD;
    private static final MethodHandle JUMP_FIELD;
    private static final MethodHandle MAKE_REQUEST;
    private static final MethodHandle NAVIGATION_WORLD_FIELD;
    public static final Location PACKET_CACHE_LOCATION;
    private static final MethodHandle PATHFINDING_RANGE;
    private static final MethodHandle PLAYER_CHUNK_MAP_GETTER;
    private static final MethodHandle PLAYER_CHUNK_MAP_VIEW_DISTANCE_GETTER;
    private static final MethodHandle PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER;
    private static final MethodHandle PUFFERFISH_C;
    private static final MethodHandle PUFFERFISH_D;
    private static final MethodHandle RABBIT_FIELD;
    private static final Random RANDOM;
    private static final MethodHandle SIZE_FIELD_GETTER;
    private static final MethodHandle SIZE_FIELD_SETTER;
    private static Field SKULL_PROFILE_FIELD;
    private static MethodHandle TEAM_FIELD;

    static {
        ENTITY_FISH_NUM_IN_SCHOOL = NMS.getSetter(EntityFishSchool.class, (String)"c", (boolean)false);
        ENTITY_GET_SOUND_FALL = NMS.getMethodHandle(EntityLiving.class, (String)"getSoundFall", (boolean)true, (Class[])new Class[]{Integer.TYPE});
        ENTITY_R = NMS.getMethodHandle(EntityLiving.class, (String)"r", (boolean)true, (Class[])new Class[]{Float.TYPE});
        FROM_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        GOAL_FIELD = NMS.getGetter(PathfinderGoalSelector.class, (String)"d");
        HEAD_HEIGHT = NMS.getSetter(net.minecraft.server.v1_14_R1.Entity.class, (String)"headHeight");
        HEAD_HEIGHT_METHOD = NMS.getMethodHandle(net.minecraft.server.v1_14_R1.Entity.class, (String)"getHeadHeight", (boolean)true, (Class[])new Class[]{EntityPose.class, EntitySize.class});
        ISCLIMBING_METHOD = NMS.getMethodHandle(EntityLiving.class, (String)"f", (boolean)true, (Class[])new Class[]{Vec3D.class});
        JUMP_FIELD = NMS.getGetter(EntityLiving.class, (String)"jumping");
        MAKE_REQUEST = NMS.getMethodHandle(YggdrasilAuthenticationService.class, (String)"makeRequest", (boolean)true, (Class[])new Class[]{URL.class, Object.class, Class.class});
        NAVIGATION_WORLD_FIELD = NMS.getSetter(NavigationAbstract.class, (String)"b");
        PACKET_CACHE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        PATHFINDING_RANGE = NMS.getGetter(NavigationAbstract.class, (String)"p");
        PLAYER_CHUNK_MAP_GETTER = NMS.getGetter(ChunkProviderServer.class, (String)"playerChunkMap");
        PLAYER_CHUNK_MAP_VIEW_DISTANCE_GETTER = NMS.getGetter(PlayerChunkMap.class, (String)"viewDistance");
        PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER = NMS.getSetter(PlayerChunkMap.class, (String)"viewDistance");
        PUFFERFISH_C = NMS.getSetter(EntityPufferFish.class, (String)"c");
        PUFFERFISH_D = NMS.getSetter(EntityPufferFish.class, (String)"d");
        RABBIT_FIELD = NMS.getGetter(EntityRabbit.class, (String)"bz");
        RANDOM = Util.getFastRandom();
        SIZE_FIELD_GETTER = NMS.getGetter(net.minecraft.server.v1_14_R1.Entity.class, (String)"size");
        SIZE_FIELD_SETTER = NMS.getSetter(net.minecraft.server.v1_14_R1.Entity.class, (String)"size");
        try {
            ENTITY_REGISTRY = new CustomEntityRegistry(NMS.getGetter(IRegistry.class, (String)"ENTITY_TYPE").invoke());
            NMS.getFinalSetter(IRegistry.class, (String)"ENTITY_TYPE").invoke(ENTITY_REGISTRY);
        }
        catch (Throwable e) {
            Messaging.logTr((String)"citizens.nms-errors.getting-id-mapping", (Object[])new Object[]{e.getMessage()});
        }
        try {
            ENDERMAN_ANGRY = (DataWatcherObject)NMS.getField(EntityEnderman.class, (String)"bz").get(null);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public NMSImpl() {
        this.loadEntityTypes();
    }

    public boolean addEntityToWorld(Entity entity, CreatureSpawnEvent.SpawnReason custom) {
        int viewDistance = -1;
        PlayerChunkMap chunkMap = null;
        try {
            if (entity instanceof Player) {
                chunkMap = PLAYER_CHUNK_MAP_GETTER.invoke(NMSImpl.getHandle((Entity)entity).world.getChunkProvider());
                viewDistance = PLAYER_CHUNK_MAP_VIEW_DISTANCE_GETTER.invoke(chunkMap);
                PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER.invoke(chunkMap, -1);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        boolean success = NMSImpl.getHandle((Entity)entity).world.addEntity(NMSImpl.getHandle(entity), custom);
        try {
            if (chunkMap != null) {
                PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER.invoke(chunkMap, viewDistance);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return success;
    }

    public void addOrRemoveFromPlayerList(Entity entity, boolean remove) {
        if (entity == null) {
            return;
        }
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle(entity);
        if (handle.world == null) {
            return;
        }
        if (remove) {
            handle.world.getPlayers().remove(handle);
        } else if (!handle.world.getPlayers().contains(handle)) {
            handle.world.getPlayers().add(handle);
        }
    }

    public void attack(LivingEntity attacker, LivingEntity btarget) {
        int fireAspectLevel;
        boolean flag;
        EntityLiving handle = NMSImpl.getHandle(attacker);
        EntityLiving target = NMSImpl.getHandle(btarget);
        if (handle instanceof EntityPlayer) {
            EntityPlayer humanHandle = (EntityPlayer)handle;
            humanHandle.attack((net.minecraft.server.v1_14_R1.Entity)target);
            PlayerAnimation.ARM_SWING.play((Player)humanHandle.getBukkitEntity());
            return;
        }
        AttributeInstance attackDamage = handle.getAttributeInstance(GenericAttributes.ATTACK_DAMAGE);
        float f = (float)(attackDamage == null ? 1.0 : attackDamage.getValue());
        int i = 0;
        if (target instanceof EntityLiving) {
            f += EnchantmentManager.a((ItemStack)handle.getItemInMainHand(), (EnumMonsterType)target.getMonsterType());
            i += EnchantmentManager.a((Enchantment)Enchantments.KNOCKBACK, (EntityLiving)handle);
        }
        if (!(flag = target.damageEntity(DamageSource.mobAttack((EntityLiving)handle), f))) {
            return;
        }
        if (i > 0) {
            target.f(-Math.sin((double)handle.yaw * Math.PI / 180.0) * (double)i * 0.5, 0.1, Math.cos((double)handle.yaw * Math.PI / 180.0) * (double)i * 0.5);
            handle.setMot(handle.getMot().d(0.6, 1.0, 0.6));
        }
        if ((fireAspectLevel = EnchantmentManager.getFireAspectEnchantmentLevel((EntityLiving)handle)) > 0) {
            target.setOnFire(fireAspectLevel * 4);
        }
    }

    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) throws Throwable {
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("NMS.fillProfileProperties cannot be invoked from the main thread.");
        }
        MinecraftSessionService sessionService = ((CraftServer)Bukkit.getServer()).getServer().getMinecraftSessionService();
        if (!(sessionService instanceof YggdrasilMinecraftSessionService)) {
            return sessionService.fillProfileProperties(profile, requireSecure);
        }
        YggdrasilAuthenticationService auth = ((YggdrasilMinecraftSessionService)sessionService).getAuthenticationService();
        URL url = HttpAuthenticationService.constantURL((String)(String.valueOf(this.getAuthServerBaseUrl()) + UUIDTypeAdapter.fromUUID((UUID)profile.getId())));
        MinecraftProfilePropertiesResponse response = MAKE_REQUEST.invoke(auth, url = HttpAuthenticationService.concatenateURL((URL)url, (String)("unsigned=" + !requireSecure)), null, MinecraftProfilePropertiesResponse.class);
        if (response == null) {
            return profile;
        }
        GameProfile result = new GameProfile(response.getId(), response.getName());
        result.getProperties().putAll((Multimap)response.getProperties());
        profile.getProperties().putAll((Multimap)response.getProperties());
        return result;
    }

    public String getAuthServerBaseUrl() {
        return Settings.Setting.AUTH_SERVER_URL.asString();
    }

    public BlockBreaker getBlockBreaker(Entity entity, org.bukkit.block.Block targetBlock, BlockBreaker.BlockBreakerConfiguration config) {
        return new CitizensBlockBreaker(entity, targetBlock, config);
    }

    public BossBar getBossBar(Entity entity) {
        BossBattleServer bserver;
        block7: {
            Object battleObject;
            block8: {
                bserver = null;
                if (entity.getType() == EntityType.WITHER) {
                    bserver = ((EntityWither)NMSImpl.getHandle((Entity)entity)).bossBattle;
                    break block7;
                }
                if (entity.getType() != EntityType.ENDER_DRAGON) break block7;
                battleObject = ENDERDRAGON_BATTLE_FIELD.invoke(NMSImpl.getHandle(entity));
                if (battleObject != null) break block8;
                return null;
            }
            try {
                bserver = ((EnderDragonBattle)battleObject).bossBattle;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (bserver == null) {
            return null;
        }
        BossBar ret = Bukkit.createBossBar((String)"", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
        try {
            CRAFT_BOSSBAR_HANDLE_FIELD.invoke(ret, bserver);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ret;
    }

    public net.citizensnpcs.api.util.BoundingBox getBoundingBox(Entity handle) {
        return NMSBoundingBox.wrap(NMSImpl.getHandle(handle).getBoundingBox());
    }

    public net.citizensnpcs.api.util.BoundingBox getCollisionBox(org.bukkit.block.Block block) {
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        VoxelShape shape = ((CraftBlock)block).getNMS().getCollisionShape((IBlockAccess)world, ((CraftBlock)block).getPosition());
        AxisAlignedBB aabb = shape.isEmpty() ? ((CraftBlock)block).getNMS().getShape((IBlockAccess)world, ((CraftBlock)block).getPosition()).getBoundingBox() : shape.getBoundingBox();
        return aabb == null ? net.citizensnpcs.api.util.BoundingBox.convert((BoundingBox)block.getBoundingBox()) : NMSBoundingBox.wrap(aabb);
    }

    private float getDragonYaw(net.minecraft.server.v1_14_R1.Entity handle, double tX, double tZ) {
        if (handle.locZ > tZ) {
            return (float)(-Math.toDegrees(Math.atan((handle.locX - tX) / (handle.locZ - tZ))));
        }
        if (handle.locZ < tZ) {
            return (float)(-Math.toDegrees(Math.atan((handle.locX - tX) / (handle.locZ - tZ)))) + 180.0f;
        }
        return handle.yaw;
    }

    public GameProfileRepository getGameProfileRepository() {
        return ((CraftServer)Bukkit.getServer()).getServer().getGameProfileRepository();
    }

    public float getHeadYaw(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return entity.getLocation().getYaw();
        }
        return NMSImpl.getHandle((LivingEntity)((LivingEntity)entity)).aM;
    }

    public double getHeight(Entity entity) {
        return entity.getHeight();
    }

    public float getHorizontalMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)entity);
        return handle.bd;
    }

    public NPC getNPC(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        return handle instanceof NPCHolder ? ((NPCHolder)handle).getNPC() : null;
    }

    public List<Entity> getPassengers(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null || handle.passengers == null) {
            return Lists.newArrayList();
        }
        return Lists.transform((List)handle.passengers, (Function)new Function<net.minecraft.server.v1_14_R1.Entity, Entity>(){

            public Entity apply(net.minecraft.server.v1_14_R1.Entity input) {
                return input.getBukkitEntity();
            }
        });
    }

    public GameProfile getProfile(SkullMeta meta) {
        if (SKULL_PROFILE_FIELD == null && (SKULL_PROFILE_FIELD = NMS.getField(meta.getClass(), (String)"profile", (boolean)false)) == null) {
            return null;
        }
        try {
            return (GameProfile)SKULL_PROFILE_FIELD.get(meta);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSound(String flag) throws CommandException {
        try {
            String ret = CraftSound.getSound((Sound)Sound.valueOf((String)flag.toUpperCase()));
            if (ret == null) {
                throw new CommandException("citizens.commands.npc.sound.invalid-sound");
            }
            return ret;
        }
        catch (Exception exception) {
            throw new CommandException("citizens.commands.npc.sound.invalid-sound");
        }
    }

    public float getSpeedFor(NPC npc) {
        if (!npc.isSpawned() || !(npc.getEntity() instanceof LivingEntity)) {
            return 1.0f;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)npc.getEntity());
        if (handle == null) {
            return 1.0f;
        }
        return 1.0f;
    }

    public float getStepHeight(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).K;
    }

    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Iterable<Vector> dest, final NavigatorParameters params) {
        ArrayList list = Lists.newArrayList((Iterable)Iterables.transform(dest, (Function)new Function<Vector, PathPoint>(){

            public PathPoint apply(Vector input) {
                return new PathPoint(input.getBlockX(), input.getBlockY(), input.getBlockZ());
            }
        }));
        PathPoint last = list.size() > 0 ? (PathPoint)list.get(list.size() - 1) : null;
        final PathEntity path = new PathEntity((List)list, last != null ? new BlockPosition(last.a, last.b, last.c) : null, true);
        return this.getTargetNavigator(entity, params, new Function<NavigationAbstract, Boolean>(){

            public Boolean apply(NavigationAbstract input) {
                return input.a(path, (double)params.speed());
            }
        });
    }

    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, final Location dest, final NavigatorParameters params) {
        return this.getTargetNavigator(entity, params, new Function<NavigationAbstract, Boolean>(){

            public Boolean apply(NavigationAbstract input) {
                return input.a(dest.getX(), dest.getY(), dest.getZ(), (double)params.speed());
            }
        });
    }

    private MCNavigationStrategy.MCNavigator getTargetNavigator(final Entity entity, final NavigatorParameters params, final Function<NavigationAbstract, Boolean> function) {
        float oldWater;
        final net.minecraft.server.v1_14_R1.Entity raw = NMSImpl.getHandle(entity);
        raw.onGround = true;
        final NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        float f = oldWater = raw instanceof EntityPlayer ? ((EntityHumanNPC)raw).a(PathType.WATER) : ((EntityInsentient)raw).a(PathType.WATER);
        if (params.avoidWater() && oldWater >= 0.0f) {
            if (raw instanceof EntityPlayer) {
                ((EntityHumanNPC)raw).a(PathType.WATER, oldWater + 1.0f);
            } else {
                ((EntityInsentient)raw).a(PathType.WATER, oldWater + 1.0f);
            }
        }
        return new MCNavigationStrategy.MCNavigator(){
            float lastSpeed;
            CancelReason reason;

            public CancelReason getCancelReason() {
                return this.reason;
            }

            public Iterable<Vector> getPath() {
                return new NavigationIterable(navigation);
            }

            public void stop() {
                if (params.debug() && navigation.l() != null) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        int i = 0;
                        while (i < navigation.l().e()) {
                            PathPoint pp = navigation.l().a(i);
                            org.bukkit.block.Block block = new Vector(pp.a, pp.b, pp.c).toLocation(player.getWorld()).getBlock();
                            player.sendBlockChange(block.getLocation(), block.getBlockData());
                            ++i;
                        }
                    }
                }
                if (oldWater >= 0.0f) {
                    if (raw instanceof EntityPlayer) {
                        ((EntityHumanNPC)raw).a(PathType.WATER, oldWater);
                    } else {
                        ((EntityInsentient)raw).a(PathType.WATER, oldWater);
                    }
                }
                NMSImpl.stopNavigation(navigation);
            }

            public boolean update() {
                if (params.speed() != this.lastSpeed) {
                    if (Messaging.isDebugging() && this.lastSpeed > 0.0f) {
                        Messaging.debug((Object[])new Object[]{"Repathfinding " + ((NPCHolder)entity).getNPC().getId() + " due to speed change"});
                    }
                    net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
                    EntitySize size = null;
                    try {
                        size = SIZE_FIELD_GETTER.invoke(handle);
                        if (handle instanceof EntityHorse) {
                            SIZE_FIELD_SETTER.invoke(handle, new EntitySize(Math.min(0.99f, size.width), size.height, false));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (!((Boolean)function.apply((Object)navigation)).booleanValue()) {
                        this.reason = CancelReason.STUCK;
                    }
                    try {
                        SIZE_FIELD_SETTER.invoke(handle, size);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    this.lastSpeed = params.speed();
                }
                if (params.debug() && !NMSImpl.isNavigationFinished(navigation)) {
                    BlockData data = Material.DANDELION.createBlockData();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        int i = 0;
                        while (i < navigation.l().e()) {
                            PathPoint pp = navigation.l().a(i);
                            player.sendBlockChange(new Vector(pp.a, pp.b, pp.c).toLocation(player.getWorld()), data);
                            ++i;
                        }
                    }
                }
                navigation.a((double)params.speed());
                return NMSImpl.isNavigationFinished(navigation);
            }
        };
    }

    public MCTargetStrategy.TargetNavigator getTargetNavigator(Entity entity, Entity target, NavigatorParameters parameters) {
        NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        return navigation == null ? null : new NavigationFieldWrapper(navigation, target, parameters);
    }

    public Entity getVehicle(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return null;
        }
        net.minecraft.server.v1_14_R1.Entity e = handle.getVehicle();
        return e == handle || e == null ? null : e.getBukkitEntity();
    }

    public float getVerticalMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)entity);
        return handle.bb;
    }

    public double getWidth(Entity entity) {
        return entity.getWidth();
    }

    public float getYaw(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).yaw;
    }

    public boolean isOnGround(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).onGround;
    }

    public boolean isSolid(org.bukkit.block.Block in) {
        IBlockData data = ((CraftBlock)in).getNMS();
        return data.m((IBlockAccess)((CraftWorld)in.getWorld()).getHandle(), new BlockPosition(in.getX(), in.getY(), in.getZ()));
    }

    public boolean isValid(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        return handle.valid && handle.isAlive();
    }

    public void load(CommandManager manager) {
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(BossBarTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(CatTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(FoxTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(LlamaTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(MushroomCowTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ParrotTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(PandaTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(PhantomTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(PolarBearTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(PufferFishTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ShulkerTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SnowmanTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(TropicalFishTrait.class));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(VillagerTrait.class));
        manager.register(Commands.class);
    }

    private void loadEntityTypes() {
        EntityControllers.setEntityControllerForType((EntityType)EntityType.AREA_EFFECT_CLOUD, AreaEffectCloudController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ARROW, TippedArrowController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ARMOR_STAND, ArmorStandController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.BAT, BatController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.BLAZE, BlazeController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.BOAT, BoatController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.CAT, CatController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.CAVE_SPIDER, CaveSpiderController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.CHICKEN, ChickenController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.COD, CodController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.COW, CowController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.CREEPER, CreeperController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.DOLPHIN, DolphinController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.DRAGON_FIREBALL, DragonFireballController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.DROPPED_ITEM, ItemController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.DROWNED, DrownedController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.EGG, EggController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ELDER_GUARDIAN, GuardianElderController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ENDER_CRYSTAL, EnderCrystalController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ENDER_DRAGON, EnderDragonController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ENDER_PEARL, EnderPearlController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ENDER_SIGNAL, EnderSignalController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ENDERMAN, EndermanController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ENDERMITE, EndermiteController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.EVOKER, EvokerController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.EVOKER_FANGS, EvokerFangsController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.FALLING_BLOCK, FallingBlockController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.FIREWORK, FireworkController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.FIREBALL, LargeFireballController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.FISHING_HOOK, FishingHookController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.FOX, FoxController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.GHAST, GhastController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.GIANT, GiantController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.GUARDIAN, GuardianController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.HORSE, HorseController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.DONKEY, HorseDonkeyController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.MULE, HorseMuleController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SKELETON_HORSE, HorseSkeletonController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ZOMBIE_HORSE, HorseZombieController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.HUSK, ZombieHuskController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.IRON_GOLEM, IronGolemController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ILLUSIONER, IllusionerController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ITEM_FRAME, ItemFrameController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.LEASH_HITCH, LeashController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.LLAMA, LlamaController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.TRADER_LLAMA, TraderLlamaController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.WANDERING_TRADER, WanderingTraderController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.LLAMA_SPIT, LlamaSpitController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SPLASH_POTION, ThrownPotionController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.MAGMA_CUBE, MagmaCubeController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.MINECART, MinecartRideableController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.MINECART_CHEST, MinecartChestController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.MINECART_COMMAND, MinecartCommandController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.MINECART_FURNACE, MinecartFurnaceController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.MINECART_HOPPER, MinecartHopperController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.MINECART_TNT, MinecartTNTController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.MUSHROOM_COW, MushroomCowController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.OCELOT, OcelotController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PANDA, PandaController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PAINTING, PaintingController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PARROT, ParrotController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PHANTOM, PhantomController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PILLAGER, PillagerController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PIG, PigController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PIG_ZOMBIE, PigZombieController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.POLAR_BEAR, PolarBearController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PLAYER, HumanController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PUFFERFISH, PufferFishController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.RABBIT, RabbitController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.RAVAGER, RavagerController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SALMON, SalmonController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SHEEP, SheepController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SHULKER, ShulkerController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SHULKER_BULLET, ShulkerBulletController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SILVERFISH, SilverfishController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SKELETON, SkeletonController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.STRAY, SkeletonStrayController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SLIME, SlimeController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SMALL_FIREBALL, SmallFireballController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SNOWBALL, SnowballController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SNOWMAN, SnowmanController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SPECTRAL_ARROW, SpectralArrowController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SPIDER, SpiderController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SPLASH_POTION, ThrownPotionController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SQUID, SquidController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.SPECTRAL_ARROW, TippedArrowController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.THROWN_EXP_BOTTLE, ThrownExpBottleController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.TRIDENT, ThrownTridentController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.TROPICAL_FISH, TropicalFishController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.TURTLE, TurtleController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.PRIMED_TNT, TNTPrimedController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.VEX, VexController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.VILLAGER, VillagerController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.VINDICATOR, VindicatorController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.WOLF, WolfController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.WITCH, WitchController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.WITHER, WitherController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.WITHER_SKULL, WitherSkullController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.WITHER_SKELETON, SkeletonWitherController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ZOMBIE, ZombieController.class);
        EntityControllers.setEntityControllerForType((EntityType)EntityType.ZOMBIE_VILLAGER, ZombieVillagerController.class);
    }

    public void loadPlugins() {
        ((CraftServer)Bukkit.getServer()).enablePlugins(PluginLoadOrder.POSTWORLD);
    }

    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        handle.yaw = yaw = Util.clampYaw((float)yaw);
        this.setHeadYaw(entity, yaw);
        handle.pitch = pitch;
    }

    public void look(Entity entity, Location to, boolean headOnly, boolean immediate) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        if (immediate || headOnly || BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof EntityInsentient) && !(handle instanceof EntityHumanNPC)) {
            Location fromLocation = entity.getLocation(FROM_LOCATION);
            double xDiff = to.getX() - fromLocation.getX();
            double yDiff = to.getY() - fromLocation.getY();
            double zDiff = to.getZ() - fromLocation.getZ();
            double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
            double yaw = Math.toDegrees(Math.acos(xDiff / distanceXZ));
            double pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - (double)(handle.getBukkitEntity().getType() == EntityType.PHANTOM ? 45 : 90);
            if (zDiff < 0.0) {
                yaw += Math.abs(180.0 - yaw) * 2.0;
            }
            yaw = handle instanceof EntityEnderDragon ? (double)this.getDragonYaw(handle, to.getX(), to.getZ()) : (yaw -= 90.0);
            if (headOnly) {
                this.setHeadYaw(entity, (float)yaw);
            } else {
                this.look(entity, (float)yaw, (float)pitch);
            }
            return;
        }
        if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).getControllerLook().a(to.getX(), to.getY(), to.getZ(), (float)((EntityInsentient)handle).dB(), (float)((EntityInsentient)handle).M());
            while (((EntityLiving)handle).aM >= 180.0f) {
                ((EntityLiving)handle).aM -= 360.0f;
            }
            while (((EntityLiving)handle).aM < -180.0f) {
                ((EntityLiving)handle).aM += 360.0f;
            }
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).setTargetLook(to);
        }
    }

    public void look(Entity from, Entity to) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(from);
        net.minecraft.server.v1_14_R1.Entity target = NMSImpl.getHandle(to);
        if (BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType())) {
            if (to instanceof LivingEntity) {
                this.look(from, ((LivingEntity)to).getEyeLocation(), false, true);
            } else {
                this.look(from, to.getLocation(), false, true);
            }
        } else if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).getControllerLook().a(target, (float)((EntityInsentient)handle).dB(), (float)((EntityInsentient)handle).M());
            while (((EntityLiving)handle).aM >= 180.0f) {
                ((EntityLiving)handle).aM -= 360.0f;
            }
            while (((EntityLiving)handle).aM < -180.0f) {
                ((EntityLiving)handle).aM += 360.0f;
            }
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).setTargetLook(target, 10.0f, 40.0f);
        }
    }

    public void mount(Entity entity, Entity passenger) {
        if (NMSImpl.getHandle(passenger) == null) {
            return;
        }
        NMSImpl.getHandle(passenger).startRiding(NMSImpl.getHandle(entity));
    }

    public void openHorseScreen(Tameable horse, Player equipper) {
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)horse);
        EntityLiving equipperHandle = NMSImpl.getHandle((LivingEntity)equipper);
        if (handle == null || equipperHandle == null) {
            return;
        }
        boolean wasTamed = horse.isTamed();
        horse.setTamed(true);
        ((EntityHorseAbstract)handle).c(equipperHandle);
        horse.setTamed(wasTamed);
    }

    public void playAnimation(PlayerAnimation animation, Player player, int radius) {
        PlayerAnimationImpl.play(animation, player, radius);
    }

    public void playerTick(Player entity) {
        ((EntityPlayer)NMSImpl.getHandle((LivingEntity)entity)).playerTick();
    }

    public void registerEntityClass(Class<?> clazz) {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        Class<?> search = clazz;
        while ((search = search.getSuperclass()) != null && net.minecraft.server.v1_14_R1.Entity.class.isAssignableFrom(search)) {
            EntityTypes type = ENTITY_REGISTRY.findType(search);
            MinecraftKey key = ENTITY_REGISTRY.getKey(type);
            if (key == null || type == null) continue;
            CITIZENS_ENTITY_TYPES.put(clazz, type);
            int code = ENTITY_REGISTRY.a(type);
            ENTITY_REGISTRY.put(code, key, type);
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass for class " + clazz.toString());
    }

    public void remove(Entity entity) {
        NMSImpl.getHandle(entity).die();
    }

    public void removeFromServerPlayerList(Player player) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(handle);
    }

    public void removeFromWorld(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        ((WorldServer)nmsEntity.world).removeEntity(nmsEntity);
    }

    public void removeHookIfNecessary(NPCRegistry npcRegistry, FishHook entity) {
        EntityFishingHook hook = (EntityFishingHook)NMSImpl.getHandle((Entity)entity);
        if (hook.hooked == null) {
            return;
        }
        NPC npc = npcRegistry.getNPC((Entity)hook.hooked.getBukkitEntity());
        if (npc == null) {
            return;
        }
        if (npc.isProtected()) {
            hook.hooked = null;
            hook.die();
        }
    }

    public void replaceTrackerEntry(Player player) {
        WorldServer server = (WorldServer)NMSImpl.getHandle((LivingEntity)player).getWorld();
        PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)server.getChunkProvider().playerChunkMap.trackedEntities.get(player.getEntityId());
        if (entry == null) {
            return;
        }
        PlayerlistTracker replace = new PlayerlistTracker(server.getChunkProvider().playerChunkMap, entry);
        server.getChunkProvider().playerChunkMap.trackedEntities.put(player.getEntityId(), (Object)replace);
        if (NMSImpl.getHandle((LivingEntity)player) instanceof EntityHumanNPC) {
            ((EntityHumanNPC)NMSImpl.getHandle((LivingEntity)player)).setTracked(replace);
        }
    }

    public void sendPositionUpdate(Player excluding, Entity from, Location storedLocation) {
        NMSImpl.sendPacketNearby(excluding, storedLocation, new PacketPlayOutEntityTeleport(NMSImpl.getHandle(from)));
    }

    public void sendTabListAdd(Player recipient, Player listPlayer) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)listPlayer);
        EntityPlayer entity = ((CraftPlayer)listPlayer).getHandle();
        NMSImpl.sendPacket(recipient, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{entity}));
    }

    public void sendTabListRemove(Player recipient, Collection<? extends SkinnableEntity> skinnableNPCs) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull(skinnableNPCs);
        EntityPlayer[] entities = new EntityPlayer[skinnableNPCs.size()];
        int i = 0;
        for (SkinnableEntity skinnableEntity : skinnableNPCs) {
            entities[i] = (EntityPlayer)skinnableEntity;
            ++i;
        }
        NMSImpl.sendPacket(recipient, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, entities));
    }

    public void sendTabListRemove(Player recipient, Player listPlayer) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)listPlayer);
        EntityPlayer entity = ((CraftPlayer)listPlayer).getHandle();
        NMSImpl.sendPacket(recipient, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{entity}));
    }

    public void sendTeamPacket(Player recipient, Team team, int mode) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)team);
        if (TEAM_FIELD == null) {
            TEAM_FIELD = NMS.getGetter(team.getClass(), (String)"team");
        }
        try {
            ScoreboardTeam nmsTeam = TEAM_FIELD.invoke(team);
            NMSImpl.sendPacket(recipient, new PacketPlayOutScoreboardTeam(nmsTeam, mode));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setBodyYaw(Entity entity, float yaw) {
        NMSImpl.getHandle((Entity)entity).yaw = yaw;
    }

    public void setDestination(Entity entity, double x, double y, double z, float speed) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).getControllerMove().a(x, y, z, (double)speed);
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).setMoveDestination(x, y, z, speed);
        }
    }

    public void setEndermanAngry(Enderman enderman, boolean angry) {
        if (ENDERMAN_ANGRY == null) {
            return;
        }
        NMSImpl.getHandle((LivingEntity)enderman).getDataWatcher().set(ENDERMAN_ANGRY, (Object)angry);
    }

    public void setHeadYaw(Entity entity, float yaw) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        EntityLiving handle = (EntityLiving)NMSImpl.getHandle(entity);
        handle.aL = yaw = Util.clampYaw((float)yaw);
        if (!(handle instanceof EntityHuman)) {
            handle.aK = yaw;
        }
        handle.aM = yaw;
    }

    public void setKnockbackResistance(LivingEntity entity, double d) {
        EntityLiving handle = NMSImpl.getHandle(entity);
        handle.getAttributeInstance(GenericAttributes.KNOCKBACK_RESISTANCE).setValue(d);
    }

    public void setLyingDown(Entity cat, boolean lying) {
        ((EntityCat)NMSImpl.getHandle(cat)).u(lying);
    }

    public void setNavigationTarget(Entity handle, Entity target, float speed) {
        NMSImpl.getNavigation(handle).a(NMSImpl.getHandle(target), (double)speed);
    }

    public void setNoGravity(Entity entity, boolean enabled) {
        NMSImpl.getHandle(entity).setNoGravity(enabled);
    }

    public void setPandaSitting(Entity entity, boolean sitting) {
    }

    public void setPeekShulker(Entity shulker, int peek) {
        ((EntityShulker)NMSImpl.getHandle(shulker)).a((int)((byte)peek));
    }

    public void setPolarBearRearing(Entity entity, boolean rearing) {
        ((EntityPolarBear)NMSImpl.getHandle(entity)).r(rearing);
    }

    public void setProfile(SkullMeta meta, GameProfile profile) {
        if (SKULL_PROFILE_FIELD == null && (SKULL_PROFILE_FIELD = NMS.getField(meta.getClass(), (String)"profile", (boolean)false)) == null) {
            return;
        }
        try {
            SKULL_PROFILE_FIELD.set(meta, profile);
        }
        catch (Exception exception) {}
    }

    public void setShouldJump(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (handle instanceof EntityInsentient) {
            ControllerJump controller = ((EntityInsentient)handle).getControllerJump();
            controller.jump();
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).setShouldJump();
        }
    }

    public void setSitting(Ocelot ocelot, boolean sitting) {
    }

    public void setSitting(Tameable tameable, boolean sitting) {
        ((EntityTameableAnimal)NMSImpl.getHandle((LivingEntity)tameable)).setSitting(sitting);
    }

    public void setStepHeight(Entity entity, float height) {
        NMSImpl.getHandle((Entity)entity).K = height;
    }

    public void setTeamNameTagVisible(Team team, boolean visible) {
        team.setOption(Team.Option.NAME_TAG_VISIBILITY, visible ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
    }

    public void setVerticalMovement(Entity bukkitEntity, double d) {
        if (!bukkitEntity.getType().isAlive()) {
            return;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)bukkitEntity);
        handle.bb = (float)d;
    }

    public void setWitherCharged(Wither wither, boolean charged) {
        EntityWither handle = ((CraftWither)wither).getHandle();
        handle.r(charged ? 20 : 0);
    }

    public boolean shouldJump(Entity entity) {
        if (JUMP_FIELD == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        try {
            return JUMP_FIELD.invoke(NMSImpl.getHandle(entity));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public void shutdown() {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        MethodHandle field = NMS.getFinalSetter(IRegistry.class, (String)"ENTITY_TYPE");
        try {
            field.invoke(null, ENTITY_REGISTRY.getWrapped());
        }
        catch (Throwable throwable) {}
    }

    public boolean tick(Entity next) {
        net.minecraft.server.v1_14_R1.Entity entity = NMSImpl.getHandle(next);
        net.minecraft.server.v1_14_R1.Entity entity1 = entity.getVehicle();
        if (entity1 != null) {
            if (entity1.dead || !entity1.w(entity)) {
                entity.stopRiding();
            }
        } else {
            if (!entity.dead) {
                try {
                    ((WorldServer)entity.world).entityJoinedWorld(entity);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.a((Throwable)throwable, (String)"Ticking player");
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
                    entity.appendEntityCrashDetails(crashreportsystemdetails);
                    throw new ReportedException(crashreport);
                }
            }
            boolean removeFromPlayerList = (Boolean)((NPCHolder)entity).getNPC().data().get("removefromplayerlist", (Object)Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean());
            if (entity.dead) {
                ((WorldServer)entity.world).removeEntity(entity);
                return true;
            }
            if (!removeFromPlayerList) {
                if (!entity.world.getPlayers().contains(entity)) {
                    List list = entity.world.getPlayers();
                    list.add(entity);
                }
                return true;
            }
            entity.world.getPlayers().remove(entity);
        }
        return false;
    }

    public void trySwim(Entity entity) {
        this.trySwim(entity, 0.04f);
    }

    public void trySwim(Entity entity, float power) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (RANDOM.nextFloat() < 0.8f && (handle.isInWater() || handle.ay())) {
            handle.setMot(handle.getMot().getX(), handle.getMot().getY() + (double)power, handle.getMot().getZ());
        }
    }

    public void updateNavigationWorld(Entity entity, World world) {
        if (NAVIGATION_WORLD_FIELD == null) {
            return;
        }
        net.minecraft.server.v1_14_R1.Entity en = NMSImpl.getHandle(entity);
        if (en == null || !(en instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient handle = (EntityInsentient)en;
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.invoke(handle.getNavigation(), worldHandle);
        }
        catch (Exception e) {
            Messaging.logTr((String)"citizens.nms-errors.updating-navigation-world", (Object[])new Object[]{e.getMessage()});
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void updatePathfindingRange(NPC npc, float pathfindingRange) {
        if (!npc.isSpawned() || !npc.getEntity().getType().isAlive()) {
            return;
        }
        EntityLiving en = NMSImpl.getHandle((LivingEntity)npc.getEntity());
        if (!(en instanceof EntityInsentient)) {
            if (en instanceof EntityHumanNPC) {
                ((EntityHumanNPC)en).updatePathfindingRange(pathfindingRange);
            }
            return;
        }
        if (PATHFINDING_RANGE == null) {
            return;
        }
        EntityInsentient handle = (EntityInsentient)en;
        NavigationAbstract navigation = handle.getNavigation();
        try {
            AttributeInstance inst = PATHFINDING_RANGE.invoke(navigation);
            inst.setValue((double)pathfindingRange);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void checkAndUpdateHeight(EntityLiving living, DataWatcherObject<?> datawatcherobject) {
        EntitySize size;
        try {
            size = SIZE_FIELD_GETTER.invoke(living);
        }
        catch (Throwable e) {
            e.printStackTrace();
            living.a(datawatcherobject);
            return;
        }
        float oldw = size.width;
        float oldl = size.height;
        living.a(datawatcherobject);
        if (oldw != size.width || size.height != oldl) {
            living.setPosition(living.locX - 0.01, living.locY, living.locZ - 0.01);
            living.setPosition(living.locX + 0.01, living.locY, living.locZ + 0.01);
        }
    }

    public static void clearGoals(PathfinderGoalSelector ... goalSelectors) {
        if (GOAL_FIELD == null || goalSelectors == null) {
            return;
        }
        PathfinderGoalSelector[] pathfinderGoalSelectorArray = goalSelectors;
        int n = goalSelectors.length;
        int n2 = 0;
        while (n2 < n) {
            PathfinderGoalSelector selector = pathfinderGoalSelectorArray[n2];
            try {
                Collection list = GOAL_FIELD.invoke(selector);
                list.clear();
            }
            catch (Exception e) {
                Messaging.logTr((String)"citizens.nms-errors.clearing-goals", (Object[])new Object[]{e.getLocalizedMessage()});
            }
            catch (Throwable e) {
                Messaging.logTr((String)"citizens.nms-errors.clearing-goals", (Object[])new Object[]{e.getLocalizedMessage()});
            }
            ++n2;
        }
    }

    public static void flyingMoveLogic(EntityLiving entity, Vec3D vec3d) {
        double d8;
        float f;
        double d0;
        if (entity.df() || entity.ca()) {
            boolean flag;
            d0 = 0.08;
            boolean bl = flag = entity.getMot().y <= 0.0;
            if (flag && entity.hasEffect(MobEffects.SLOW_FALLING)) {
                d0 = 0.01;
                entity.fallDistance = 0.0f;
            }
            if (!entity.isInWater() || entity instanceof EntityHuman && ((EntityHuman)entity).abilities.isFlying) {
                if (!(!entity.aD() || entity instanceof EntityHuman && ((EntityHuman)entity).abilities.isFlying)) {
                    double d1 = entity.locY;
                    entity.a(0.02f, vec3d);
                    entity.move(EnumMoveType.SELF, entity.getMot());
                    entity.setMot(entity.getMot().a(0.5));
                    if (!entity.isNoGravity()) {
                        entity.setMot(entity.getMot().add(0.0, -d0 / 4.0, 0.0));
                    }
                    Vec3D vec3d4 = entity.getMot();
                    if (entity.positionChanged && entity.d(vec3d4.x, vec3d4.y + (double)0.6f - entity.locY + d1, vec3d4.z)) {
                        entity.setMot(vec3d4.x, (double)0.3f, vec3d4.z);
                    }
                } else if (entity.isGliding()) {
                    double d6;
                    float f4;
                    double d5;
                    Vec3D vec3d4 = entity.getMot();
                    if (vec3d4.y > -0.5) {
                        entity.fallDistance = 1.0f;
                    }
                    Vec3D vec3d5 = entity.getLookDirection();
                    float f1 = entity.pitch * ((float)Math.PI / 180);
                    double d3 = Math.sqrt(vec3d5.x * vec3d5.x + vec3d5.z * vec3d5.z);
                    double d4 = Math.sqrt(net.minecraft.server.v1_14_R1.Entity.b((Vec3D)vec3d4));
                    double d2 = vec3d5.f();
                    float f3 = MathHelper.cos((float)f1);
                    f3 = (float)((double)f3 * (double)f3 * Math.min(1.0, d2 / 0.4));
                    vec3d4 = entity.getMot().add(0.0, d0 * (-1.0 + (double)f3 * 0.75), 0.0);
                    if (vec3d4.y < 0.0 && d3 > 0.0) {
                        d5 = vec3d4.y * -0.1 * (double)f3;
                        vec3d4 = vec3d4.add(vec3d5.x * d5 / d3, d5, vec3d5.z * d5 / d3);
                    }
                    if (f1 < 0.0f && d3 > 0.0) {
                        d5 = d4 * (double)(-MathHelper.sin((float)f1)) * 0.04;
                        vec3d4 = vec3d4.add(-vec3d5.x * d5 / d3, d5 * 3.2, -vec3d5.z * d5 / d3);
                    }
                    if (d3 > 0.0) {
                        vec3d4 = vec3d4.add((vec3d5.x / d3 * d4 - vec3d4.x) * 0.1, 0.0, (vec3d5.z / d3 * d4 - vec3d4.z) * 0.1);
                    }
                    entity.setMot(vec3d4.d((double)0.99f, (double)0.98f, (double)0.99f));
                    entity.move(EnumMoveType.SELF, entity.getMot());
                    if (entity.positionChanged && !entity.world.isClientSide && (f4 = (float)((d6 = d4 - (d5 = Math.sqrt(net.minecraft.server.v1_14_R1.Entity.b((Vec3D)entity.getMot())))) * 10.0 - 3.0)) > 0.0f) {
                        try {
                            entity.a(ENTITY_GET_SOUND_FALL.invoke(entity, (int)f4), 1.0f, 1.0f);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        entity.damageEntity(DamageSource.FLY_INTO_WALL, f4);
                    }
                    if (entity.onGround && !entity.world.isClientSide && entity.getFlag(7) && !CraftEventFactory.callToggleGlideEvent((EntityLiving)entity, (boolean)false).isCancelled()) {
                        entity.setFlag(7, false);
                    }
                } else {
                    BlockPosition blockposition = new BlockPosition(entity.locX, entity.getBoundingBox().minY - 1.0, entity.locZ);
                    float f5 = entity.world.getType(blockposition).getBlock().m();
                    float f1 = entity.onGround ? f5 * 0.91f : 0.91f;
                    try {
                        entity.a(ENTITY_R.invoke(entity, f5), vec3d);
                        entity.setMot(ISCLIMBING_METHOD.invoke(entity, entity.getMot()));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    entity.move(EnumMoveType.SELF, entity.getMot());
                    Vec3D vec3d2 = entity.getMot();
                    try {
                        if ((entity.positionChanged || JUMP_FIELD.invoke(entity)) && entity.isClimbing()) {
                            vec3d2 = new Vec3D(vec3d2.x, 0.2, vec3d2.z);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    double d7 = vec3d2.y;
                    if (entity.hasEffect(MobEffects.LEVITATION)) {
                        d7 += (0.05 * (double)(entity.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - vec3d2.y) * 0.2;
                        entity.fallDistance = 0.0f;
                    } else if (entity.world.isClientSide && !entity.world.isLoaded(blockposition)) {
                        d7 = entity.locY > 0.0 ? -0.1 : 0.0;
                    } else if (!entity.isNoGravity()) {
                        d7 -= d0;
                    }
                    entity.setMot(vec3d2.x * (double)f1, d7 * (double)0.98f, vec3d2.z * (double)f1);
                }
            } else {
                Vec3D vec3d2;
                double d1 = entity.locY;
                float f1 = entity.isSprinting() ? 0.9f : (entity instanceof EntityPolarBear ? 0.98f : 0.8f);
                f = 0.02f;
                float f2 = EnchantmentManager.e((EntityLiving)entity);
                if (f2 > 3.0f) {
                    f2 = 3.0f;
                }
                if (!entity.onGround) {
                    f2 *= 0.5f;
                }
                if (f2 > 0.0f) {
                    f1 += (0.54600006f - f1) * f2 / 3.0f;
                    f += (entity.db() - f) * f2 / 3.0f;
                }
                if (entity.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    f1 = 0.96f;
                }
                entity.a(f, vec3d);
                entity.move(EnumMoveType.SELF, entity.getMot());
                Vec3D vec3d5 = entity.getMot();
                if (entity.positionChanged && entity.isClimbing()) {
                    vec3d5 = new Vec3D(vec3d5.x, 0.2, vec3d5.z);
                }
                entity.setMot(vec3d5.d((double)f1, (double)0.8f, (double)f1));
                if (!entity.isNoGravity() && !entity.isSprinting()) {
                    vec3d2 = entity.getMot();
                    double d2 = flag && Math.abs(vec3d2.y - 0.005) >= 0.003 && Math.abs(vec3d2.y - d0 / 16.0) < 0.003 ? -0.003 : vec3d2.y - d0 / 16.0;
                    entity.setMot(vec3d2.x, d2, vec3d2.z);
                }
                vec3d2 = entity.getMot();
                if (entity.positionChanged && entity.d(vec3d2.x, vec3d2.y + (double)0.6f - entity.locY + d1, vec3d2.z)) {
                    entity.setMot(vec3d2.x, (double)0.3f, vec3d2.z);
                }
            }
        }
        entity.aE = entity.aF;
        d0 = entity.locX - entity.lastX;
        double d9 = entity instanceof EntityBird ? entity.locY - entity.lastY : 0.0;
        f = MathHelper.sqrt((double)(d0 * d0 + d9 * d9 + (d8 = entity.locZ - entity.lastZ) * d8)) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        entity.aF += (f - entity.aF) * 0.4f;
        entity.aG += entity.aF;
    }

    public static TreeMap<?, ?> getBehaviorMap(EntityLiving entity) {
        try {
            return BEHAVIOR_MAP.invoke(entity.getBehaviorController());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BlockPosition.PooledBlockPosition getBlockPositionBE(BlockPosition.PooledBlockPosition blockPos, double x, double y, double z) {
        try {
            return blockPos.c(x, y, z);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            try {
                return BLOCK_POSITION_B_D.invoke(blockPos, x, y, z);
            }
            catch (Throwable ex2) {
                ex2.printStackTrace();
                return null;
            }
        }
    }

    public static <T extends net.minecraft.server.v1_14_R1.Entity> EntityTypes<T> getEntityType(Class<?> clazz) {
        return CITIZENS_ENTITY_TYPES.get(clazz);
    }

    private static EntityLiving getHandle(LivingEntity entity) {
        return (EntityLiving)NMSImpl.getHandle((Entity)entity);
    }

    public static net.minecraft.server.v1_14_R1.Entity getHandle(Entity entity) {
        if (!(entity instanceof CraftEntity)) {
            return null;
        }
        return ((CraftEntity)entity).getHandle();
    }

    public static float getHeadYaw(EntityLiving handle) {
        return handle.getHeadRotation();
    }

    public static NavigationAbstract getNavigation(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity handle = NMSImpl.getHandle(entity);
        return handle instanceof EntityInsentient ? ((EntityInsentient)handle).getNavigation() : (handle instanceof EntityHumanNPC ? ((EntityHumanNPC)handle).getNavigation() : null);
    }

    public static DataWatcherObject<Integer> getRabbitTypeField() {
        if (RABBIT_FIELD == null) {
            return null;
        }
        try {
            return RABBIT_FIELD.invoke();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SoundEffect getSoundEffect(NPC npc, SoundEffect snd, String meta) {
        return npc == null || !npc.data().has(meta) ? snd : (SoundEffect)IRegistry.SOUND_EVENT.get(new MinecraftKey((String)npc.data().get(meta, (Object)(snd == null ? "" : snd.toString()))));
    }

    public static void initNetworkManager(NetworkManager network) {
        SocketAddress socketAddress;
        network.channel = new EmptyChannel(null);
        network.socketAddress = socketAddress = new SocketAddress(){
            private static final long serialVersionUID = 8207338859896320185L;
        };
    }

    public static boolean isNavigationFinished(NavigationAbstract navigation) {
        return navigation.n();
    }

    public static void minecartItemLogic(EntityMinecartAbstract minecart) {
        NPC npc = ((NPCHolder)minecart).getNPC();
        if (npc == null) {
            return;
        }
        Material mat = Material.getMaterial((String)((String)npc.data().get("minecart-item-name", (Object)"")));
        ((Integer)npc.data().get("minecart-item-data", (Object)0)).intValue();
        int offset = (Integer)npc.data().get("minecart-item-offset", (Object)0);
        minecart.a(mat != null);
        if (mat != null) {
            minecart.setDisplayBlock(Block.getByCombinedId((int)mat.getId()).getBlock().getBlockData());
        }
        minecart.setDisplayBlockOffset(offset);
    }

    public static void resetPuffTicks(EntityPufferFish fish) {
        try {
            PUFFERFISH_C.invoke(fish, 0);
            PUFFERFISH_D.invoke(fish, 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void sendPacket(Player player, Packet<?> packet) {
        if (packet == null) {
            return;
        }
        ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).playerConnection.sendPacket(packet);
    }

    public static void sendPacketNearby(Player from, Location location, Packet<?> packet) {
        NMSImpl.sendPacketNearby(from, location, packet, 64.0);
    }

    public static void sendPacketNearby(Player from, Location location, Packet<?> packet, double radius) {
        ArrayList list = new ArrayList();
        list.add(packet);
        NMSImpl.sendPacketsNearby(from, location, list, radius);
    }

    public static void sendPacketsNearby(Player from, Location location, Collection<Packet<?>> packets, double radius) {
        radius *= radius;
        World world = location.getWorld();
        for (Player ply : Bukkit.getServer().getOnlinePlayers()) {
            if (ply == null || world != ply.getWorld() || from != null && !ply.canSee(from) || location.distanceSquared(ply.getLocation(PACKET_CACHE_LOCATION)) > radius) continue;
            for (Packet<?> packet : packets) {
                NMSImpl.sendPacket(ply, packet);
            }
        }
    }

    public static void sendPacketsNearby(Player from, Location location, Packet<?> ... packets) {
        NMSImpl.sendPacketsNearby(from, location, Arrays.asList(packets), 64.0);
    }

    public static void setAdvancement(Player entity, AdvancementDataPlayer instance) {
        try {
            ADVANCEMENT_PLAYER_FIELD.invoke(NMSImpl.getHandle((LivingEntity)entity), instance);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setBukkitEntity(net.minecraft.server.v1_14_R1.Entity entity, CraftEntity bukkitEntity) {
        try {
            BUKKITENTITY_FIELD_SETTER.invoke(entity, bukkitEntity);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setNotInSchool(EntityFish entity) {
        try {
            if (ENTITY_FISH_NUM_IN_SCHOOL != null) {
                ENTITY_FISH_NUM_IN_SCHOOL.invoke(entity, 2);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void setSize(net.minecraft.server.v1_14_R1.Entity entity, boolean justCreated) {
        try {
            EntitySize entitysize = SIZE_FIELD_GETTER.invoke(entity);
            EntityPose entitypose = entity.getPose();
            EntitySize entitysize1 = entity.a(entitypose);
            SIZE_FIELD_SETTER.invoke(entity, entitysize1);
            HEAD_HEIGHT.invoke(entity, HEAD_HEIGHT_METHOD.invoke(entity, entitypose, entitysize1));
            float cfr_ignored_0 = entitysize1.width;
            float cfr_ignored_1 = entitysize.width;
            AxisAlignedBB axisalignedbb = entity.getBoundingBox();
            entity.a(new AxisAlignedBB(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ, axisalignedbb.minX + (double)entitysize1.width, axisalignedbb.minY + (double)entitysize1.height, axisalignedbb.minZ + (double)entitysize1.width));
            if (entitysize1.width > entitysize.width && !justCreated && !entity.world.isClientSide) {
                float f = entitysize.width - entitysize1.width;
                entity.move(EnumMoveType.SELF, new Vec3D((double)f, 0.0, (double)f));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void stopNavigation(NavigationAbstract navigation) {
        navigation.o();
    }

    public static void updateAI(EntityLiving entity) {
        if (entity instanceof EntityInsentient) {
            EntityInsentient handle = (EntityInsentient)entity;
            handle.getEntitySenses().a();
            NMSImpl.updateNavigation(handle.getNavigation());
            handle.getControllerMove().a();
            handle.getControllerLook().a();
            handle.getControllerJump().b();
        } else if (entity instanceof EntityHumanNPC) {
            ((EntityHumanNPC)entity).updateAI();
        }
    }

    public static void updateNavigation(NavigationAbstract navigation) {
        navigation.c();
    }

    private static class NavigationFieldWrapper
    implements MCTargetStrategy.TargetNavigator {
        private final NavigationAbstract navigation;
        private final NavigatorParameters parameters;
        private final Entity target;

        private NavigationFieldWrapper(NavigationAbstract navigation, Entity target, NavigatorParameters parameters) {
            this.navigation = navigation;
            this.target = target;
            this.parameters = parameters;
        }

        public Iterable<Vector> getPath() {
            return new NavigationIterable(this.navigation);
        }

        public void setPath() {
            Location location = (Location)this.parameters.entityTargetLocationMapper().apply((Object)this.target);
            if (location == null) {
                throw new IllegalStateException("mapper should not return null");
            }
            this.navigation.a(location.getX(), location.getY(), location.getZ(), (double)this.parameters.speed());
        }

        public void stop() {
            NMSImpl.stopNavigation(this.navigation);
        }

        public void update() {
            NMSImpl.updateNavigation(this.navigation);
        }
    }

    private static class NavigationIterable
    implements Iterable<Vector> {
        private final NavigationAbstract navigation;

        public NavigationIterable(NavigationAbstract nav) {
            this.navigation = nav;
        }

        @Override
        public Iterator<Vector> iterator() {
            final int npoints = this.navigation.l() == null ? 0 : this.navigation.l().e();
            return new Iterator<Vector>(){
                PathPoint curr;
                int i;
                {
                    this.curr = n > 0 ? navigationIterable.navigation.l().a(0) : null;
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.curr != null;
                }

                @Override
                public Vector next() {
                    PathPoint old = this.curr;
                    this.curr = this.i + 1 < npoints ? navigation.l().a(++this.i) : null;
                    return new Vector(old.a, old.b, old.c);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

