/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface CompoundTagSetter<R> {
    public @NonNull R put(@NonNull String var1, @NonNull BinaryTag var2);

    default public @NonNull R putByte(@NonNull String key, byte value) {
        return this.put(key, ByteBinaryTag.of(value));
    }

    default public @NonNull R putShort(@NonNull String key, short value) {
        return this.put(key, ShortBinaryTag.of(value));
    }

    default public @NonNull R putInt(@NonNull String key, int value) {
        return this.put(key, IntBinaryTag.of(value));
    }

    default public @NonNull R putLong(@NonNull String key, long value) {
        return this.put(key, LongBinaryTag.of(value));
    }

    default public @NonNull R putFloat(@NonNull String key, float value) {
        return this.put(key, FloatBinaryTag.of(value));
    }

    default public @NonNull R putDouble(@NonNull String key, double value) {
        return this.put(key, DoubleBinaryTag.of(value));
    }

    default public @NonNull R putByteArray(@NonNull String key, byte @NonNull [] value) {
        return this.put(key, ByteArrayBinaryTag.of(value));
    }

    default public @NonNull R putString(@NonNull String key, @NonNull String value) {
        return this.put(key, StringBinaryTag.of(value));
    }

    default public @NonNull R putIntArray(@NonNull String key, int @NonNull [] value) {
        return this.put(key, IntArrayBinaryTag.of(value));
    }

    default public @NonNull R putLongArray(@NonNull String key, long @NonNull [] value) {
        return this.put(key, LongArrayBinaryTag.of(value));
    }
}

