/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.common;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.AudienceProvider;
import net.kyori.adventure.platform.common.audience.AdventureAudience;
import net.kyori.adventure.platform.common.audience.AdventurePlayerAudience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractAudienceProvider
implements AudienceProvider {
    private Audience all;
    private Audience console;
    private Audience players;
    private Map<UUID, AdventurePlayerAudience> playerMap;
    private Set<AdventureAudience> senderSet = ConcurrentHashMap.newKeySet();
    private Map<String, Audience> permissionMap;
    private Map<Key, Audience> worldMap;
    private Map<String, Audience> serverMap;
    private ComponentRenderer<Locale> localeRenderer;
    private volatile boolean closed = false;

    protected AbstractAudienceProvider() {
        this.all = () -> this.senderSet;
        this.playerMap = new ConcurrentHashMap<UUID, AdventurePlayerAudience>();
        this.players = () -> this.playerMap.values();
        this.console = new ConsoleAudience();
        this.permissionMap = new ConcurrentHashMap<String, Audience>();
        this.worldMap = new ConcurrentHashMap<Key, Audience>();
        this.serverMap = new ConcurrentHashMap<String, Audience>();
        this.localeRenderer = new ComponentRenderer<Locale>(){

            public @NonNull Component render(@NonNull Component component, @NonNull Locale context) {
                return component;
            }
        };
    }

    protected void add(AdventureAudience audience) {
        if (this.closed) {
            return;
        }
        this.senderSet.add(audience);
        if (audience instanceof AdventurePlayerAudience) {
            this.playerMap.put(((AdventurePlayerAudience)audience).id(), (AdventurePlayerAudience)audience);
        }
    }

    protected void remove(UUID playerId) {
        Audience removed = this.playerMap.remove(playerId);
        if (removed != null) {
            this.senderSet.remove(removed);
        }
    }

    public @NonNull Audience all() {
        return this.all;
    }

    public @NonNull Audience console() {
        return this.console;
    }

    public @NonNull Audience players() {
        return this.players;
    }

    public @NonNull Audience player(@NonNull UUID playerId) {
        AdventurePlayerAudience player = this.playerMap.get(playerId);
        return player == null ? Audience.empty() : player;
    }

    public @NonNull Audience permission(@NonNull String permission) {
        return this.permissionMap.computeIfAbsent(permission, x$0 -> new PermissionAudience((String)x$0));
    }

    public @NonNull Audience world(@NonNull Key world) {
        return this.worldMap.computeIfAbsent(world, x$0 -> new WorldAudience((Key)x$0));
    }

    public @NonNull Audience server(@NonNull String serverName) {
        return this.serverMap.computeIfAbsent(serverName, x$0 -> new ServerAudience((String)x$0));
    }

    public @NonNull ComponentRenderer<Locale> localeRenderer() {
        return this.localeRenderer;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.all = Audience.empty();
            this.console = Audience.empty();
            this.players = Audience.empty();
            this.playerMap = Collections.emptyMap();
            this.senderSet = Collections.emptySet();
            this.permissionMap = Collections.emptyMap();
            this.worldMap = Collections.emptyMap();
            this.serverMap = Collections.emptyMap();
        }
    }

    private static <T> Iterable<T> filter(final Iterable<T> input, final Predicate<T> filter) {
        return new Iterable<T>(){

            @Override
            public @NonNull Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<T> parent;
                    private T next;
                    {
                        this.parent = input.iterator();
                        this.populate();
                    }

                    private void populate() {
                        this.next = null;
                        while (this.parent.hasNext()) {
                            Object next = this.parent.next();
                            if (!filter.test(next)) continue;
                            this.next = next;
                            return;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Object next = this.next;
                        this.populate();
                        return next;
                    }
                };
            }

            @Override
            public void forEach(Consumer<? super T> action) {
                for (Object each : input) {
                    if (!filter.test(each)) continue;
                    action.accept(each);
                }
            }
        };
    }

    private final class ServerAudience
    implements ForwardingAudience {
        private final Iterable<AdventurePlayerAudience> filtered;
        private final String serverName;

        private ServerAudience(String serverName) {
            this.filtered = AbstractAudienceProvider.filter(AbstractAudienceProvider.this.playerMap.values(), this::isOnServer);
            this.serverName = Objects.requireNonNull(serverName, "server name");
        }

        private boolean isOnServer(AdventurePlayerAudience audience) {
            return this.serverName.equals(audience.serverName());
        }

        public @NonNull Iterable<? extends Audience> audiences() {
            return this.filtered;
        }
    }

    private final class WorldAudience
    implements ForwardingAudience {
        private final Iterable<AdventurePlayerAudience> filtered;
        private final Key world;

        private WorldAudience(Key world) {
            this.filtered = AbstractAudienceProvider.filter(AbstractAudienceProvider.this.playerMap.values(), this::inWorld);
            this.world = Objects.requireNonNull(world, "world id");
        }

        private boolean inWorld(AdventurePlayerAudience audience) {
            return this.world.equals(audience.world());
        }

        public @NonNull Iterable<? extends Audience> audiences() {
            return this.filtered;
        }
    }

    private final class PermissionAudience
    implements ForwardingAudience {
        private final Iterable<AdventureAudience> filtered;
        private final String permission;

        private PermissionAudience(String permission) {
            this.filtered = AbstractAudienceProvider.filter(AbstractAudienceProvider.this.senderSet, this::hasPermission);
            this.permission = Objects.requireNonNull(permission, "permission");
        }

        private boolean hasPermission(@NonNull AdventureAudience audience) {
            return audience.hasPermission(this.permission);
        }

        public @NonNull Iterable<? extends Audience> audiences() {
            return this.filtered;
        }
    }

    private class ConsoleAudience
    implements ForwardingAudience {
        private final Iterable<AdventureAudience> console;

        private ConsoleAudience() {
            this.console = AbstractAudienceProvider.filter(AbstractAudienceProvider.this.senderSet, AdventureAudience::console);
        }

        public @NonNull Iterable<? extends Audience> audiences() {
            return this.console;
        }
    }
}

