/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.common;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.platform.common.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractBossBarListener<V, I>
implements Handler.BossBars<V>,
BossBar.Listener {
    private final Map<BossBar, I> bars = Collections.synchronizedMap(new IdentityHashMap());

    @Override
    public void show(@NonNull V viewer, @NonNull BossBar bar) {
        Object instance = this.bars.computeIfAbsent(bar, adventure -> {
            adventure.addListener((BossBar.Listener)this);
            return this.newInstance((BossBar)adventure);
        });
        this.show(viewer, instance);
    }

    protected <T> void handle(BossBar adventure, T changedValue, BiConsumer<T, I> handler) {
        I instance = this.bars.get(adventure);
        if (instance != null) {
            handler.accept(changedValue, instance);
        }
    }

    protected abstract @NonNull I newInstance(@NonNull BossBar var1);

    protected abstract void show(@NonNull V var1, @NonNull I var2);

    protected abstract boolean hide(@NonNull V var1, @NonNull I var2);

    protected abstract boolean isEmpty(@NonNull I var1);

    protected abstract void hideFromAll(@NonNull I var1);

    @Override
    public void hide(@NonNull V viewer, @NonNull BossBar bar) {
        this.bars.computeIfPresent(bar, (adventure, existing) -> {
            this.hide(viewer, existing);
            if (this.isEmpty(existing)) {
                return null;
            }
            return existing;
        });
    }

    @Override
    public void hideAll(@NonNull V viewer) {
        Iterator<Map.Entry<BossBar, I>> it = this.bars.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BossBar, I> entry = it.next();
            if (!this.hide(viewer, entry.getValue()) || !this.isEmpty(entry.getValue())) continue;
            entry.getKey().removeListener((BossBar.Listener)this);
            it.remove();
        }
    }

    @Override
    public void hideAll() {
        for (Map.Entry<BossBar, I> entry : this.bars.entrySet()) {
            entry.getKey().removeListener((BossBar.Listener)this);
            this.hideFromAll(entry.getValue());
        }
        this.bars.clear();
    }
}

