/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.common;

import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.platform.common.Handler;
import net.kyori.adventure.platform.common.HandlerCollection;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HandledAudience<V>
implements Audience {
    protected final V viewer;
    private final @Nullable Handler.Chat<? super V, ?> chatHandler;
    private final @Nullable Handler.ActionBar<? super V, ?> actionBarHandler;
    private final Handler.Titles<? super V> titleHandler;
    private final Handler.BossBars<? super V> bossBarHandler;
    private final @Nullable Handler.PlaySound<? super V> soundHandler;
    private final @Nullable Handler.Books<? super V> bookHandler;

    public HandledAudience(@NonNull V viewer, @Nullable HandlerCollection<? super V, ? extends Handler.Chat<? super V, ?>> chat, @Nullable HandlerCollection<? super V, ? extends Handler.ActionBar<? super V, ?>> actionBar, @Nullable HandlerCollection<? super V, ? extends Handler.Titles<? super V>> title, @Nullable HandlerCollection<? super V, ? extends Handler.BossBars<? super V>> bossBar, @Nullable HandlerCollection<? super V, ? extends Handler.PlaySound<? super V>> sound, @Nullable HandlerCollection<? super V, ? extends Handler.Books<? super V>> books) {
        this.viewer = Objects.requireNonNull(viewer, "viewer");
        this.chatHandler = HandledAudience.handler(chat, viewer);
        this.actionBarHandler = HandledAudience.handler(actionBar, viewer);
        this.titleHandler = HandledAudience.handler(title, viewer);
        this.bossBarHandler = HandledAudience.handler(bossBar, viewer);
        this.soundHandler = HandledAudience.handler(sound, viewer);
        this.bookHandler = HandledAudience.handler(books, viewer);
    }

    private static <V, H extends Handler<? super V>> H handler(HandlerCollection<? super V, H> collection, V viewer) {
        return collection != null ? (H)collection.get((V)viewer) : null;
    }

    public void sendMessage(@NonNull Component message, @NonNull MessageType type) {
        this.sendMessage0(this.chatHandler, Objects.requireNonNull(message, "message"), type);
    }

    private <S> void sendMessage0(@Nullable Handler.Chat<? super V, S> handler, @NonNull Component message, @NonNull MessageType type) {
        if (handler != null) {
            handler.send(this.viewer, handler.initState(message, type), type);
        }
    }

    public void showBossBar(@NonNull BossBar bar) {
        if (this.bossBarHandler != null) {
            this.bossBarHandler.show(this.viewer, Objects.requireNonNull(bar, "bar"));
        }
    }

    public void hideBossBar(@NonNull BossBar bar) {
        if (this.bossBarHandler != null) {
            this.bossBarHandler.hide(this.viewer, Objects.requireNonNull(bar, "bar"));
        }
    }

    public void sendActionBar(@NonNull Component message) {
        this.sendActionBar0(this.actionBarHandler, Objects.requireNonNull(message, "message"));
    }

    private <S> void sendActionBar0(@Nullable Handler.ActionBar<? super V, S> handler, @NonNull Component message) {
        if (handler != null) {
            handler.send(this.viewer, handler.initState(message));
        }
    }

    public void playSound(@NonNull Sound sound) {
        if (this.soundHandler != null) {
            this.soundHandler.play(this.viewer, Objects.requireNonNull(sound, "sound"));
        }
    }

    public void playSound(@NonNull Sound sound, double x, double y, double z) {
        if (this.soundHandler != null) {
            this.soundHandler.play(this.viewer, Objects.requireNonNull(sound, "sound"), x, y, z);
        }
    }

    public void stopSound(@NonNull SoundStop stop) {
        if (this.soundHandler != null) {
            this.soundHandler.stop(this.viewer, Objects.requireNonNull(stop, "stop"));
        }
    }

    public void openBook(@NonNull Book book) {
        if (this.bookHandler != null) {
            this.bookHandler.openBook(this.viewer, book);
        }
    }

    public void showTitle(@NonNull Title title) {
        if (this.titleHandler != null) {
            this.titleHandler.send(this.viewer, Objects.requireNonNull(title, "title"));
        }
    }

    public void clearTitle() {
        if (this.titleHandler != null) {
            this.titleHandler.clear(this.viewer);
        }
    }

    public void resetTitle() {
        if (this.titleHandler != null) {
            this.titleHandler.reset(this.viewer);
        }
    }
}

