/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.common;

import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Handler<V> {
    public boolean isAvailable();

    default public boolean isAvailable(@NonNull V viewer) {
        return true;
    }

    public static interface Books<V>
    extends Handler<V> {
        public void openBook(@NonNull V var1, @NonNull Book var2);
    }

    public static interface PlaySound<V>
    extends Handler<V> {
        public void play(@NonNull V var1, @NonNull Sound var2);

        public void play(@NonNull V var1, @NonNull Sound var2, double var3, double var5, double var7);

        public void stop(@NonNull V var1, @NonNull SoundStop var2);
    }

    public static interface BossBars<V>
    extends Handler<V> {
        public static final int ACTION_ADD = 0;
        public static final int ACTION_REMOVE = 1;
        public static final int ACTION_PERCENT = 2;
        public static final int ACTION_NAME = 3;
        public static final int ACTION_STYLE = 4;
        public static final int ACTION_FLAGS = 5;
        public static final byte FLAG_DARKEN_SCREEN = 1;
        public static final byte FLAG_BOSS_MUSIC = 2;
        public static final byte FLAG_CREATE_WORLD_FOG = 4;

        public static byte bitmaskFlags(@NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
        BossBar.Flag> flags) {
            byte ret = 0;
            if (flags.contains(BossBar.Flag.DARKEN_SCREEN)) {
                ret = (byte)(ret | 1);
            }
            if (flags.contains(BossBar.Flag.PLAY_BOSS_MUSIC)) {
                ret = (byte)(ret | 2);
            }
            if (flags.contains(BossBar.Flag.CREATE_WORLD_FOG)) {
                ret = (byte)(ret | 4);
            }
            return ret;
        }

        public static int color(BossBar.Color color) {
            switch (color) {
                case PINK: {
                    return 0;
                }
                case BLUE: {
                    return 1;
                }
                case RED: {
                    return 2;
                }
                case GREEN: {
                    return 3;
                }
                case YELLOW: {
                    return 4;
                }
                case WHITE: {
                    return 6;
                }
            }
            return 5;
        }

        public static int overlay(BossBar.Overlay overlay) {
            switch (overlay) {
                case NOTCHED_6: {
                    return 1;
                }
                case NOTCHED_10: {
                    return 2;
                }
                case NOTCHED_12: {
                    return 3;
                }
                case NOTCHED_20: {
                    return 4;
                }
            }
            return 0;
        }

        public void show(@NonNull V var1, @NonNull BossBar var2);

        public void hide(@NonNull V var1, @NonNull BossBar var2);

        public void hideAll(@NonNull V var1);

        public void hideAll();
    }

    public static interface Titles<V>
    extends Handler<V> {
        public static final int DURATION_PRESERVE = -1;

        public void send(@NonNull V var1, @NonNull Title var2);

        public void clear(@NonNull V var1);

        public void reset(@NonNull V var1);

        public static int ticks(@NonNull Duration time) {
            return time.isNegative() ? -1 : (int)Math.ceil((double)time.toMillis() / 50.0);
        }
    }

    public static interface ActionBar<V, S>
    extends Handler<V> {
        public S initState(@NonNull Component var1);

        public void send(@NonNull V var1, @NonNull S var2);
    }

    public static interface Chat<V, S>
    extends Handler<V> {
        public static final UUID NIL_UUID = new UUID(0L, 0L);
        public static final byte TYPE_CHAT = 0;
        public static final byte TYPE_SYSTEM = 1;
        public static final byte TYPE_ACTIONBAR = 2;

        public S initState(@NonNull Component var1, MessageType var2);

        public void send(@NonNull V var1, @NonNull S var2, MessageType var3);

        public static byte messageType(@NonNull MessageType type) {
            if (type == MessageType.CHAT) {
                return 0;
            }
            return 1;
        }
    }
}

