/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.common;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.platform.common.Handler;
import net.kyori.adventure.platform.common.Knobs;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class HandlerCollection<V, H extends Handler<V>>
implements Iterable<H> {
    private final @NonNull List<H> handlers;

    @SafeVarargs
    public static <V, H extends Handler<V>> HandlerCollection<V, H> of(H ... handlers) {
        List handlerList = Stream.of(handlers).filter(Objects::nonNull).filter(Handler::isAvailable).collect(Collectors.toList());
        if (handlerList.isEmpty()) {
            return new HandlerCollection(Collections.emptyList());
        }
        if (handlerList.size() == 1) {
            return new HandlerCollection(Collections.singletonList(handlerList.get(0)));
        }
        return new HandlerCollection(Collections.unmodifiableList(handlerList));
    }

    private HandlerCollection(@NonNull List<H> handlers) {
        this.handlers = handlers;
    }

    public @Nullable H get(V viewer) {
        for (Handler handler : this.handlers) {
            if (!handler.isAvailable(viewer)) continue;
            Knobs.logChosenHandler(viewer, handler);
            return (H)handler;
        }
        Knobs.logChosenHandler(viewer, null);
        return null;
    }

    @Override
    public @NonNull Iterator<H> iterator() {
        return this.handlers.iterator();
    }

    @Override
    public void forEach(Consumer<? super H> action) {
        this.handlers.forEach(action);
    }

    @Override
    public Spliterator<H> spliterator() {
        return this.handlers.spliterator();
    }
}

