/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.common;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.platform.common.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Knobs {
    private static final String PROPERTY_PREFIX = "net.kyo".concat("ri.adventure.");
    private static final @NonNull Pattern COMMA_SPLIT = Pattern.compile(",");
    private static final Set<String> DISABLED_PROVIDERS = Knobs.set("disabled");
    private static final boolean PRINT_ERRORS = Knobs.bool("printErrors", false);
    private static final boolean PRINT_CHOSEN_HANDLER = Knobs.bool("printChosenHandler", false);
    private static LogHandler logger = new DefaultLogHandler();

    private Knobs() {
    }

    private static boolean bool(@NonNull String key, boolean def) {
        String property = System.getProperty(PROPERTY_PREFIX + key);
        if (property == null || property.isEmpty()) {
            return def;
        }
        return Boolean.parseBoolean(property);
    }

    private static Set<String> set(@NonNull String key) {
        String prop = System.getProperty(PROPERTY_PREFIX + key);
        if (prop == null || prop.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(COMMA_SPLIT.splitAsStream(prop).map(String::toLowerCase).collect(Collectors.toSet()));
    }

    public static boolean enabled(@NonNull String handlerId) {
        return !DISABLED_PROVIDERS.contains(handlerId.toLowerCase());
    }

    public static void logError(@Nullable Throwable ex) {
        Knobs.logError("performing an operation", ex);
    }

    public static void logError(@NonNull String description, @Nullable Throwable ex) {
        if (PRINT_ERRORS) {
            logger.error(ex, "Adventure detected an error when {0}: {1}.", description, ex == null ? "no exception" : ex.getMessage());
        }
    }

    public static <V> void logChosenHandler(@NonNull V viewer, @Nullable Handler<V> handler) {
        if (PRINT_CHOSEN_HANDLER) {
            if (handler == null) {
                logger.info("No handler found in this collection for viewer {0}", viewer);
            } else {
                logger.info("Chose handler {0} for viewer {1}", handler, viewer);
            }
        }
    }

    public static void logger(@NonNull LogHandler handler) {
        logger = Objects.requireNonNull(handler, "handler");
    }

    static class DefaultLogHandler
    implements LogHandler {
        DefaultLogHandler() {
        }

        @Override
        public void info(@NonNull String message, Object ... params) {
            System.out.println(MessageFormat.format(message, params));
        }

        @Override
        public void error(@Nullable Throwable exc, @NonNull String message, Object ... params) {
            System.err.println(MessageFormat.format(message, params));
            if (exc != null) {
                exc.printStackTrace();
            }
        }
    }

    public static interface LogHandler {
        public void info(@NonNull String var1, Object ... var2);

        public void error(@Nullable Throwable var1, @NonNull String var2, Object ... var3);
    }
}

