/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.common;

import java.io.IOException;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.TagStringIO;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.util.Codec;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NBTLegacyHoverEventSerializer
implements LegacyHoverEventSerializer {
    public static final NBTLegacyHoverEventSerializer INSTANCE = new NBTLegacyHoverEventSerializer();
    private static final TagStringIO SNBT_IO = TagStringIO.get();
    private static final Codec<CompoundBinaryTag, String, IOException, IOException> SNBT_CODEC = Codec.of(arg_0 -> ((TagStringIO)SNBT_IO).asCompound(arg_0), arg_0 -> ((TagStringIO)SNBT_IO).asString(arg_0));
    static final String ITEM_TYPE = "id";
    static final String ITEM_COUNT = "Count";
    static final String ITEM_TAG = "tag";
    static final String ENTITY_NAME = "name";
    static final String ENTITY_TYPE = "type";
    static final String ENTITY_ID = "id";

    private NBTLegacyHoverEventSerializer() {
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull HoverEvent.ShowItem deserializeShowItem(@NonNull Component input) throws IOException {
        if (!(input instanceof TextComponent)) {
            throw new IllegalArgumentException("Legacy events must be single Component instances");
        }
        CompoundBinaryTag contents = (CompoundBinaryTag)SNBT_CODEC.decode((Object)((TextComponent)input).content());
        CompoundBinaryTag tag = contents.getCompound(ITEM_TAG);
        return new HoverEvent.ShowItem(Key.of((String)contents.getString("id")), (int)contents.getByte(ITEM_COUNT, (byte)1), tag == CompoundBinaryTag.empty() ? null : BinaryTagHolder.encode((Object)tag, SNBT_CODEC));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull HoverEvent.ShowEntity deserializeShowEntity(@NonNull Component input, Codec.Decoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        if (!(input instanceof TextComponent)) {
            throw new IllegalArgumentException("Legacy events must be single Component instances");
        }
        CompoundBinaryTag contents = (CompoundBinaryTag)SNBT_CODEC.decode((Object)((TextComponent)input).content());
        return new HoverEvent.ShowEntity(Key.of((String)contents.getString(ENTITY_TYPE)), UUID.fromString(contents.getString("id")), (Component)componentCodec.decode((Object)contents.getString(ENTITY_NAME)));
    }

    public @NonNull Component serializeShowItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull HoverEvent.ShowItem input) throws IOException {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", input.item().asString())).putByte(ITEM_COUNT, (byte)input.count());
        if (input.nbt() != null) {
            builder.put(ITEM_TAG, (BinaryTag)input.nbt().get(SNBT_CODEC));
        }
        return TextComponent.of((String)((String)SNBT_CODEC.encode((Object)builder.build())));
    }

    public @NonNull Component serializeShowEntity(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", input.id().toString())).putString(ENTITY_TYPE, input.type().asString());
        if (input.name() != null) {
            builder.putString(ENTITY_NAME, (String)componentCodec.encode((Object)input.name()));
        }
        return TextComponent.of((String)((String)SNBT_CODEC.encode((Object)builder.build())));
    }
}

