/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import io.leangen.geantyref.TypeToken;
import java.util.Objects;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import net.kyori.adventure.serializer.configurate4.BookTypeSerializer;
import net.kyori.adventure.serializer.configurate4.ComponentTypeSerializer;
import net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import net.kyori.adventure.serializer.configurate4.ConfigurateDataComponentValue;
import net.kyori.adventure.serializer.configurate4.ConfigurateDataComponentValueTypeSerializer;
import net.kyori.adventure.serializer.configurate4.DurationSerializer;
import net.kyori.adventure.serializer.configurate4.HoverEventShowEntitySerializer;
import net.kyori.adventure.serializer.configurate4.HoverEventShowItemSerializer;
import net.kyori.adventure.serializer.configurate4.IndexSerializer;
import net.kyori.adventure.serializer.configurate4.KeySerializer;
import net.kyori.adventure.serializer.configurate4.ProfilePropertySerializer;
import net.kyori.adventure.serializer.configurate4.ShadowColorSerializer;
import net.kyori.adventure.serializer.configurate4.SoundSerializer;
import net.kyori.adventure.serializer.configurate4.SoundStopSerializer;
import net.kyori.adventure.serializer.configurate4.StyleSerializer;
import net.kyori.adventure.serializer.configurate4.TextColorSerializer;
import net.kyori.adventure.serializer.configurate4.TitleSerializer;
import net.kyori.adventure.serializer.configurate4.TranslationArgumentTypeSerializer;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.configurate.util.UnmodifiableCollections;

final class ConfigurateComponentSerializerImpl
implements ConfigurateComponentSerializer {
    static final ConfigurateComponentSerializer INSTANCE = new Builder().build();
    private final TypeSerializerCollection serializers;
    private final ConfigurationOptions ownNodeOptions;
    @Nullable
    private final ComponentSerializer<Component, ?, String> stringSerializer;
    private final boolean serializeStringComponents;

    private ConfigurateComponentSerializerImpl(@NotNull Builder builder) {
        this.stringSerializer = builder.stringSerializer;
        this.serializeStringComponents = builder.outputStringComponents;
        this.serializers = this.makeSerializers(TypeSerializerCollection.defaults().childBuilder());
        this.ownNodeOptions = ConfigurationOptions.defaults().serializers(this.serializers).nativeTypes(UnmodifiableCollections.toSet((Object[])new Class[]{String.class, Integer.class, Boolean.class, Double.class, Float.class}));
    }

    @NotNull
    public Component deserialize(@NotNull ConfigurationNode input) {
        try {
            @Nullable Component deserialized = (Component)input.get(Component.class);
            if (deserialized != null) {
                return deserialized;
            }
        }
        catch (SerializationException e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("No value present");
    }

    @NotNull
    public ConfigurationNode serialize(@NotNull Component component) {
        BasicConfigurationNode base = BasicConfigurationNode.root((ConfigurationOptions)this.ownNodeOptions);
        try {
            base.set(Component.class, (Object)component);
        }
        catch (SerializationException e) {
            throw new IllegalStateException("Unable to serialize component " + component, e);
        }
        return base;
    }

    @NotNull
    private TypeSerializerCollection makeSerializers(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TypeSerializerCollection.Builder serializers) {
        return serializers.register(Book.class, (TypeSerializer)BookTypeSerializer.INSTANCE).register(Title.class, (TypeSerializer)TitleSerializer.INSTANCE).register(Sound.class, (TypeSerializer)SoundSerializer.INSTANCE).register(SoundStop.class, (TypeSerializer)SoundStopSerializer.INSTANCE).register(Component.class, (TypeSerializer)new ComponentTypeSerializer(this.stringSerializer, this.serializeStringComponents)).register((ScalarSerializer)KeySerializer.INSTANCE).register((ScalarSerializer)DurationSerializer.INSTANCE).register(Style.class, (TypeSerializer)StyleSerializer.INSTANCE).register((ScalarSerializer)TextColorSerializer.INSTANCE).register((ScalarSerializer)BlockNBTPosSerializer.INSTANCE).register(TranslationArgument.class, (TypeSerializer)TranslationArgumentTypeSerializer.INSTANCE).registerExact(new IndexSerializer(TypeToken.get(ClickEvent.Action.class), ClickEvent.Action.NAMES)).registerExact(new IndexSerializer(new TypeToken<HoverEvent.Action<?>>(){}, HoverEvent.Action.NAMES)).registerExact(new IndexSerializer(TypeToken.get(Sound.Source.class), Sound.Source.NAMES)).registerExact(new IndexSerializer(TypeToken.get(TextDecoration.class), TextDecoration.NAMES)).registerExact(HoverEvent.ShowEntity.class, (TypeSerializer)HoverEventShowEntitySerializer.INSTANCE).registerExact(HoverEvent.ShowItem.class, (TypeSerializer)HoverEventShowItemSerializer.INSTANCE).register(ConfigurateDataComponentValue.class, ConfigurateDataComponentValueTypeSerializer.INSTANCE).register(ShadowColor.class, ShadowColorSerializer.INSTACE).register(PlayerHeadObjectContents.ProfileProperty.class, ProfilePropertySerializer.INSTANCE).build();
    }

    @Override
    @NotNull
    public TypeSerializerCollection serializers() {
        return this.serializers;
    }

    static class Builder
    implements ConfigurateComponentSerializer.Builder {
        @Nullable
        private ComponentSerializer<Component, ?, String> stringSerializer;
        private boolean outputStringComponents = false;

        Builder() {
        }

        @Override
        public @NotNull ConfigurateComponentSerializer.Builder scalarSerializer(@NotNull ComponentSerializer<Component, ?, String> stringSerializer) {
            this.stringSerializer = Objects.requireNonNull(stringSerializer, "stringSerializer");
            return this;
        }

        @Override
        public @NotNull ConfigurateComponentSerializer.Builder outputStringComponents(boolean stringComponents) {
            this.outputStringComponents = stringComponents;
            return this;
        }

        @Override
        @NotNull
        public ConfigurateComponentSerializer build() {
            return new ConfigurateComponentSerializerImpl(this);
        }
    }
}

