/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.serializer.configurate4.ConfigurateDataComponentValue;
import net.kyori.adventure.text.event.HoverEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class HoverEventShowItemSerializer
implements TypeSerializer<HoverEvent.ShowItem> {
    static final HoverEventShowItemSerializer INSTANCE = new HoverEventShowItemSerializer();
    private static final TypeToken<Map<Key, ConfigurateDataComponentValue>> COMPONENT_MAP_TYPE = new TypeToken<Map<Key, ConfigurateDataComponentValue>>(){};

    private HoverEventShowItemSerializer() {
    }

    public HoverEvent.ShowItem deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        Key id = (Key)value.node(new Object[]{"id"}).get(Key.class);
        if (id == null) {
            throw new SerializationException("An id is required to deserialize the show_item hover event");
        }
        int count = value.node(new Object[]{"count"}).getInt(1);
        ConfigurationNode components = value.node(new Object[]{"components"});
        if (!components.virtual()) {
            Map componentsMap = (Map)components.require(COMPONENT_MAP_TYPE);
            return HoverEvent.ShowItem.showItem((Keyed)id, (int)count, new HashMap(componentsMap));
        }
        String tag = value.node(new Object[]{"tag"}).getString();
        return HoverEvent.ShowItem.showItem((Key)id, (int)count, (BinaryTagHolder)(tag == null ? null : BinaryTagHolder.binaryTagHolder((String)tag)));
    }

    public void serialize(@NotNull Type type, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HoverEvent.ShowItem obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(new Object[]{"id"}).set(Key.class, (Object)obj.item());
        value.node(new Object[]{"count"}).set((Object)obj.count());
        if (!obj.dataComponents().isEmpty()) {
            value.node(new Object[]{"tag"}).set(null);
            value.node(new Object[]{"components"}).set(COMPONENT_MAP_TYPE, (Object)obj.dataComponentsAs(ConfigurateDataComponentValue.class));
        } else if (obj.nbt() != null) {
            value.node(new Object[]{"components"}).set(null);
            value.node(new Object[]{"tag"}).set((Object)obj.nbt().string());
        } else {
            value.node(new Object[]{"components"}).set(null);
        }
    }
}

