/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.OptionalLong;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class SoundSerializer
implements TypeSerializer<Sound> {
    static final SoundSerializer INSTANCE = new SoundSerializer();
    static final String NAME = "name";
    static final String SOURCE = "source";
    static final String PITCH = "pitch";
    static final String VOLUME = "volume";
    static final String SEED = "seed";

    private SoundSerializer() {
    }

    @Nullable
    public Sound deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        if (value.empty()) {
            return null;
        }
        Sound.Builder builder = Sound.sound();
        Key name = (Key)value.node(new Object[]{NAME}).get(Key.class);
        Sound.Source source = (Sound.Source)value.node(new Object[]{SOURCE}).get(Sound.Source.class);
        if (name == null || source == null) {
            throw new SerializationException("A name and source are required to deserialize a Sound");
        }
        builder.type(name).source(source).volume(value.node(new Object[]{VOLUME}).getFloat(1.0f)).pitch(value.node(new Object[]{PITCH}).getFloat(1.0f));
        ConfigurationNode seed = value.node(new Object[]{SEED});
        if (!seed.virtual()) {
            builder.seed(OptionalLong.of(seed.getLong()));
        }
        return (Sound)builder.build();
    }

    public void serialize(@NotNull Type type, @Nullable Sound obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(new Object[]{NAME}).set(Key.class, (Object)obj.name());
        value.node(new Object[]{SOURCE}).set(Sound.Source.class, (Object)obj.source());
        value.node(new Object[]{VOLUME}).set((Object)Float.valueOf(obj.volume()));
        value.node(new Object[]{PITCH}).set((Object)Float.valueOf(obj.pitch()));
        if (obj.seed().isPresent()) {
            value.node(new Object[]{SEED}).set((Object)obj.seed().getAsLong());
        } else {
            value.node(new Object[]{SEED}).set(null);
        }
    }
}

