/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

final class TextColorSerializer
extends ScalarSerializer<TextColor> {
    static final TextColorSerializer INSTANCE = new TextColorSerializer();

    private TextColorSerializer() {
        super(TextColor.class);
    }

    public TextColor deserialize(@NotNull Type type, @NotNull Object obj) throws SerializationException {
        if (obj instanceof Number) {
            return TextColor.color((int)((Number)obj).intValue());
        }
        if (!(obj instanceof CharSequence)) {
            throw new SerializationException("Text colors must either be strings or integers");
        }
        String value = obj.toString();
        TextColor result = value.startsWith("#") ? TextColor.fromHexString((String)value) : (TextColor)NamedTextColor.NAMES.value((Object)value);
        if (result == null) {
            throw new SerializationException("Could not convert '" + value + "' into a TextColor");
        }
        return result;
    }

    public Object serialize(@NotNull TextColor item, @NotNull Predicate<Class<?>> typeSupported) {
        if (item instanceof NamedTextColor) {
            return NamedTextColor.NAMES.key((Object)((NamedTextColor)item));
        }
        return item.asHexString();
    }
}

