/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.bungeecord;

import com.google.gson.Gson;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.bungeecord.GsonInjections;
import net.kyori.adventure.text.serializer.bungeecord.SelfSerializable;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BungeeCordComponentSerializer
implements ComponentSerializer<Component, Component, BaseComponent[]> {
    private static boolean SUPPORTED = true;
    private static final BungeeCordComponentSerializer MODERN;
    private static final BungeeCordComponentSerializer PRE_1_16;
    private final GsonComponentSerializer serializer;
    private final LegacyComponentSerializer legacySerializer;

    public static boolean nativeSupport() {
        return SUPPORTED;
    }

    public static BungeeCordComponentSerializer get() {
        return MODERN;
    }

    public static BungeeCordComponentSerializer legacy() {
        return PRE_1_16;
    }

    public static BungeeCordComponentSerializer of(GsonComponentSerializer serializer, LegacyComponentSerializer legacySerializer) {
        return new BungeeCordComponentSerializer(Objects.requireNonNull(serializer, "serializer"), Objects.requireNonNull(legacySerializer, "legacySerializer"));
    }

    public static boolean inject(Gson existing) {
        boolean result = GsonInjections.injectGson(Objects.requireNonNull(existing, "existing"), builder -> {
            GsonComponentSerializer.gson().populator().apply(builder);
            builder.registerTypeAdapterFactory((TypeAdapterFactory)new SelfSerializable.AdapterFactory());
        });
        SUPPORTED &= result;
        return result;
    }

    private BungeeCordComponentSerializer(GsonComponentSerializer serializer, LegacyComponentSerializer legacySerializer) {
        this.serializer = serializer;
        this.legacySerializer = legacySerializer;
    }

    private static void bind() {
        try {
            Field gsonField = GsonInjections.field(net.md_5.bungee.chat.ComponentSerializer.class, "gson");
            BungeeCordComponentSerializer.inject((Gson)gsonField.get(null));
        }
        catch (Exception ignore) {
            SUPPORTED = false;
        }
    }

    public @NonNull Component deserialize(@NonNull BaseComponent @NonNull [] input) {
        Objects.requireNonNull(input, "input");
        if (input.length == 1 && input[0] instanceof AdapterComponent) {
            return ((AdapterComponent)input[0]).component;
        }
        return this.serializer.deserialize((Object)net.md_5.bungee.chat.ComponentSerializer.toString((BaseComponent[])input));
    }

    public @NonNull BaseComponent @NonNull [] serialize(@NonNull Component component) {
        Objects.requireNonNull(component, "component");
        if (SUPPORTED) {
            return new BaseComponent[]{new AdapterComponent(component)};
        }
        return net.md_5.bungee.chat.ComponentSerializer.parse((String)((String)this.serializer.serialize(component)));
    }

    static {
        BungeeCordComponentSerializer.bind();
        MODERN = new BungeeCordComponentSerializer(GsonComponentSerializer.gson(), LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build());
        PRE_1_16 = new BungeeCordComponentSerializer(GsonComponentSerializer.builder().downsampleColors().emitLegacyHoverEvent().build(), LegacyComponentSerializer.legacy());
    }

    class AdapterComponent
    extends BaseComponent
    implements SelfSerializable {
        private final Component component;
        private volatile String legacy;

        AdapterComponent(Component component) {
            this.component = component;
        }

        public String toLegacyText() {
            if (this.legacy == null) {
                this.legacy = BungeeCordComponentSerializer.this.legacySerializer.serialize(this.component);
            }
            return this.legacy;
        }

        public @NonNull BaseComponent duplicate() {
            return this;
        }

        @Override
        public void write(JsonWriter out) throws IOException {
            BungeeCordComponentSerializer.this.serializer.serializer().getAdapter(Component.class).write(out, (Object)this.component);
        }
    }
}

