/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.Style;

final class ComponentSerializerImpl
implements JsonDeserializer<Component>,
JsonSerializer<Component> {
    static final String TEXT = "text";
    static final String TRANSLATE = "translate";
    static final String TRANSLATE_WITH = "with";
    static final String SCORE = "score";
    static final String SCORE_NAME = "name";
    static final String SCORE_OBJECTIVE = "objective";
    static final String SCORE_VALUE = "value";
    static final String SELECTOR = "selector";
    static final String KEYBIND = "keybind";
    static final String EXTRA = "extra";
    static final String NBT = "nbt";
    static final String NBT_INTERPRET = "interpret";
    static final String NBT_BLOCK = "block";
    static final String NBT_ENTITY = "entity";
    static final String NBT_STORAGE = "storage";

    ComponentSerializerImpl() {
    }

    public Component deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.deserialize0(json, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BuildableComponent<?, ?> deserialize0(JsonElement element, JsonDeserializationContext context) throws JsonParseException {
        Style style;
        TextComponent.Builder component;
        if (element.isJsonPrimitive()) {
            return Component.text((String)element.getAsString());
        }
        if (element.isJsonArray()) {
            ComponentBuilder parent = null;
            for (JsonElement childElement : element.getAsJsonArray()) {
                BuildableComponent<?, ?> child = this.deserialize0(childElement, context);
                if (parent == null) {
                    parent = child.toBuilder();
                    continue;
                }
                parent.append(child);
            }
            if (parent != null) return parent.build();
            throw ComponentSerializerImpl.notSureHowToDeserialize(element);
        }
        if (!element.isJsonObject()) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(element);
        }
        JsonObject object = element.getAsJsonObject();
        if (object.has(TEXT)) {
            component = Component.text().content(object.get(TEXT).getAsString());
        } else if (object.has(TRANSLATE)) {
            String key = object.get(TRANSLATE).getAsString();
            if (!object.has(TRANSLATE_WITH)) {
                component = Component.translatable().key(key);
            } else {
                JsonArray with = object.getAsJsonArray(TRANSLATE_WITH);
                ArrayList args = new ArrayList(with.size());
                int size = with.size();
                for (int i = 0; i < size; ++i) {
                    JsonElement argElement = with.get(i);
                    args.add(this.deserialize0(argElement, context));
                }
                component = Component.translatable().key(key).args(args);
            }
        } else if (object.has(SCORE)) {
            JsonObject score = object.getAsJsonObject(SCORE);
            if (!score.has(SCORE_NAME) || !score.has(SCORE_OBJECTIVE)) {
                throw new JsonParseException("A score component requires a name and objective");
            }
            ScoreComponent.Builder builder = Component.score().name(score.get(SCORE_NAME).getAsString()).objective(score.get(SCORE_OBJECTIVE).getAsString());
            component = score.has(SCORE_VALUE) ? builder.value(score.get(SCORE_VALUE).getAsString()) : builder;
        } else if (object.has(SELECTOR)) {
            component = Component.selector().pattern(object.get(SELECTOR).getAsString());
        } else if (object.has(KEYBIND)) {
            component = Component.keybind().keybind(object.get(KEYBIND).getAsString());
        } else {
            boolean interpret;
            if (!object.has(NBT)) throw ComponentSerializerImpl.notSureHowToDeserialize(element);
            String nbt = object.get(NBT).getAsString();
            boolean bl = interpret = object.has(NBT_INTERPRET) && object.getAsJsonPrimitive(NBT_INTERPRET).getAsBoolean();
            if (object.has(NBT_BLOCK)) {
                BlockNBTComponent.Pos pos = (BlockNBTComponent.Pos)context.deserialize(object.get(NBT_BLOCK), BlockNBTComponent.Pos.class);
                component = ComponentSerializerImpl.nbt(Component.blockNBT(), nbt, interpret).pos(pos);
            } else if (object.has(NBT_ENTITY)) {
                component = ComponentSerializerImpl.nbt(Component.entityNBT(), nbt, interpret).selector(object.get(NBT_ENTITY).getAsString());
            } else {
                if (!object.has(NBT_STORAGE)) throw ComponentSerializerImpl.notSureHowToDeserialize(element);
                component = ComponentSerializerImpl.nbt(Component.storageNBT(), nbt, interpret).storage((Key)context.deserialize(object.get(NBT_STORAGE), Key.class));
            }
        }
        if (object.has(EXTRA)) {
            JsonArray extra = object.getAsJsonArray(EXTRA);
            int size = extra.size();
            for (int i = 0; i < size; ++i) {
                JsonElement extraElement = extra.get(i);
                component.append(this.deserialize0(extraElement, context));
            }
        }
        if ((style = (Style)context.deserialize(element, Style.class)).isEmpty()) return component.build();
        component.style(style);
        return component.build();
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, String nbt, boolean interpret) {
        return (B)builder.nbtPath(nbt).interpret(interpret);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonElement serialize(Component src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement style;
        JsonObject object = new JsonObject();
        if (src instanceof TextComponent) {
            object.addProperty(TEXT, ((TextComponent)src).content());
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            object.addProperty(TRANSLATE, tc.key());
            if (!tc.args().isEmpty()) {
                JsonArray with = new JsonArray();
                for (Component arg : tc.args()) {
                    with.add(context.serialize((Object)arg));
                }
                object.add(TRANSLATE_WITH, (JsonElement)with);
            }
        } else if (src instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)src;
            JsonObject score = new JsonObject();
            score.addProperty(SCORE_NAME, sc.name());
            score.addProperty(SCORE_OBJECTIVE, sc.objective());
            String value = sc.value();
            if (value != null) {
                score.addProperty(SCORE_VALUE, value);
            }
            object.add(SCORE, (JsonElement)score);
        } else if (src instanceof SelectorComponent) {
            object.addProperty(SELECTOR, ((SelectorComponent)src).pattern());
        } else if (src instanceof KeybindComponent) {
            object.addProperty(KEYBIND, ((KeybindComponent)src).keybind());
        } else {
            if (!(src instanceof NBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(src);
            NBTComponent nc = (NBTComponent)src;
            object.addProperty(NBT, nc.nbtPath());
            object.addProperty(NBT_INTERPRET, Boolean.valueOf(nc.interpret()));
            if (src instanceof BlockNBTComponent) {
                JsonElement position = context.serialize((Object)((BlockNBTComponent)nc).pos());
                object.add(NBT_BLOCK, position);
            } else if (src instanceof EntityNBTComponent) {
                object.addProperty(NBT_ENTITY, ((EntityNBTComponent)nc).selector());
            } else {
                if (!(src instanceof StorageNBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(src);
                object.add(NBT_STORAGE, context.serialize((Object)((StorageNBTComponent)nc).storage()));
            }
        }
        List children = src.children();
        if (!children.isEmpty()) {
            JsonArray extra = new JsonArray();
            for (Component child : children) {
                extra.add(context.serialize((Object)child));
            }
            object.add(EXTRA, (JsonElement)extra);
        }
        if (!src.hasStyling() || !(style = context.serialize((Object)src.style())).isJsonObject()) return object;
        for (Map.Entry entry : ((JsonObject)style).entrySet()) {
            object.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return object;
    }

    static JsonParseException notSureHowToDeserialize(Object element) {
        return new JsonParseException("Don't know how to turn " + element + " into a Component");
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
    }
}

