/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.chat;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.md_5.bungee.chat.ComponentSerializer;
import org.jetbrains.annotations.ApiStatus;

public final class HoverEvent {
    private final Action action;
    private final List<Content> contents;
    @ApiStatus.Internal
    private boolean legacy = false;
    @ApiStatus.Internal
    private boolean v1_21_5 = false;

    @ApiStatus.Internal
    public void setV1_21_5(boolean v1_21_5) {
        this.v1_21_5 = v1_21_5;
        for (Content content : this.contents) {
            if (!(content instanceof Entity)) continue;
            ((Entity)content).setV1_21_5(v1_21_5);
        }
    }

    public HoverEvent(Action action, Content ... contents) {
        Preconditions.checkArgument((contents.length != 0 ? 1 : 0) != 0, (Object)"Must contain at least one content");
        this.action = action;
        this.contents = new ArrayList<Content>();
        for (Content it : contents) {
            this.addContent(it);
        }
    }

    @Deprecated
    public HoverEvent(Action action, BaseComponent[] value) {
        this.action = action;
        this.contents = new ArrayList<Text>(Collections.singletonList(new Text(value)));
        this.legacy = true;
    }

    @Deprecated
    public BaseComponent[] getValue() {
        Content content = this.contents.get(0);
        if (content instanceof Text && ((Text)content).getValue() instanceof BaseComponent[]) {
            return (BaseComponent[])((Text)content).getValue();
        }
        TextComponent component = new TextComponent(ComponentSerializer.toString(content));
        return new BaseComponent[]{component};
    }

    public void addContent(Content content) throws UnsupportedOperationException {
        Preconditions.checkArgument((!this.legacy || this.contents.size() == 0 ? 1 : 0) != 0, (Object)"Legacy HoverEvent may not have more than one content");
        content.assertAction(this.action);
        this.contents.add(content);
    }

    public static Class<?> getClass(Action action, boolean array) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"action");
        switch (action.ordinal()) {
            case 0: {
                return array ? Text[].class : Text.class;
            }
            case 2: {
                return array ? Entity[].class : Entity.class;
            }
            case 1: {
                return array ? Item[].class : Item.class;
            }
        }
        throw new UnsupportedOperationException("Action '" + action.name() + " not supported");
    }

    @Generated
    public Action getAction() {
        return this.action;
    }

    @Generated
    public List<Content> getContents() {
        return this.contents;
    }

    @Generated
    public boolean isLegacy() {
        return this.legacy;
    }

    @Generated
    public boolean isV1_21_5() {
        return this.v1_21_5;
    }

    @Generated
    public String toString() {
        return "HoverEvent(action=" + (Object)((Object)this.getAction()) + ", contents=" + this.getContents() + ", legacy=" + this.isLegacy() + ", v1_21_5=" + this.isV1_21_5() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HoverEvent)) {
            return false;
        }
        HoverEvent other = (HoverEvent)o;
        if (this.isLegacy() != other.isLegacy()) {
            return false;
        }
        if (this.isV1_21_5() != other.isV1_21_5()) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        List<Content> this$contents = this.getContents();
        List<Content> other$contents = other.getContents();
        return !(this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLegacy() ? 79 : 97);
        result = result * 59 + (this.isV1_21_5() ? 79 : 97);
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        List<Content> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        return result;
    }

    @Generated
    public HoverEvent(Action action, List<Content> contents) {
        this.action = action;
        this.contents = contents;
    }

    @Generated
    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public static enum Action {
        SHOW_TEXT,
        SHOW_ITEM,
        SHOW_ENTITY,
        SHOW_ACHIEVEMENT;

    }
}

