/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog.input;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.dialog.input.DialogInput;
import net.md_5.bungee.api.dialog.input.InputOption;

public class SingleOptionInput
extends DialogInput {
    private Integer width;
    @NonNull
    private BaseComponent label;
    @SerializedName(value="label_visible")
    private Boolean labelVisible;
    @NonNull
    private List<InputOption> options;

    public SingleOptionInput(@NonNull String key, @NonNull BaseComponent label, InputOption ... options) {
        this(key, null, label, null, Arrays.asList(options));
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    public SingleOptionInput(@NonNull String key, Integer width, @NonNull BaseComponent label, Boolean labelVisible, @NonNull List<InputOption> options) {
        super("minecraft:single_option", key);
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        Preconditions.checkArgument((!options.isEmpty() ? 1 : 0) != 0, (Object)"At least one option must be provided");
        this.width(width);
        this.label = label;
        this.labelVisible = labelVisible;
        this.options = options;
    }

    public SingleOptionInput width(Integer width) {
        Preconditions.checkArgument((width == null || width >= 1 && width <= 1024 ? 1 : 0) != 0, (Object)"width must be between 1 and 1024");
        this.width = width;
        return this;
    }

    @Generated
    public Integer width() {
        return this.width;
    }

    @NonNull
    @Generated
    public BaseComponent label() {
        return this.label;
    }

    @Generated
    public Boolean labelVisible() {
        return this.labelVisible;
    }

    @NonNull
    @Generated
    public List<InputOption> options() {
        return this.options;
    }

    @Generated
    public SingleOptionInput label(@NonNull BaseComponent label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    @Generated
    public SingleOptionInput labelVisible(Boolean labelVisible) {
        this.labelVisible = labelVisible;
        return this;
    }

    @Generated
    public SingleOptionInput options(@NonNull List<InputOption> options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.options = options;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "SingleOptionInput(super=" + super.toString() + ", width=" + this.width() + ", label=" + this.label() + ", labelVisible=" + this.labelVisible() + ", options=" + this.options() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleOptionInput)) {
            return false;
        }
        SingleOptionInput other = (SingleOptionInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$width = this.width();
        Integer other$width = other.width();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Boolean this$labelVisible = this.labelVisible();
        Boolean other$labelVisible = other.labelVisible();
        if (this$labelVisible == null ? other$labelVisible != null : !((Object)this$labelVisible).equals(other$labelVisible)) {
            return false;
        }
        BaseComponent this$label = this.label();
        BaseComponent other$label = other.label();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        List<InputOption> this$options = this.options();
        List<InputOption> other$options = other.options();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SingleOptionInput;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $width = this.width();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Boolean $labelVisible = this.labelVisible();
        result = result * 59 + ($labelVisible == null ? 43 : ((Object)$labelVisible).hashCode());
        BaseComponent $label = this.label();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        List<InputOption> $options = this.options();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }
}

