/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.ProtocolConstants;

public abstract class DefinedPacket {
    public static void writeString(String s, ByteBuf buf) {
        Preconditions.checkArgument((s.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot send string longer than Short.MAX_VALUE (got %s characters)", (Object[])new Object[]{s.length()});
        byte[] b = s.getBytes(Charsets.UTF_8);
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static String readString(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        Preconditions.checkArgument((len <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot receive string longer than Short.MAX_VALUE (got %s characters)", (Object[])new Object[]{len});
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, Charsets.UTF_8);
    }

    public static void writeArrayLegacy(byte[] b, ByteBuf buf) {
        Preconditions.checkArgument((b.length <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot send array longer than Short.MAX_VALUE (got %s bytes)", (Object[])new Object[]{b.length});
        buf.writeShort(b.length);
        buf.writeBytes(b);
    }

    public static byte[] readArrayLegacy(ByteBuf buf) {
        short len = buf.readShort();
        Preconditions.checkArgument((len <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot receive array longer than Short.MAX_VALUE (got %s bytes)", (Object[])new Object[]{len});
        byte[] ret = new byte[len];
        buf.readBytes(ret);
        return ret;
    }

    public static void writeArray(byte[] b, ByteBuf buf) {
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static byte[] readArray(ByteBuf buf) {
        byte[] ret = new byte[DefinedPacket.readVarInt(buf)];
        buf.readBytes(ret);
        return ret;
    }

    public static void writeStringArray(String[] s, ByteBuf buf) {
        DefinedPacket.writeVarInt(s.length, buf);
        for (String str : s) {
            DefinedPacket.writeString(str, buf);
        }
    }

    public static String[] readStringArray(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        String[] ret = new String[len];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = DefinedPacket.readString(buf);
        }
        return ret;
    }

    public static int readVarInt(ByteBuf input) {
        byte in;
        int out = 0;
        int bytes = 0;
        do {
            in = input.readByte();
            out |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarInt(int value, ByteBuf output) {
        do {
            int part = value & 0x7F;
            if ((value >>>= 7) != 0) {
                part |= 0x80;
            }
            output.writeByte(part);
        } while (value != 0);
    }

    public static void writeUUID(UUID value, ByteBuf output) {
        output.writeLong(value.getMostSignificantBits());
        output.writeLong(value.getLeastSignificantBits());
    }

    public static UUID readUUID(ByteBuf input) {
        return new UUID(input.readLong(), input.readLong());
    }

    public void read(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement read method");
    }

    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.read(buf);
    }

    public void write(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement write method");
    }

    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.write(buf);
    }

    public abstract void handle(AbstractPacketHandler var1) throws Exception;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

