/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ClientSettings
extends DefinedPacket {
    private String locale;
    private byte viewDistance;
    private byte chatFlags;
    private boolean chatColours;
    private byte difficulty;
    private byte skinParts;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.locale = ClientSettings.readString(buf);
        this.viewDistance = buf.readByte();
        this.chatFlags = buf.readByte();
        this.chatColours = buf.readBoolean();
        if (protocolVersion <= 5) {
            this.difficulty = buf.readByte();
        }
        this.skinParts = buf.readByte();
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ClientSettings.writeString(this.locale, buf);
        buf.writeByte((int)this.viewDistance);
        buf.writeByte((int)this.chatFlags);
        buf.writeBoolean(this.chatColours);
        if (protocolVersion <= 5) {
            buf.writeByte((int)this.difficulty);
        }
        buf.writeByte((int)this.skinParts);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getLocale() {
        return this.locale;
    }

    public byte getViewDistance() {
        return this.viewDistance;
    }

    public byte getChatFlags() {
        return this.chatFlags;
    }

    public boolean isChatColours() {
        return this.chatColours;
    }

    public byte getDifficulty() {
        return this.difficulty;
    }

    public byte getSkinParts() {
        return this.skinParts;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setViewDistance(byte viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setChatFlags(byte chatFlags) {
        this.chatFlags = chatFlags;
    }

    public void setChatColours(boolean chatColours) {
        this.chatColours = chatColours;
    }

    public void setDifficulty(byte difficulty) {
        this.difficulty = difficulty;
    }

    public void setSkinParts(byte skinParts) {
        this.skinParts = skinParts;
    }

    @Override
    public String toString() {
        return "ClientSettings(locale=" + this.getLocale() + ", viewDistance=" + this.getViewDistance() + ", chatFlags=" + this.getChatFlags() + ", chatColours=" + this.isChatColours() + ", difficulty=" + this.getDifficulty() + ", skinParts=" + this.getSkinParts() + ")";
    }

    public ClientSettings() {
    }

    @ConstructorProperties(value={"locale", "viewDistance", "chatFlags", "chatColours", "difficulty", "skinParts"})
    public ClientSettings(String locale, byte viewDistance, byte chatFlags, boolean chatColours, byte difficulty, byte skinParts) {
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatFlags = chatFlags;
        this.chatColours = chatColours;
        this.difficulty = difficulty;
        this.skinParts = skinParts;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientSettings)) {
            return false;
        }
        ClientSettings other = (ClientSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.getChatFlags() != other.getChatFlags()) {
            return false;
        }
        if (this.isChatColours() != other.isChatColours()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        return this.getSkinParts() == other.getSkinParts();
    }

    public boolean canEqual(Object other) {
        return other instanceof ClientSettings;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 0 : $locale.hashCode());
        result = result * 59 + this.getViewDistance();
        result = result * 59 + this.getChatFlags();
        result = result * 59 + (this.isChatColours() ? 79 : 97);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getSkinParts();
        return result;
    }
}

