/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class Login
extends DefinedPacket {
    private int entityId;
    private short gameMode;
    private int dimension;
    private short difficulty;
    private short maxPlayers;
    private String levelType;
    private boolean reducedDebugInfo;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.entityId = buf.readInt();
        this.gameMode = buf.readUnsignedByte();
        this.dimension = buf.readByte();
        this.difficulty = buf.readUnsignedByte();
        this.maxPlayers = buf.readUnsignedByte();
        this.levelType = Login.readString(buf);
        if (protocolVersion >= 29) {
            this.reducedDebugInfo = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        buf.writeInt(this.entityId);
        buf.writeByte((int)this.gameMode);
        buf.writeByte(this.dimension);
        buf.writeByte((int)this.difficulty);
        buf.writeByte((int)this.maxPlayers);
        Login.writeString(this.levelType, buf);
        if (protocolVersion >= 29) {
            buf.writeBoolean(this.reducedDebugInfo);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public short getGameMode() {
        return this.gameMode;
    }

    public int getDimension() {
        return this.dimension;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public short getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setGameMode(short gameMode) {
        this.gameMode = gameMode;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public void setMaxPlayers(short maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    @Override
    public String toString() {
        return "Login(entityId=" + this.getEntityId() + ", gameMode=" + this.getGameMode() + ", dimension=" + this.getDimension() + ", difficulty=" + this.getDifficulty() + ", maxPlayers=" + this.getMaxPlayers() + ", levelType=" + this.getLevelType() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ")";
    }

    public Login() {
    }

    @ConstructorProperties(value={"entityId", "gameMode", "dimension", "difficulty", "maxPlayers", "levelType", "reducedDebugInfo"})
    public Login(int entityId, short gameMode, int dimension, short difficulty, short maxPlayers, String levelType, boolean reducedDebugInfo) {
        this.entityId = entityId;
        this.gameMode = gameMode;
        this.dimension = dimension;
        this.difficulty = difficulty;
        this.maxPlayers = maxPlayers;
        this.levelType = levelType;
        this.reducedDebugInfo = reducedDebugInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Login)) {
            return false;
        }
        Login other = (Login)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getGameMode() != other.getGameMode()) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) {
            return false;
        }
        return this.isReducedDebugInfo() == other.isReducedDebugInfo();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Login;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getGameMode();
        result = result * 59 + this.getDimension();
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getMaxPlayers();
        String $levelType = this.getLevelType();
        result = result * 59 + ($levelType == null ? 0 : $levelType.hashCode());
        result = result * 59 + (this.isReducedDebugInfo() ? 79 : 97);
        return result;
    }
}

