/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.api.NoLoanPermittedException;
import com.earth2me.essentials.api.UserDoesNotExistException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_Essentials
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "Essentials Economy";
    private Plugin plugin = null;
    private Essentials ess = null;

    public Economy_Essentials(Plugin plugin) {
        Plugin essentials;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.ess == null && (essentials = plugin.getServer().getPluginManager().getPlugin("Essentials")) != null && essentials.isEnabled()) {
            this.ess = (Essentials)essentials;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "Essentials Economy"));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.ess == null) {
            return false;
        }
        return this.ess.isEnabled();
    }

    @Override
    public String getName() {
        return "Essentials Economy";
    }

    @Override
    public double getBalance(String playerName) {
        double balance;
        try {
            balance = com.earth2me.essentials.api.Economy.getMoney((String)playerName);
        }
        catch (UserDoesNotExistException e) {
            this.createPlayerAccount(playerName);
            balance = 0.0;
        }
        return balance;
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (this.hasAccount(playerName)) {
            return false;
        }
        return com.earth2me.essentials.api.Economy.createNPC((String)playerName);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        EconomyResponse.ResponseType type;
        double balance;
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        String errorMessage = null;
        try {
            com.earth2me.essentials.api.Economy.subtract((String)playerName, (double)amount);
            balance = com.earth2me.essentials.api.Economy.getMoney((String)playerName);
            type = EconomyResponse.ResponseType.SUCCESS;
        }
        catch (UserDoesNotExistException e) {
            if (this.createPlayerAccount(playerName)) {
                return this.withdrawPlayer(playerName, amount);
            }
            amount = 0.0;
            balance = 0.0;
            type = EconomyResponse.ResponseType.FAILURE;
            errorMessage = "User does not exist";
        }
        catch (NoLoanPermittedException e) {
            try {
                balance = com.earth2me.essentials.api.Economy.getMoney((String)playerName);
                amount = 0.0;
                type = EconomyResponse.ResponseType.FAILURE;
                errorMessage = "Loan was not permitted";
            }
            catch (UserDoesNotExistException e1) {
                amount = 0.0;
                balance = 0.0;
                type = EconomyResponse.ResponseType.FAILURE;
                errorMessage = "User does not exist";
            }
        }
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        EconomyResponse.ResponseType type;
        double balance;
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        String errorMessage = null;
        try {
            com.earth2me.essentials.api.Economy.add((String)playerName, (double)amount);
            balance = com.earth2me.essentials.api.Economy.getMoney((String)playerName);
            type = EconomyResponse.ResponseType.SUCCESS;
        }
        catch (UserDoesNotExistException e) {
            if (this.createPlayerAccount(playerName)) {
                return this.depositPlayer(playerName, amount);
            }
            amount = 0.0;
            balance = 0.0;
            type = EconomyResponse.ResponseType.FAILURE;
            errorMessage = "User does not exist";
        }
        catch (NoLoanPermittedException e) {
            try {
                balance = com.earth2me.essentials.api.Economy.getMoney((String)playerName);
                amount = 0.0;
                type = EconomyResponse.ResponseType.FAILURE;
                errorMessage = "Loan was not permitted";
            }
            catch (UserDoesNotExistException e1) {
                balance = 0.0;
                amount = 0.0;
                type = EconomyResponse.ResponseType.FAILURE;
                errorMessage = "Loan was not permitted";
            }
        }
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public String format(double amount) {
        return com.earth2me.essentials.api.Economy.format((double)amount);
    }

    @Override
    public String currencyNameSingular() {
        return "";
    }

    @Override
    public String currencyNamePlural() {
        return "";
    }

    @Override
    public boolean has(String playerName, double amount) {
        try {
            return com.earth2me.essentials.api.Economy.hasEnough((String)playerName, (double)amount);
        }
        catch (UserDoesNotExistException e) {
            return false;
        }
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Essentials Eco does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Essentials Eco does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Essentials Eco does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Essentials Eco does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Essentials Eco does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Essentials Eco does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Essentials Eco does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Essentials Eco does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return com.earth2me.essentials.api.Economy.playerExists((String)playerName);
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_Essentials economy = null;

        public EconomyServerListener(Economy_Essentials economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin essentials;
            if (this.economy.ess == null && (essentials = event.getPlugin()).getDescription().getName().equals("Essentials")) {
                this.economy.ess = (Essentials)essentials;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_Essentials.this.plugin.getDescription().getName(), "Essentials Economy"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.ess != null && event.getPlugin().getDescription().getName().equals("Essentials")) {
                this.economy.ess = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_Essentials.this.plugin.getDescription().getName(), "Essentials Economy"));
            }
        }
    }
}

