/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.gestern.gringotts.Account;
import org.gestern.gringotts.AccountHolder;
import org.gestern.gringotts.Configuration;
import org.gestern.gringotts.Gringotts;

public class Economy_Gringotts
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "Gringotts";
    private Plugin plugin = null;
    private Gringotts gringotts = null;

    public Economy_Gringotts(Plugin plugin) {
        Plugin grngts;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.gringotts == null && (grngts = plugin.getServer().getPluginManager().getPlugin("Gringotts")) != null && grngts.isEnabled()) {
            this.gringotts = (Gringotts)grngts;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "Gringotts"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.gringotts != null && this.gringotts.isEnabled();
    }

    @Override
    public String getName() {
        return "Gringotts";
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public int fractionalDigits() {
        return 2;
    }

    @Override
    public String format(double amount) {
        return Double.toString(amount);
    }

    @Override
    public String currencyNamePlural() {
        return Configuration.config.currencyNamePlural;
    }

    @Override
    public String currencyNameSingular() {
        return Configuration.config.currencyNameSingular;
    }

    @Override
    public boolean hasAccount(String playerName) {
        AccountHolder owner = this.gringotts.accountHolderFactory.getAccount(playerName);
        if (owner == null) {
            return false;
        }
        return this.gringotts.accounting.getAccount(owner) != null;
    }

    @Override
    public double getBalance(String playerName) {
        AccountHolder owner = this.gringotts.accountHolderFactory.getAccount(playerName);
        if (owner == null) {
            return 0.0;
        }
        Account account = this.gringotts.accounting.getAccount(owner);
        return account.balance();
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw a negative amount.");
        }
        AccountHolder accountHolder = this.gringotts.accountHolderFactory.getAccount(playerName);
        if (accountHolder == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, playerName + " is not a valid account holder.");
        }
        Account account = this.gringotts.accounting.getAccount(accountHolder);
        if (account.balance() >= amount && account.remove(amount)) {
            return new EconomyResponse(amount, account.balance(), EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, account.balance(), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        AccountHolder accountHolder = this.gringotts.accountHolderFactory.getAccount(playerName);
        if (accountHolder == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, playerName + " is not a valid account holder.");
        }
        Account account = this.gringotts.accounting.getAccount(accountHolder);
        if (account.add(amount)) {
            return new EconomyResponse(amount, account.balance(), EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, account.balance(), EconomyResponse.ResponseType.FAILURE, "Not enough capacity to store that amount!");
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Gringotts does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Gringotts does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Gringotts does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Gringotts does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Gringotts does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Gringotts does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Gringotts does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Gringotts does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return this.hasAccount(playerName);
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_Gringotts economy = null;

        public EconomyServerListener(Economy_Gringotts economy_Gringotts2) {
            this.economy = economy_Gringotts2;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin grngts;
            if (this.economy.gringotts == null && (grngts = event.getPlugin()).getDescription().getName().equals("Gringotts")) {
                this.economy.gringotts = (Gringotts)grngts;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_Gringotts.this.plugin.getDescription().getName(), "Gringotts"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.gringotts != null && event.getPlugin().getDescription().getName().equals("Gringotts")) {
                this.economy.gringotts = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_Gringotts.this.plugin.getDescription().getName(), "Gringotts"));
            }
        }
    }
}

