/*
 * Decompiled with CFR 0.152.
 */
package net.minestatus.minequery;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.ProxyReloadEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.event.EventHandler;
import net.minestatus.minequery.QueryServer;

public final class Minequery
extends Plugin
implements Listener {
    public static final String CONFIG_FILE = "minequery.properties";
    private String serverIP;
    private int port;
    private QueryServer server;
    private String password;
    private boolean logging;
    private Set<String> includedServers;
    private Set<String> hiddenServers;
    private ScheduledTask serverTask;

    public void onEnable() {
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        this.load();
    }

    private void load() {
        try {
            Properties props;
            File dir = this.getDataFolder();
            File file = new File(dir, CONFIG_FILE);
            if (!dir.exists() || !file.exists()) {
                dir.mkdirs();
                this.getLogger().log(Level.INFO, "Generate config");
                props = new Properties();
                props.setProperty("server-ip", "127.0.0.1");
                props.setProperty("minequery-port", "25566");
                props.setProperty("password", "");
                props.setProperty("logging", "true");
                props.setProperty("included-servers", "*");
                props.setProperty("hidden-servers", "hidden1,hidden2");
                FileOutputStream out = new FileOutputStream(file);
                props.store(out, "Minequery settings");
            }
            props = new Properties();
            props.load(new FileReader(file));
            this.serverIP = props.getProperty("server-ip", "ANY");
            this.port = Integer.parseInt(props.getProperty("minequery-port", "25566"));
            this.password = props.getProperty("password", "");
            this.logging = Boolean.parseBoolean(props.getProperty("logging", "true"));
            this.includedServers = new HashSet<String>(Arrays.asList(props.getProperty("included-servers", "*").toLowerCase().split(",")));
            this.hiddenServers = new HashSet<String>(Arrays.asList(props.getProperty("hidden-servers", "").toLowerCase().split(",")));
            if (this.serverIP.equals("")) {
                this.serverIP = "ANY";
            }
            this.server = new QueryServer(this, this.serverIP, this.port);
            this.serverTask = this.getProxy().getScheduler().runAsync((Plugin)this, (Runnable)this.server);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Error initializing Minequery", ex);
        }
    }

    @EventHandler
    public void onReload(ProxyReloadEvent event) {
        this.onDisable();
        this.load();
    }

    public void onDisable() {
        try {
            if (this.server != null) {
                this.server.getListener().close();
            }
            if (this.serverTask != null) {
                this.serverTask.cancel();
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.WARNING, "Unable to close the Minequery listener", ex);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean showPlayersOnServer(ServerInfo server) {
        boolean isIncluded = this.includedServers.isEmpty() || this.includedServers.contains("*") || this.includedServers.contains(server.getName().toLowerCase());
        return isIncluded && !this.hiddenServers.contains(server.getName().toLowerCase());
    }

    public void log(String message) {
        if (this.logging) {
            this.getLogger().log(Level.INFO, message);
        }
    }
}

