/*
 * Decompiled with CFR 0.152.
 */
package net.minestatus.minequery;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.minestatus.minequery.Minequery;
import net.minestatus.minequery.Request;

public final class QueryServer
implements Runnable {
    private final Minequery plugin;
    private final ServerSocket listener;

    public QueryServer(Minequery plugin, String host, int port) throws IOException {
        InetSocketAddress address;
        this.plugin = plugin;
        if (host.equalsIgnoreCase("ANY")) {
            plugin.getLogger().info("Starting server on *:" + Integer.toString(port));
            address = new InetSocketAddress(port);
        } else {
            plugin.getLogger().info("Starting server on " + host + ":" + Integer.toString(port));
            address = new InetSocketAddress(host, port);
        }
        this.listener = new ServerSocket();
        this.listener.bind(address);
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket socket = this.listener.accept();
                new Thread(new Request(this.plugin, socket)).start();
            }
        }
        catch (IOException ex) {
            this.plugin.getLogger().info("Stopping server");
            return;
        }
    }

    public ServerSocket getListener() {
        return this.listener;
    }
}

