/*
 * Decompiled with CFR 0.152.
 */
package net.minestatus.minequery;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.plugin.Event;
import net.minestatus.minequery.Minequery;

public final class Request
extends Thread
implements PendingConnection {
    private final Minequery plugin;
    private final Socket socket;
    private final ListenerInfo info;
    private String disconnected = null;

    public Request(Minequery plugin, Socket socket) {
        this.plugin = plugin;
        this.socket = socket;
        this.info = (ListenerInfo)plugin.getProxy().getConfig().getListeners().iterator().next();
    }

    @Override
    public void run() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.handleRequest(this.socket, reader.readLine());
            this.socket.close();
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Minequery server thread shutting down", ex);
        }
    }

    private void handleRequest(Socket socket, String request) throws IOException {
        if (request == null) {
            return;
        }
        this.plugin.log(this.getAddress() + " - '" + request + "'");
        ProxyPingEvent pingEvent = new ProxyPingEvent((PendingConnection)this, new ServerPing(new ServerPing.Protocol(this.plugin.getDataFolder().getName(), 0), new ServerPing.Players(this.info.getMaxPlayers(), this.plugin.getProxy().getOnlineCount(), new ServerPing.PlayerInfo[0]), this.info.getMotd(), ""), (result, error) -> {});
        this.plugin.getProxy().getPluginManager().callEvent((Event)pingEvent);
        if (this.disconnected != null) {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeBytes(this.disconnected);
            return;
        }
        ArrayList<String> playerList = new ArrayList<String>();
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
            if (player.getServer() == null || !this.plugin.showPlayersOnServer(player.getServer().getInfo())) continue;
            playerList.add(player.getName());
            uuidList.add(player.getUniqueId());
        }
        int onlinePlayers = pingEvent.getResponse().getPlayers().getOnline();
        if (onlinePlayers > playerList.size()) {
            onlinePlayers = playerList.size();
        }
        Response response = new Response(this.info.getHost().getPort(), playerList, uuidList, onlinePlayers, pingEvent.getResponse().getPlayers().getMax());
        if (request.equalsIgnoreCase("QUERY" + this.plugin.getPassword())) {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeBytes(response.toString());
        } else if (request.equalsIgnoreCase("QUERY_JSON" + this.plugin.getPassword())) {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeBytes(response.toJson());
        } else {
            this.plugin.getLogger().log(Level.WARNING, this.getAddress() + " tried to request '" + request + "' which is not supported?");
        }
    }

    public int getVersion() {
        return 0;
    }

    public InetSocketAddress getVirtualHost() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    public ListenerInfo getListener() {
        return this.info;
    }

    public String getUUID() {
        return null;
    }

    public UUID getUniqueId() {
        return null;
    }

    public void setUniqueId(UUID uuid) {
    }

    public boolean isOnlineMode() {
        return this.plugin.getProxy().getConfig().isOnlineMode();
    }

    public void setOnlineMode(boolean onlineMode) {
    }

    public boolean isLegacy() {
        return false;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.socket.getInetAddress(), this.socket.getPort());
    }

    public void disconnect(String reason) {
        this.disconnected = reason;
    }

    public void disconnect(BaseComponent ... reason) {
        this.disconnect(TextComponent.toPlainText((BaseComponent[])reason));
    }

    public void disconnect(BaseComponent reason) {
        this.disconnect(TextComponent.toPlainText((BaseComponent[])new BaseComponent[]{reason}));
    }

    public boolean isConnected() {
        return false;
    }

    public Connection.Unsafe unsafe() {
        return null;
    }

    public class Response {
        private final int serverPort;
        private final List<String> playerList;
        private final List<UUID> uuidList;
        private final int onlineCount;
        private final int maxPlayers;

        public Response(int serverPort, List<String> playerList, List<UUID> uuidList, int onlineCount, int maxPlayers) {
            this.serverPort = serverPort;
            this.playerList = playerList;
            this.uuidList = uuidList;
            this.onlineCount = onlineCount;
            this.maxPlayers = maxPlayers;
        }

        public String toString() {
            return "SERVERPORT " + this.serverPort + "\nPLAYERCOUNT " + this.onlineCount + "\nMAXPLAYERS " + this.maxPlayers + "\nPLAYERLIST " + Arrays.toString(this.playerList.toArray()) + "\nUUIDLIST " + Arrays.toString(this.uuidList.toArray()) + "\n";
        }

        public String toJson() {
            return "{\"serverPort\":" + this.serverPort + ",\"playerCount\":" + this.onlineCount + ",\"maxPlayers\":" + this.maxPlayers + ",\"playerList\":[" + this.playerList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(",")) + "],\"uuidList\":[" + this.uuidList.stream().map(u -> "\"" + u.toString() + "\"").collect(Collectors.joining(",")) + "]}\n";
        }
    }
}

