/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.hook;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.event.FPlayerJoinEvent;
import com.massivecraft.factions.event.FPlayerLeaveEvent;
import com.massivecraft.factions.event.LandClaimEvent;
import com.massivecraft.factions.event.LandUnclaimAllEvent;
import com.massivecraft.factions.event.LandUnclaimEvent;
import com.massivecraft.factions.iface.RelationParticipator;
import com.massivecraft.factions.struct.TerritoryAccess;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.hook.FactionsHook;
import net.novucs.ftop.hook.event.FactionClaimEvent;
import net.novucs.ftop.hook.event.FactionDisbandEvent;
import net.novucs.ftop.hook.event.FactionJoinEvent;
import net.novucs.ftop.hook.event.FactionLeaveEvent;
import net.novucs.ftop.hook.event.FactionRenameEvent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class Factions0108
extends FactionsHook {
    private Map<FLocation, TerritoryAccess> flocationIds;

    public Factions0108(Plugin plugin) {
        super(plugin);
    }

    public void initialize() {
        try {
            Field flocationIdsField = Board.class.getDeclaredField("flocationIds");
            flocationIdsField.setAccessible(true);
            this.flocationIds = (Map)flocationIdsField.get(null);
            flocationIdsField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            this.getPlugin().getLogger().severe("Factions version found is incompatible!");
            this.getPlugin().getServer().getPluginManager().disablePlugin(this.getPlugin());
            return;
        }
        super.initialize();
    }

    public String getFactionAt(String worldName, int chunkX, int chunkZ) {
        Faction faction = Board.getFactionAt((FLocation)new FLocation(worldName, chunkX, chunkZ));
        return faction.getId();
    }

    public String getFaction(Player player) {
        return ((FPlayer)FPlayers.i.get(player)).getFaction().getId();
    }

    public String getFactionName(String factionId) {
        return Factions.i.get(factionId).getTag();
    }

    public boolean isFaction(String factionId) {
        return Factions.i.get(factionId) != null;
    }

    public ChatColor getRelation(Player player, String factionId) {
        FPlayer fplayer = (FPlayer)FPlayers.i.get(player);
        Faction faction = Factions.i.get(factionId);
        return fplayer.getFaction().getRelationTo((RelationParticipator)faction).getColor();
    }

    public String getOwnerName(String factionId) {
        FPlayer owner = Factions.i.get(factionId).getFPlayerLeader();
        return owner == null ? null : owner.getName();
    }

    public List<UUID> getMembers(String factionId) {
        return Factions.i.get(factionId).getFPlayers().stream().map(fplayer -> UUID.fromString(fplayer.getId())).collect(Collectors.toList());
    }

    public List<ChunkPos> getClaims() {
        LinkedList<ChunkPos> target = new LinkedList<ChunkPos>();
        target.addAll(this.getChunkPos(this.flocationIds.keySet()));
        return target;
    }

    public Set<String> getFactionIds() {
        return Factions.i.getMap().keySet();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDisband(com.massivecraft.factions.event.FactionDisbandEvent event) {
        String factionId = event.getFaction().getId();
        String factionName = event.getFaction().getTag();
        this.callEvent((Event)new FactionDisbandEvent(factionId, factionName));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRename(com.massivecraft.factions.event.FactionRenameEvent event) {
        String factionId = event.getFaction().getId();
        String oldName = event.getFPlayer().getFaction().getTag();
        String newName = event.getFactionTag();
        this.callEvent((Event)new FactionRenameEvent(factionId, oldName, newName));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(LandClaimEvent event) {
        Faction faction = Board.getFactionAt((FLocation)event.getLocation());
        HashMultimap claims = HashMultimap.create();
        claims.put((Object)faction.getId(), (Object)this.getChunkPos(event.getLocation()));
        this.callEvent((Event)new FactionClaimEvent(event.getFaction().getId(), (Multimap)claims));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(LandUnclaimEvent event) {
        HashMultimap claims = HashMultimap.create();
        claims.put((Object)event.getFaction().getId(), (Object)this.getChunkPos(event.getLocation()));
        this.callEvent((Event)new FactionClaimEvent(Factions.i.getNone().getId(), (Multimap)claims));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(LandUnclaimAllEvent event) {
        HashMultimap claims = HashMultimap.create();
        this.flocationIds.entrySet().stream().filter(entry -> ((TerritoryAccess)entry.getValue()).getHostFaction() == event.getFaction()).forEach(arg_0 -> this.lambda$onClaim$2((Multimap)claims, event, arg_0));
        this.callEvent((Event)new FactionClaimEvent(Factions.i.getNone().getId(), (Multimap)claims));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(FPlayerJoinEvent event) {
        Player player = event.getFPlayer().getPlayer();
        String factionId = event.getFaction().getId();
        this.callEvent((Event)new FactionJoinEvent(factionId, player));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLeave(FPlayerLeaveEvent event) {
        Player player = event.getFPlayer().getPlayer();
        String factionId = event.getFaction().getId();
        if (player != null) {
            this.callEvent((Event)new FactionLeaveEvent(factionId, player));
        }
    }

    private Set<ChunkPos> getChunkPos(Set<FLocation> locations) {
        return locations.stream().map(this::getChunkPos).collect(Collectors.toSet());
    }

    private ChunkPos getChunkPos(FLocation location) {
        return ChunkPos.of((String)location.getWorldName(), (int)((int)location.getX()), (int)((int)location.getZ()));
    }

    private /* synthetic */ void lambda$onClaim$2(Multimap claims, LandUnclaimAllEvent event, Map.Entry entry) {
        claims.put((Object)event.getFactionId(), (Object)this.getChunkPos((FLocation)entry.getKey()));
    }
}

