/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels;

import com.google.common.collect.ImmutableMap;
import de.themoep.vnpbungee.VNPBungee;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.ChannelTagCommandExecutor;
import net.zaiyers.Channels.command.ChannelsCommandExecutor;
import net.zaiyers.Channels.config.ChannelsConfig;
import net.zaiyers.Channels.config.LanguageConfig;
import net.zaiyers.Channels.integration.BTLPIntegration;
import net.zaiyers.Channels.listener.MessageListener;
import net.zaiyers.Channels.listener.PlayerJoinListener;
import net.zaiyers.Channels.listener.PlayerQuitListener;
import net.zaiyers.Channels.listener.ServerSwitchListener;
import net.zaiyers.UUIDDB.core.UUIDDBPlugin;

public class Channels
extends Plugin {
    private static Channels instance;
    private Map<UUID, Chatter> chatters = new HashMap<UUID, Chatter>();
    private static ChannelsConfig config;
    private static LanguageConfig lang;
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private Map<String, ChannelTagCommandExecutor> tagCommandExecutors = new HashMap<String, ChannelTagCommandExecutor>();
    private static LuckPerms luckPermsApi;
    private static UUIDDBPlugin uuidDb;
    private static VNPBungee vnpBungee;

    public void onEnable() {
        instance = this;
        try {
            config = new ChannelsConfig(new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to load configuration! Channels will not be enabled.");
            e.printStackTrace();
            return;
        }
        try {
            lang = new LanguageConfig(new File(this.getDataFolder(), "lang." + config.getLanguage() + ".yml"));
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to load language! Channels will not be enabled.");
            e.printStackTrace();
            return;
        }
        if (this.getProxy().getPluginManager().getPlugin("VNPBungee") != null) {
            this.getLogger().info("Found VNPBungee!");
            vnpBungee = VNPBungee.getInstance();
        }
        if (this.getProxy().getPluginManager().getPlugin("LuckPerms") != null) {
            this.getLogger().info("Found LuckPerms!");
            luckPermsApi = LuckPermsProvider.get();
        }
        if (this.getProxy().getPluginManager().getPlugin("UUIDDB") != null) {
            this.getLogger().info("Found UUIDDB!");
            uuidDb = (UUIDDBPlugin)this.getProxy().getPluginManager().getPlugin("UUIDDB");
        }
        if (this.getProxy().getPluginManager().getPlugin("BungeeTabListPlus") != null) {
            this.getLogger().info("Found BungeeTabListPlus!");
            try {
                new BTLPIntegration();
            }
            catch (IllegalStateException e) {
                this.getLogger().log(Level.WARNING, "Error while trying to hook into BungeeTabListPlus!", e);
            }
        }
        if (Channels.getUuidDb() == null && Channels.getLuckPermsApi() == null) {
            this.getLogger().severe("You need either LuckPerms or UUIDDB installed for Channels to work! It will not be enabled.");
            return;
        }
        MessageListener ml = new MessageListener();
        PlayerJoinListener pjl = new PlayerJoinListener();
        PlayerQuitListener pql = new PlayerQuitListener();
        ServerSwitchListener swl = new ServerSwitchListener();
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)ml);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)pjl);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)pql);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)swl);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ChannelsCommandExecutor("channel", "ch", "channels"));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ChannelsCommandExecutor("pm", "tell", "msg"));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ChannelsCommandExecutor("reply", "r"));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ChannelsCommandExecutor("afk", new String[0]));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ChannelsCommandExecutor("dnd", new String[0]));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ChannelsCommandExecutor("ignore", new String[0]));
        for (String channelUUID : config.getChannels()) {
            try {
                Channel channel = new Channel(channelUUID);
                this.channels.put(channel.getUUID(), channel);
                this.registerTag(channel.getTag());
            }
            catch (IOException e) {
                this.getLogger().severe("Couldn't load channel " + channelUUID);
                e.printStackTrace();
            }
        }
        this.checkSanity(this.getProxy().getConsole(), null);
    }

    public boolean reloadConfig() {
        try {
            lang.load();
        }
        catch (IOException e) {
            this.getLogger().severe("Error while loading the language config!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void onDisable() {
        for (Channel channel : this.channels.values()) {
            channel.save();
        }
        for (Chatter chatter : this.chatters.values()) {
            chatter.save();
        }
        config.save();
    }

    public static ChannelsConfig getConfig() {
        return config;
    }

    public static Channels getInstance() {
        return instance;
    }

    public void removeChannel(String uuid) {
        Channel chan = this.channels.get(uuid);
        if (chan != null) {
            chan.removeChannel();
        }
        this.channels.remove(uuid);
    }

    public Chatter getChatter(ProxiedPlayer player) {
        Chatter chatter = this.chatters.get(player.getUniqueId());
        if (chatter == null) {
            chatter = this.createChatter(player);
        }
        if (chatter == null) {
            this.getLogger().log(Level.WARNING, "Could not get the chatter for " + player.getName() + "/" + String.valueOf(player.getUniqueId()) + "?");
            return null;
        }
        this.chatters.put(player.getUniqueId(), chatter);
        return chatter;
    }

    public Chatter getChatter(String playerId) {
        return this.getChatter(UUID.fromString(playerId));
    }

    public Chatter getChatter(UUID playerId) {
        Chatter chatter = this.chatters.get(playerId);
        if (chatter != null) {
            return chatter;
        }
        ProxiedPlayer player = this.getProxy().getPlayer(playerId);
        if (player != null) {
            return this.getChatter(player);
        }
        this.getLogger().log(Level.WARNING, "Could not create the chatter? The player with the uuid " + String.valueOf(playerId) + " wasn't found online?");
        return null;
    }

    public Chatter getChatterByName(String name) {
        ProxiedPlayer player = this.getProxy().getPlayer(name);
        if (player != null) {
            return this.getChatter(player);
        }
        name = name.toLowerCase();
        for (Chatter onlinechatter : this.chatters.values()) {
            if (onlinechatter == null || !onlinechatter.getName().toLowerCase().startsWith(name)) continue;
            return onlinechatter;
        }
        return null;
    }

    public void addChannel(Channel channel) {
        this.channels.put(channel.getUUID(), channel);
    }

    public Channel getChannel(String string) {
        if (this.channels.containsKey(string)) {
            return this.channels.get(string);
        }
        for (Channel channel : this.channels.values()) {
            if (!channel.getTag().equalsIgnoreCase(string) && !channel.getName().equalsIgnoreCase(string)) continue;
            return channel;
        }
        return null;
    }

    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    public void removeChatter(UUID playerId) {
        this.chatters.remove(playerId);
    }

    public static String addSpecialChars(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void notify(CommandSender sender, String key, String ... replacements) {
        sender.sendMessage(Channels.getInstance().getLanguage().getTranslationComponent(key, replacements));
    }

    public static void notify(CommandSender sender, String key, Map<String, String> replacements) {
        sender.sendMessage(Channels.getInstance().getLanguage().getTranslationComponent(key, replacements));
    }

    public LanguageConfig getLanguage() {
        return lang;
    }

    public void registerTag(String tag) {
        ChannelTagCommandExecutor executor = new ChannelTagCommandExecutor(tag.toLowerCase());
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)executor);
        this.tagCommandExecutors.put(tag, executor);
    }

    public void unregisterTag(String tag) {
        if (this.tagCommandExecutors.containsKey(tag)) {
            this.getProxy().getPluginManager().unregisterCommand((Command)this.tagCommandExecutors.get(tag));
            this.tagCommandExecutors.remove(tag);
        }
    }

    public Map<UUID, Chatter> getChatters() {
        return this.chatters;
    }

    public void checkSanity(CommandSender sender, String channelId) {
        Channel chan = this.channels.get(channelId);
        Channel def = this.channels.get(config.getDefaultChannelUUID());
        if (chan != null && !chan.isGlobal() && chan.getServers().isEmpty()) {
            Channels.notify(sender, "channels.command.channel-has-no-servers", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
        }
        for (ServerInfo server : this.getProxy().getServers().values()) {
            Channel serverDef = this.channels.get(config.getServerDefaultChannel(server.getName()));
            if (serverDef != null) {
                if (!serverDef.isGlobal() && !serverDef.getServers().contains(server.getName())) {
                    Channels.notify(sender, "channels.command.default-channel-unavailable", (Map<String, String>)ImmutableMap.of((Object)"server", (Object)server.getName()));
                }
                if (serverDef.doAutojoin()) continue;
                Channels.notify(sender, "channels.command.default-channel-no-autojoin", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)serverDef.getName(), (Object)"channelColor", (Object)serverDef.getColor().toString()));
                continue;
            }
            if (def != null && (def.isGlobal() || def.getServers().contains(server.getName()))) continue;
            Channels.notify(sender, "channels.command.default-no-defchannel-available", (Map<String, String>)ImmutableMap.of((Object)"server", (Object)server.getName()));
        }
    }

    public static VNPBungee getVNPBungee() {
        return vnpBungee;
    }

    public static LuckPerms getLuckPermsApi() {
        return luckPermsApi;
    }

    public static UUIDDBPlugin getUuidDb() {
        return uuidDb;
    }

    public static String getPlayerName(String playerId) {
        return Channels.getPlayerName(UUID.fromString(playerId));
    }

    public static String getPlayerName(UUID playerId) {
        User lpUser;
        String playerName = null;
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(playerId);
        if (player != null) {
            playerName = player.getName();
        }
        if (Channels.getUuidDb() != null) {
            playerName = Channels.getUuidDb().getStorage().getNameByUUID(playerId);
        }
        if (playerName == null && Channels.getLuckPermsApi() != null && (lpUser = Channels.getLuckPermsApi().getUserManager().getUser(playerId)) != null) {
            playerName = lpUser.getUsername();
        }
        return playerName != null ? playerName : "Unknown";
    }

    public static UUID getPlayerId(String name) {
        User lpUser;
        String idStr;
        UUID playerId = null;
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(name);
        if (player != null) {
            playerId = player.getUniqueId();
        }
        if (playerId == null && Channels.getUuidDb() != null && (idStr = Channels.getUuidDb().getStorage().getUUIDByName(name, false)) != null) {
            playerId = UUID.fromString(idStr);
        }
        if (playerId == null && Channels.getLuckPermsApi() != null && (lpUser = Channels.getLuckPermsApi().getUserManager().getUser(name)) != null) {
            playerId = lpUser.getUniqueId();
        }
        return playerId;
    }

    private Chatter createChatter(ProxiedPlayer player) {
        try {
            Chatter chatter = new Chatter(player);
            for (String channelUUID : chatter.getSubscriptions()) {
                if (this.getChannel(channelUUID) != null) {
                    if (chatter.hasPermission(this.getChannel(channelUUID), "subscribe")) {
                        this.getChannel(channelUUID).subscribe(chatter);
                        continue;
                    }
                    chatter.unsubscribe(channelUUID);
                    if (!channelUUID.equals(Channels.getConfig().getDefaultChannelUUID())) continue;
                    this.getLogger().warning("Chatter '" + chatter.getName() + "' is not allowed to join the default channel");
                    continue;
                }
                chatter.unsubscribe(channelUUID);
            }
            for (Channel channel : Channels.getInstance().getChannels().values()) {
                if (!channel.doAutojoin() || channel.isTemporary() || !chatter.hasPermission(channel, "subscribe")) continue;
                chatter.subscribe(channel);
            }
            return chatter;
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to create Chatter '" + player.getName() + "'/" + String.valueOf(player.getUniqueId()));
            e.printStackTrace();
            return null;
        }
    }

    static {
        luckPermsApi = null;
        uuidDb = null;
        vnpBungee = null;
    }

    private class ChatterNotFoundException
    extends ExecutionException {
        ChatterNotFoundException(String msg) {
            super(msg);
        }
    }
}

