/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.AbstractCommand;
import net.zaiyers.Channels.lib.minedown.MineDown;

public class ChannelListCommand
extends AbstractCommand {
    public ChannelListCommand(CommandSender sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        boolean isConsoleCommand = !(this.sender instanceof ProxiedPlayer);
        Chatter chatter = null;
        if (!isConsoleCommand) {
            chatter = Channels.getInstance().getChatter(((ProxiedPlayer)this.sender).getUniqueId());
        }
        if (this.args.length == 1 && this.args[0].equalsIgnoreCase("list")) {
            Channels.notify(this.sender, "channels.chatter.available-channels", new String[0]);
            for (Channel channel : Channels.getInstance().getChannels().values()) {
                boolean onThisServer;
                boolean bl = onThisServer = channel.isGlobal() || isConsoleCommand || channel.getServers().contains(chatter.getPlayer().getServer().getInfo().getName());
                if (isConsoleCommand || (chatter.hasPermission(channel, "subscribe") || channel.isTemporary()) && onThisServer) {
                    this.sender.sendMessage(" - " + String.valueOf(channel.getColor()) + channel.getTag() + " - " + channel.getName() + String.valueOf(ChatColor.WHITE) + " (" + (channel.getPassword().isEmpty() ? "public" : "private") + ")");
                    continue;
                }
                if (!chatter.hasPermission(channel, "globalread")) continue;
                this.sender.sendMessage(" - " + String.valueOf(channel.getColor()) + channel.getTag() + " - " + channel.getName() + String.valueOf(ChatColor.WHITE) + " (" + (channel.getPassword().isEmpty() ? "public" : "private") + ") " + String.valueOf(ChatColor.GRAY) + (onThisServer ? "" : " not") + " on this server");
            }
        } else if (this.args.length == 2 || this.args.length == 1 && this.args[0].equalsIgnoreCase("who") && !isConsoleCommand) {
            Channel channel = null;
            if (this.args.length == 2) {
                channel = Channels.getInstance().getChannel(this.args[1]);
            } else if (!isConsoleCommand && chatter.getChannel() != null) {
                channel = Channels.getInstance().getChannel(chatter.getChannel());
            } else {
                Channels.notify(this.sender, "channels.chatter.has-no-channel", new String[0]);
            }
            if (channel == null) {
                Channels.notify(this.sender, "channels.command.channel-not-found", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.args[1]));
                return;
            }
            if (isConsoleCommand || chatter.hasPermission(channel, "list") || channel.isTemporary() && channel.getSubscriberUUIDs().contains(chatter.getPlayer().getUniqueId())) {
                UUID[] uuids = channel.getSubscriberUUIDs().toArray(new UUID[0]);
                Channels.notify(this.sender, "channels.chatter.channel-list-chatters", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)channel.getName(), (Object)"channelColor", (Object)channel.getColor().toString()));
                ArrayList<Chatter> chatters = new ArrayList<Chatter>();
                for (UUID uuid : uuids) {
                    Chatter subscriber = Channels.getInstance().getChatter(uuid);
                    if (subscriber.getPlayer() == null || !subscriber.getPlayer().isConnected() || chatter != null && Channels.getConfig().shouldHideVanished() && Channels.getVNPBungee() != null && !Channels.getVNPBungee().canSee((CommandSender)chatter.getPlayer(), subscriber.getPlayer())) continue;
                    chatters.add(subscriber);
                }
                if (chatters.size() > 0) {
                    ComponentBuilder chatterList = new ComponentBuilder("");
                    for (int i = 0; i < chatters.size(); ++i) {
                        Chatter subscriber = (Chatter)chatters.get(i);
                        if (i > 0) {
                            chatterList.append(", ").color(ChatColor.WHITE);
                        }
                        chatterList.append(MineDown.parse(subscriber.getPrefix(), new String[0])).append(subscriber.getName()).color(ChatColor.WHITE).append(MineDown.parse(subscriber.getSuffix(), new String[0]));
                        if (subscriber.isAFK()) {
                            chatterList.append("(AFK)").color(ChatColor.GRAY);
                            if (subscriber.getAFKMessage() != null) {
                                chatterList.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(TextComponent.fromLegacyText((String)(String.valueOf(ChatColor.GRAY) + "AFK: " + String.valueOf(ChatColor.ITALIC) + subscriber.getAFKMessage())))}));
                            }
                        }
                        if (!subscriber.isDND()) continue;
                        chatterList.append("(DND)").color(ChatColor.GRAY);
                        if (subscriber.getDNDMessage() == null) continue;
                        chatterList.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(TextComponent.fromLegacyText((String)(String.valueOf(ChatColor.GRAY) + "DND: " + String.valueOf(ChatColor.ITALIC) + subscriber.getDNDMessage())))}));
                    }
                    this.sender.sendMessage(chatterList.create());
                }
            } else {
                Channels.notify(this.sender, "channels.permission.list-channel", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)channel.getName(), (Object)"channelColor", (Object)channel.getColor().toString()));
            }
        }
    }

    @Override
    public boolean validateInput() {
        return true;
    }
}

