/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.command.AbstractCommand;
import net.zaiyers.Channels.command.ChannelsCommand;

public class ChannelRenameCommand
extends AbstractCommand
implements ChannelsCommand {
    public ChannelRenameCommand(CommandSender sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        Channel chan = Channels.getInstance().getChannel(this.args[1]);
        if (chan == null) {
            Channels.notify(this.sender, "channels.command.channel-not-found", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.args[1]));
            return;
        }
        if (this.sender instanceof ProxiedPlayer && !chan.isMod(((ProxiedPlayer)this.sender).getUniqueId().toString()) && !this.sender.hasPermission("channels.rename.foreign")) {
            Channels.notify(this.sender, "channels.command.channel-no-permission", new String[0]);
            return;
        }
        if (!this.args[2].matches("^[a-zA-Z0-9_]+$")) {
            Channels.notify(this.sender, "channels.usage.channelname-disallowed-chars", new String[0]);
            return;
        }
        String newName = this.args[2];
        if (!this.args[3].matches("^[a-zA-Z0-9_]+$")) {
            Channels.notify(this.sender, "channels.usage.channeltag-disallowed-chars", new String[0]);
            return;
        }
        String newTag = this.args[3];
        if (Channels.getInstance().getChannel(newTag) != null && !chan.getTag().equalsIgnoreCase(newTag)) {
            Channels.notify(this.sender, "channels.command.channel-tag-in-use", new String[0]);
            return;
        }
        if (Channels.getInstance().getChannel(newName) != null && !chan.getName().equalsIgnoreCase(newName)) {
            Channels.notify(this.sender, "channels.command.channel-name-in-use", new String[0]);
            return;
        }
        chan.setName(newName);
        if (!chan.getTag().equals(newTag)) {
            Channels.getInstance().unregisterTag(chan.getTag());
            chan.setTag(newTag);
            Channels.getInstance().registerTag(chan.getTag());
        }
        Channels.notify(this.sender, "channels.command.channel-modified", new String[0]);
    }

    @Override
    public boolean validateInput() {
        return this.args.length > 3;
    }
}

