/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.AbstractCommand;

public class IgnoreCommand
extends AbstractCommand {
    public IgnoreCommand(CommandSender sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        if (!(this.sender instanceof ProxiedPlayer)) {
            Channels.notify(this.sender, "channels.command.is-player-command", new String[0]);
            return;
        }
        if (this.args.length > 0) {
            UUID ignoreUUID;
            String ignoreName = this.args.length > 1 && this.args[0].equalsIgnoreCase("ignore") ? this.args[1] : this.args[0];
            if (!ignoreName.matches("^[a-zA-Z0-9_]+$")) {
                Channels.notify(this.sender, "channels.command.chatter-not-found", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)ignoreName));
                return;
            }
            Chatter ignore = Channels.getInstance().getChatterByName(ignoreName);
            if (ignore != null) {
                ignoreUUID = ignore.getPlayer().getUniqueId();
                ignoreName = ignore.getName();
            } else {
                ignoreUUID = Channels.getPlayerId(ignoreName);
                if (ignoreUUID == null) {
                    Channels.notify(this.sender, "channels.command.chatter-not-found", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)ignoreName));
                    return;
                }
            }
            Chatter chatter = Channels.getInstance().getChatter(((ProxiedPlayer)this.sender).getUniqueId());
            if (chatter.getIgnores().contains(ignoreUUID.toString())) {
                chatter.removeIgnore(ignoreUUID.toString());
                Channels.notify(this.sender, "channels.command.ignore-removed", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)ignoreName));
            } else {
                chatter.addIgnore(ignoreUUID.toString());
                Channels.notify(this.sender, "channels.command.ignore-added", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)ignoreName));
            }
        } else {
            Chatter chatter = Channels.getInstance().getChatter(((ProxiedPlayer)this.sender).getUniqueId());
            List<String> ignores = chatter.getIgnores();
            if (ignores.size() > 0) {
                Object ignoreList = Channels.getPlayerName(ignores.get(0));
                for (int i = 1; i < ignores.size(); ++i) {
                    ignoreList = (String)ignoreList + ", " + Channels.getPlayerName(ignores.get(i));
                }
                Channels.notify(this.sender, "channels.command.ignore-list-head", new String[0]);
                chatter.sendMessage((String)ignoreList);
            } else {
                Channels.notify(this.sender, "channels.command.ignore-list-empty", new String[0]);
            }
        }
    }

    @Override
    public boolean validateInput() {
        return true;
    }
}

