/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.YamlConfig;
import net.zaiyers.Channels.lib.minedown.MineDown;

public class LanguageConfig
extends YamlConfig {
    public LanguageConfig(File configFile) throws IOException {
        super(configFile);
    }

    @Override
    public void createDefaultConfig() {
        InputStream defaultConfig = Channels.getInstance().getResourceAsStream(this.configFile.getName());
        if (defaultConfig == null) {
            defaultConfig = Channels.getInstance().getResourceAsStream("lang.en.yml");
        }
        this.cfg = ymlCfg.load((Reader)new InputStreamReader(defaultConfig));
        this.save();
    }

    public String getTranslation(String key) {
        if (this.cfg.getString(key, "").isEmpty()) {
            return String.valueOf(ChatColor.RED) + "Unknown language key: " + String.valueOf(ChatColor.GOLD) + key;
        }
        return this.cfg.getString(key);
    }

    public BaseComponent[] getTranslationComponent(String key, String ... replacements) {
        return new MineDown(this.getTranslation(key)).replace(replacements).toComponent();
    }

    public BaseComponent[] getTranslationComponent(String key, Map<String, String> replacements) {
        return new MineDown(this.getTranslation(key)).replace(replacements).replaceFirst(true).toComponent();
    }
}

