/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.internal;

import java.util.concurrent.TimeUnit;
import net.zaiyers.Channels.lib.mongodb.ClientSessionOptions;
import net.zaiyers.Channels.lib.mongodb.MongoClientException;
import net.zaiyers.Channels.lib.mongodb.MongoException;
import net.zaiyers.Channels.lib.mongodb.MongoExecutionTimeoutException;
import net.zaiyers.Channels.lib.mongodb.MongoInternalException;
import net.zaiyers.Channels.lib.mongodb.ReadConcern;
import net.zaiyers.Channels.lib.mongodb.TransactionOptions;
import net.zaiyers.Channels.lib.mongodb.WriteConcern;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.ClientSession;
import net.zaiyers.Channels.lib.mongodb.client.TransactionBody;
import net.zaiyers.Channels.lib.mongodb.client.internal.ClientSessionClock;
import net.zaiyers.Channels.lib.mongodb.client.internal.MongoClientDelegate;
import net.zaiyers.Channels.lib.mongodb.internal.operation.AbortTransactionOperation;
import net.zaiyers.Channels.lib.mongodb.internal.operation.CommitTransactionOperation;
import net.zaiyers.Channels.lib.mongodb.internal.operation.ReadOperation;
import net.zaiyers.Channels.lib.mongodb.internal.operation.WriteOperation;
import net.zaiyers.Channels.lib.mongodb.internal.session.BaseClientSessionImpl;
import net.zaiyers.Channels.lib.mongodb.internal.session.ServerSessionPool;

final class ClientSessionImpl
extends BaseClientSessionImpl
implements ClientSession {
    private static final int MAX_RETRY_TIME_LIMIT_MS = 120000;
    private final MongoClientDelegate delegate;
    private TransactionState transactionState = TransactionState.NONE;
    private boolean messageSentInCurrentTransaction;
    private boolean commitInProgress;
    private TransactionOptions transactionOptions;

    ClientSessionImpl(ServerSessionPool serverSessionPool, Object originator, ClientSessionOptions options, MongoClientDelegate delegate) {
        super(serverSessionPool, originator, options);
        this.delegate = delegate;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.transactionState == TransactionState.IN || this.transactionState == TransactionState.COMMITTED && this.commitInProgress;
    }

    @Override
    public boolean notifyMessageSent() {
        if (this.hasActiveTransaction()) {
            boolean firstMessageInCurrentTransaction = !this.messageSentInCurrentTransaction;
            this.messageSentInCurrentTransaction = true;
            return firstMessageInCurrentTransaction;
        }
        if (this.transactionState == TransactionState.COMMITTED || this.transactionState == TransactionState.ABORTED) {
            this.cleanupTransaction(TransactionState.NONE);
        }
        return false;
    }

    @Override
    public void notifyOperationInitiated(Object operation) {
        Assertions.assertTrue(operation instanceof ReadOperation || operation instanceof WriteOperation);
        if (!this.hasActiveTransaction() && !(operation instanceof CommitTransactionOperation)) {
            Assertions.assertTrue(this.getPinnedServerAddress() == null || this.transactionState != TransactionState.ABORTED && this.transactionState != TransactionState.NONE);
            this.clearTransactionContext();
        }
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        Assertions.isTrue("in transaction", this.transactionState == TransactionState.IN || this.transactionState == TransactionState.COMMITTED);
        return this.transactionOptions;
    }

    @Override
    public void startTransaction() {
        this.startTransaction(TransactionOptions.builder().build());
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        Boolean snapshot = this.getOptions().isSnapshot();
        if (snapshot != null && snapshot.booleanValue()) {
            throw new IllegalArgumentException("Transactions are not supported in snapshot sessions");
        }
        Assertions.notNull("transactionOptions", transactionOptions);
        if (this.transactionState == TransactionState.IN) {
            throw new IllegalStateException("Transaction already in progress");
        }
        if (this.transactionState == TransactionState.COMMITTED) {
            this.cleanupTransaction(TransactionState.IN);
        } else {
            this.transactionState = TransactionState.IN;
        }
        this.getServerSession().advanceTransactionNumber();
        this.transactionOptions = TransactionOptions.merge(transactionOptions, this.getOptions().getDefaultTransactionOptions());
        WriteConcern writeConcern = this.transactionOptions.getWriteConcern();
        if (writeConcern == null) {
            throw new MongoInternalException("Invariant violated.  Transaction options write concern can not be null");
        }
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Transactions do not support unacknowledged write concern");
        }
        this.clearTransactionContext();
    }

    @Override
    public void commitTransaction() {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call commitTransaction after calling abortTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        try {
            if (this.messageSentInCurrentTransaction) {
                ReadConcern readConcern = this.transactionOptions.getReadConcern();
                if (readConcern == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
                }
                this.commitInProgress = true;
                this.delegate.getOperationExecutor().execute(new CommitTransactionOperation(Assertions.assertNotNull(this.transactionOptions.getWriteConcern()), this.transactionState == TransactionState.COMMITTED).recoveryToken(this.getRecoveryToken()).maxCommitTime(this.transactionOptions.getMaxCommitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), readConcern, this);
            }
        }
        catch (MongoException e) {
            this.clearTransactionContextOnError(e);
            throw e;
        }
        finally {
            this.transactionState = TransactionState.COMMITTED;
            this.commitInProgress = false;
        }
    }

    @Override
    public void abortTransaction() {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call abortTransaction twice");
        }
        if (this.transactionState == TransactionState.COMMITTED) {
            throw new IllegalStateException("Cannot call abortTransaction after calling commitTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        try {
            if (this.messageSentInCurrentTransaction) {
                ReadConcern readConcern = this.transactionOptions.getReadConcern();
                if (readConcern == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
                }
                this.delegate.getOperationExecutor().execute(new AbortTransactionOperation(Assertions.assertNotNull(this.transactionOptions.getWriteConcern())).recoveryToken(this.getRecoveryToken()), readConcern, this);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            this.clearTransactionContext();
            this.cleanupTransaction(TransactionState.ABORTED);
        }
    }

    private void clearTransactionContextOnError(MongoException e) {
        if (e.hasErrorLabel("TransientTransactionError") || e.hasErrorLabel("UnknownTransactionCommitResult")) {
            this.clearTransactionContext();
        }
    }

    @Override
    public <T> T withTransaction(TransactionBody<T> transactionBody) {
        return this.withTransaction(transactionBody, TransactionOptions.builder().build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T withTransaction(TransactionBody<T> transactionBody, TransactionOptions options) {
        Assertions.notNull("transactionBody", transactionBody);
        long startTime = ClientSessionClock.INSTANCE.now();
        block4: while (true) {
            T retVal;
            try {
                this.startTransaction(options);
                retVal = transactionBody.execute();
            }
            catch (Throwable e) {
                if (this.transactionState == TransactionState.IN) {
                    this.abortTransaction();
                }
                if (e instanceof MongoException && ((MongoException)e).hasErrorLabel("TransientTransactionError") && ClientSessionClock.INSTANCE.now() - startTime < 120000L) continue;
                throw e;
            }
            if (this.transactionState != TransactionState.IN) return retVal;
            while (true) {
                try {
                    this.commitTransaction();
                    return retVal;
                }
                catch (MongoException e) {
                    this.clearTransactionContextOnError(e);
                    if (ClientSessionClock.INSTANCE.now() - startTime >= 120000L) throw e;
                    this.applyMajorityWriteConcernToTransactionOptions();
                    if (!(e instanceof MongoExecutionTimeoutException) && e.hasErrorLabel("UnknownTransactionCommitResult")) continue;
                    if (!e.hasErrorLabel("TransientTransactionError")) throw e;
                    continue block4;
                }
                break;
            }
            break;
        }
    }

    private void applyMajorityWriteConcernToTransactionOptions() {
        WriteConcern writeConcern;
        this.transactionOptions = this.transactionOptions != null ? ((writeConcern = this.transactionOptions.getWriteConcern()) != null ? TransactionOptions.merge(TransactionOptions.builder().writeConcern(writeConcern.withW("majority")).build(), this.transactionOptions) : TransactionOptions.merge(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build(), this.transactionOptions)) : TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build();
    }

    @Override
    public void close() {
        try {
            if (this.transactionState == TransactionState.IN) {
                this.abortTransaction();
            }
        }
        finally {
            this.clearTransactionContext();
            super.close();
        }
    }

    private void cleanupTransaction(TransactionState nextState) {
        this.messageSentInCurrentTransaction = false;
        this.transactionOptions = null;
        this.transactionState = nextState;
    }

    private static enum TransactionState {
        NONE,
        IN,
        COMMITTED,
        ABORTED;

    }
}

