/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.internal;

import java.util.Collections;
import java.util.List;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistries;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.Channels.lib.bson.conversions.Bson;
import net.zaiyers.Channels.lib.mongodb.AutoEncryptionSettings;
import net.zaiyers.Channels.lib.mongodb.ClientSessionOptions;
import net.zaiyers.Channels.lib.mongodb.MongoClientException;
import net.zaiyers.Channels.lib.mongodb.MongoClientSettings;
import net.zaiyers.Channels.lib.mongodb.MongoDriverInformation;
import net.zaiyers.Channels.lib.mongodb.ReadPreference;
import net.zaiyers.Channels.lib.mongodb.TransactionOptions;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.ChangeStreamIterable;
import net.zaiyers.Channels.lib.mongodb.client.ClientSession;
import net.zaiyers.Channels.lib.mongodb.client.ListDatabasesIterable;
import net.zaiyers.Channels.lib.mongodb.client.MongoClient;
import net.zaiyers.Channels.lib.mongodb.client.MongoDatabase;
import net.zaiyers.Channels.lib.mongodb.client.MongoIterable;
import net.zaiyers.Channels.lib.mongodb.client.SynchronousContextProvider;
import net.zaiyers.Channels.lib.mongodb.client.internal.ChangeStreamIterableImpl;
import net.zaiyers.Channels.lib.mongodb.client.internal.Crypts;
import net.zaiyers.Channels.lib.mongodb.client.internal.ListDatabasesIterableImpl;
import net.zaiyers.Channels.lib.mongodb.client.internal.MongoClientDelegate;
import net.zaiyers.Channels.lib.mongodb.client.internal.MongoDatabaseImpl;
import net.zaiyers.Channels.lib.mongodb.client.internal.OperationExecutor;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterDescription;
import net.zaiyers.Channels.lib.mongodb.connection.SocketSettings;
import net.zaiyers.Channels.lib.mongodb.connection.SocketStreamFactory;
import net.zaiyers.Channels.lib.mongodb.connection.StreamFactory;
import net.zaiyers.Channels.lib.mongodb.connection.StreamFactoryFactory;
import net.zaiyers.Channels.lib.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClientMetadataHelper;
import net.zaiyers.Channels.lib.mongodb.internal.connection.Cluster;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DefaultClusterFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.InternalConnectionPoolSettings;
import net.zaiyers.Channels.lib.mongodb.internal.diagnostics.logging.Logger;
import net.zaiyers.Channels.lib.mongodb.internal.diagnostics.logging.Loggers;
import net.zaiyers.Channels.lib.mongodb.internal.event.EventListenerHelper;
import net.zaiyers.Channels.lib.mongodb.internal.session.ServerSessionPool;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public final class MongoClientImpl
implements MongoClient {
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final MongoClientSettings settings;
    private final MongoDriverInformation mongoDriverInformation;
    private final MongoClientDelegate delegate;

    public MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        this(MongoClientImpl.createCluster(settings, mongoDriverInformation), mongoDriverInformation, settings, null);
    }

    public MongoClientImpl(Cluster cluster, MongoDriverInformation mongoDriverInformation, MongoClientSettings settings, @Nullable OperationExecutor operationExecutor) {
        this.settings = Assertions.notNull("settings", settings);
        this.mongoDriverInformation = mongoDriverInformation;
        AutoEncryptionSettings autoEncryptionSettings = settings.getAutoEncryptionSettings();
        if (settings.getContextProvider() != null && !(settings.getContextProvider() instanceof SynchronousContextProvider)) {
            throw new IllegalArgumentException("The contextProvider must be an instance of " + SynchronousContextProvider.class.getName() + " when using the synchronous driver");
        }
        this.delegate = new MongoClientDelegate(Assertions.notNull("cluster", cluster), CodecRegistries.withUuidRepresentation(settings.getCodecRegistry(), settings.getUuidRepresentation()), this, operationExecutor, autoEncryptionSettings == null ? null : Crypts.createCrypt(this, autoEncryptionSettings), settings.getServerApi(), (SynchronousContextProvider)settings.getContextProvider());
        BsonDocument clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(settings.getApplicationName(), mongoDriverInformation);
        if (clientMetadataDocument == null) {
            LOGGER.info(String.format("MongoClient created with settings %s", settings));
        } else {
            LOGGER.info(String.format("MongoClient with metadata %s created with settings %s", clientMetadataDocument.toJson(), settings));
        }
    }

    @Override
    public MongoDatabase getDatabase(String databaseName) {
        return new MongoDatabaseImpl(databaseName, this.delegate.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getWriteConcern(), this.settings.getRetryWrites(), this.settings.getRetryReads(), this.settings.getReadConcern(), this.settings.getUuidRepresentation(), this.settings.getAutoEncryptionSettings(), this.delegate.getOperationExecutor());
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    @Override
    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases((Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return this.createListDatabasesIterable(null, clazz);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, (Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabasesIterable(clientSession, clazz);
    }

    @Override
    public ClientSession startSession() {
        return this.startSession(ClientSessionOptions.builder().defaultTransactionOptions(TransactionOptions.builder().readConcern(this.settings.getReadConcern()).writeConcern(this.settings.getWriteConcern()).build()).build());
    }

    @Override
    public ClientSession startSession(ClientSessionOptions options) {
        ClientSession clientSession = this.delegate.createClientSession(Assertions.notNull("options", options), this.settings.getReadConcern(), this.settings.getWriteConcern(), this.settings.getReadPreference());
        if (clientSession == null) {
            throw new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected");
        }
        return clientSession;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    @Override
    public ClusterDescription getClusterDescription() {
        return this.delegate.getCluster().getCurrentDescription();
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, "admin", this.delegate.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getReadConcern(), this.delegate.getOperationExecutor(), pipeline, resultClass, ChangeStreamLevel.CLIENT, this.settings.getRetryReads());
    }

    public Cluster getCluster() {
        return this.delegate.getCluster();
    }

    public CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        Assertions.notNull("settings", settings);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), InternalConnectionPoolSettings.builder().build(), MongoClientImpl.getStreamFactory(settings, false), MongoClientImpl.getStreamFactory(settings, true), settings.getCredential(), settings.getLoggerSettings(), EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList(), settings.getServerApi());
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings, boolean isHeartbeat) {
        SocketSettings socketSettings;
        StreamFactoryFactory streamFactoryFactory = settings.getStreamFactoryFactory();
        SocketSettings socketSettings2 = socketSettings = isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings();
        if (streamFactoryFactory == null) {
            return new SocketStreamFactory(socketSettings, settings.getSslSettings());
        }
        return streamFactoryFactory.create(socketSettings, settings.getSslSettings());
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(@Nullable ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clientSession, clazz, this.delegate.getCodecRegistry(), ReadPreference.primary(), this.delegate.getOperationExecutor(), this.settings.getRetryReads());
    }

    private MongoIterable<String> createListDatabaseNamesIterable(@Nullable ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(result -> result.getString("name").getValue());
    }

    public ServerSessionPool getServerSessionPool() {
        return this.delegate.getServerSessionPool();
    }

    public OperationExecutor getOperationExecutor() {
        return this.delegate.getOperationExecutor();
    }

    public MongoClientSettings getSettings() {
        return this.settings;
    }

    public MongoDriverInformation getMongoDriverInformation() {
        return this.mongoDriverInformation;
    }
}

