/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.model.search;

import java.util.Iterator;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.conversions.Bson;
import net.zaiyers.Channels.lib.mongodb.annotations.Beta;
import net.zaiyers.Channels.lib.mongodb.annotations.Evolving;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchConstructibleBson;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchPath;
import net.zaiyers.Channels.lib.mongodb.internal.Iterables;
import net.zaiyers.Channels.lib.mongodb.internal.client.model.Util;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchHighlight
extends Bson {
    public SearchHighlight maxCharsToExamine(int var1);

    public SearchHighlight maxNumPassages(int var1);

    public static SearchHighlight paths(SearchPath path, SearchPath ... paths) {
        return SearchHighlight.paths(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static SearchHighlight paths(Iterable<? extends SearchPath> paths) {
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBson(new BsonDocument("path", Util.combineToBsonValue(pathIterator, false)));
    }

    public static SearchHighlight of(Bson highlight) {
        return new SearchConstructibleBson(Assertions.notNull("highlight", highlight));
    }
}

