/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.zaiyers.Channels.lib.mongodb.MongoException;
import net.zaiyers.Channels.lib.mongodb.ReadPreference;
import net.zaiyers.Channels.lib.mongodb.annotations.Immutable;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterSettings;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterType;
import net.zaiyers.Channels.lib.mongodb.connection.ServerDescription;
import net.zaiyers.Channels.lib.mongodb.connection.ServerSettings;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterDescriptionHelper;
import net.zaiyers.Channels.lib.mongodb.internal.selector.ReadPreferenceServerSelector;
import net.zaiyers.Channels.lib.mongodb.internal.selector.WritableServerSelector;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

@Immutable
public class ClusterDescription {
    private final ClusterConnectionMode connectionMode;
    private final ClusterType type;
    private final List<ServerDescription> serverDescriptions;
    private final ClusterSettings clusterSettings;
    private final ServerSettings serverSettings;
    private final MongoException srvResolutionException;
    private final Integer logicalSessionTimeoutMinutes;

    public ClusterDescription(ClusterConnectionMode connectionMode, ClusterType type, List<ServerDescription> serverDescriptions) {
        this(connectionMode, type, serverDescriptions, null, null);
    }

    public ClusterDescription(ClusterConnectionMode connectionMode, ClusterType type, List<ServerDescription> serverDescriptions, @Nullable ClusterSettings clusterSettings, @Nullable ServerSettings serverSettings) {
        this(connectionMode, type, null, serverDescriptions, clusterSettings, serverSettings);
    }

    public ClusterDescription(ClusterConnectionMode connectionMode, ClusterType type, @Nullable MongoException srvResolutionException, List<ServerDescription> serverDescriptions, @Nullable ClusterSettings clusterSettings, @Nullable ServerSettings serverSettings) {
        Assertions.notNull("all", serverDescriptions);
        this.connectionMode = Assertions.notNull("connectionMode", connectionMode);
        this.type = Assertions.notNull("type", type);
        this.srvResolutionException = srvResolutionException;
        this.serverDescriptions = new ArrayList<ServerDescription>(serverDescriptions);
        this.clusterSettings = clusterSettings;
        this.serverSettings = serverSettings;
        this.logicalSessionTimeoutMinutes = this.calculateLogicalSessionTimeoutMinutes();
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public boolean isCompatibleWithDriver() {
        for (ServerDescription cur : this.serverDescriptions) {
            if (cur.isCompatibleWithDriver()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ServerDescription findServerIncompatiblyOlderThanDriver() {
        for (ServerDescription cur : this.serverDescriptions) {
            if (!cur.isIncompatiblyOlderThanDriver()) continue;
            return cur;
        }
        return null;
    }

    @Nullable
    public ServerDescription findServerIncompatiblyNewerThanDriver() {
        for (ServerDescription cur : this.serverDescriptions) {
            if (!cur.isIncompatiblyNewerThanDriver()) continue;
            return cur;
        }
        return null;
    }

    public boolean hasReadableServer(ReadPreference readPreference) {
        Assertions.notNull("readPreference", readPreference);
        return !new ReadPreferenceServerSelector(readPreference).select(this).isEmpty();
    }

    public boolean hasWritableServer() {
        return !new WritableServerSelector().select(this).isEmpty();
    }

    public ClusterConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public ClusterType getType() {
        return this.type;
    }

    @Nullable
    public MongoException getSrvResolutionException() {
        return this.srvResolutionException;
    }

    public List<ServerDescription> getServerDescriptions() {
        return Collections.unmodifiableList(this.serverDescriptions);
    }

    @Nullable
    public Integer getLogicalSessionTimeoutMinutes() {
        return this.logicalSessionTimeoutMinutes;
    }

    public boolean equals(Object o) {
        String thatExceptionMessage;
        Class<?> thatExceptionClass;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterDescription that = (ClusterDescription)o;
        if (this.connectionMode != that.connectionMode) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.serverDescriptions.size() != that.serverDescriptions.size()) {
            return false;
        }
        if (!this.serverDescriptions.containsAll(that.serverDescriptions)) {
            return false;
        }
        Class<?> thisExceptionClass = this.srvResolutionException != null ? this.srvResolutionException.getClass() : null;
        Class<?> clazz = thatExceptionClass = that.srvResolutionException != null ? that.srvResolutionException.getClass() : null;
        if (!Objects.equals(thisExceptionClass, thatExceptionClass)) {
            return false;
        }
        String thisExceptionMessage = this.srvResolutionException != null ? this.srvResolutionException.getMessage() : null;
        String string = thatExceptionMessage = that.srvResolutionException != null ? that.srvResolutionException.getMessage() : null;
        return Objects.equals(thisExceptionMessage, thatExceptionMessage);
    }

    public int hashCode() {
        int result = this.connectionMode.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.srvResolutionException == null ? 0 : this.srvResolutionException.hashCode());
        result = 31 * result + this.serverDescriptions.hashCode();
        return result;
    }

    public String toString() {
        return "ClusterDescription{type=" + (Object)((Object)this.getType()) + (this.srvResolutionException == null ? "" : ", srvResolutionException=" + this.srvResolutionException) + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", serverDescriptions=" + this.serverDescriptions + '}';
    }

    public String getShortDescription() {
        StringBuilder serverDescriptions = new StringBuilder();
        String delimiter = "";
        for (ServerDescription cur : this.serverDescriptions) {
            serverDescriptions.append(delimiter).append(cur.getShortDescription());
            delimiter = ", ";
        }
        if (this.srvResolutionException == null) {
            return String.format("{type=%s, servers=[%s]", new Object[]{this.type, serverDescriptions});
        }
        return String.format("{type=%s, srvResolutionException=%s, servers=[%s]", new Object[]{this.type, this.srvResolutionException, serverDescriptions});
    }

    @Nullable
    private Integer calculateLogicalSessionTimeoutMinutes() {
        Integer retVal = null;
        for (ServerDescription cur : ClusterDescriptionHelper.getServersByPredicate(this, serverDescription -> serverDescription.isPrimary() || serverDescription.isSecondary())) {
            Integer logicalSessionTimeoutMinutes = cur.getLogicalSessionTimeoutMinutes();
            if (logicalSessionTimeoutMinutes == null) {
                return null;
            }
            if (retVal == null) {
                retVal = logicalSessionTimeoutMinutes;
                continue;
            }
            retVal = Math.min(retVal, logicalSessionTimeoutMinutes);
        }
        return retVal;
    }
}

