/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.connection;

import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import net.zaiyers.Channels.lib.mongodb.MongoClientException;
import net.zaiyers.Channels.lib.mongodb.ServerAddress;
import net.zaiyers.Channels.lib.mongodb.UnixServerAddress;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.connection.BufferProvider;
import net.zaiyers.Channels.lib.mongodb.connection.SocketSettings;
import net.zaiyers.Channels.lib.mongodb.connection.SslSettings;
import net.zaiyers.Channels.lib.mongodb.connection.Stream;
import net.zaiyers.Channels.lib.mongodb.connection.StreamFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.PowerOfTwoBufferPool;
import net.zaiyers.Channels.lib.mongodb.internal.connection.SocketStream;
import net.zaiyers.Channels.lib.mongodb.internal.connection.UnixSocketChannelStream;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public class SocketStreamFactory
implements StreamFactory {
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final SocketFactory socketFactory;
    private final BufferProvider bufferProvider = PowerOfTwoBufferPool.DEFAULT;

    public SocketStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, null);
    }

    public SocketStreamFactory(SocketSettings settings, SslSettings sslSettings, @Nullable SocketFactory socketFactory) {
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.socketFactory = socketFactory;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        SocketStream stream;
        if (serverAddress instanceof UnixServerAddress) {
            if (this.sslSettings.isEnabled()) {
                throw new MongoClientException("Socket based connections do not support ssl");
            }
            stream = new UnixSocketChannelStream((UnixServerAddress)serverAddress, this.settings, this.sslSettings, this.bufferProvider);
        } else {
            stream = this.socketFactory != null ? new SocketStream(serverAddress, this.settings, this.sslSettings, this.socketFactory, this.bufferProvider) : (this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.settings, this.sslSettings, this.getSslContext().getSocketFactory(), this.bufferProvider) : new SocketStream(serverAddress, this.settings, this.sslSettings, SocketFactory.getDefault(), this.bufferProvider));
        }
        return stream;
    }

    private SSLContext getSslContext() {
        try {
            return Optional.ofNullable(this.sslSettings.getContext()).orElse(SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
    }
}

